/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.classes.evento.gtv;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte400.classes.evento.gtv.CTeDestinatarioGtv;
import com.fincatto.documentofiscal.cte400.classes.evento.gtv.CTeInformacaoEspecieGtv;
import com.fincatto.documentofiscal.cte400.classes.evento.gtv.CTeRemetenteGtv;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import org.simpleframework.xml.Element;

public class CTeInformacaoGtv
extends DFBase {
    @Element(name="nDoc")
    private String documento;
    @Element(name="id")
    private String id;
    @Element(name="serie", required=false)
    private String serie;
    @Element(name="subserie", required=false)
    private String subserie;
    @Element(name="dEmi")
    private ZonedDateTime dataEmissao;
    @Element(name="nDV")
    private Integer digitoVerificador;
    @Element(name="qCarga")
    private String quantidade;
    @Element(name="infEspecie")
    private List<CTeInformacaoEspecieGtv> especies;
    @Element(name="rem")
    private CTeRemetenteGtv remetente;
    @Element(name="dest")
    private CTeDestinatarioGtv destinatario;
    @Element(name="placa", required=false)
    private String placa;
    @Element(name="UF", required=false)
    private String uf;
    @Element(name="RNTRC", required=false)
    private String rntrc;

    public String getDocumento() {
        return this.documento;
    }

    public void setDocumento(String string) {
        DFStringValidador.tamanho20(string, "Documento");
        this.documento = string;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        DFStringValidador.tamanho20(string, "Id");
        this.id = string;
    }

    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String string) {
        DFStringValidador.tamanho3(string, "Serie");
        this.serie = string;
    }

    public String getSubserie() {
        return this.subserie;
    }

    public void setSubserie(String string) {
        DFStringValidador.tamanho3(string, "Subserie");
        this.subserie = string;
    }

    public ZonedDateTime getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(ZonedDateTime zonedDateTime) {
        this.dataEmissao = zonedDateTime;
    }

    public Integer getDigitoVerificador() {
        return this.digitoVerificador;
    }

    public void setDigitoVerificador(Integer n) {
        DFIntegerValidador.exatamente1(n, "Digito Verificador");
        this.digitoVerificador = n;
    }

    public String getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(BigDecimal bigDecimal) {
        this.quantidade = DFBigDecimalValidador.validaTamanho(bigDecimal, "Quantidade Carga CT-e", 11, 4, true);
    }

    public List<CTeInformacaoEspecieGtv> getEspecies() {
        return this.especies;
    }

    public void setEspecies(List<CTeInformacaoEspecieGtv> list) {
        this.especies = list;
    }

    public CTeRemetenteGtv getRemetente() {
        return this.remetente;
    }

    public void setRemetente(CTeRemetenteGtv cTeRemetenteGtv) {
        this.remetente = cTeRemetenteGtv;
    }

    public CTeDestinatarioGtv getDestinatario() {
        return this.destinatario;
    }

    public void setDestinatario(CTeDestinatarioGtv cTeDestinatarioGtv) {
        this.destinatario = cTeDestinatarioGtv;
    }

    public String getPlaca() {
        return this.placa;
    }

    public void setPlaca(String string) {
        DFStringValidador.placaDeVeiculo(string, "Placa");
        this.placa = string;
    }

    public String getUf() {
        return this.uf;
    }

    public void setUf(String string) {
        DFStringValidador.exatamente2(string, "UF");
        this.uf = string;
    }

    public String getRntrc() {
        return this.rntrc;
    }

    public void setRntrc(String string) {
        if (!string.equals("ISENTO")) {
            DFStringValidador.exatamente8(string, "RNTRC");
        }
        this.rntrc = string;
    }
}

