/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.mdfe3.classes.def.MDFTipoCarroceria;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoModalRodoviarioVeiculoProp;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import org.simpleframework.xml.Element;

public class MDFInfoModalRodoviarioVeiculoReboque
extends DFBase {
    private static final long serialVersionUID = -2787982058485353668L;
    @Element(name="cInt", required=false)
    protected String codigoInterno;
    @Element(name="placa")
    protected String placa;
    @Element(name="RENAVAM", required=false)
    protected String renavam;
    @Element(name="tara")
    protected String tara;
    @Element(name="capKG")
    private String capacidadeKG;
    @Element(name="capM3", required=false)
    protected String capacidadeM3;
    @Element(name="tpCar")
    protected MDFTipoCarroceria tipoCarroceria;
    @Element(name="UF")
    protected String unidadeFederativa;
    @Element(name="prop", required=false)
    protected MDFInfoModalRodoviarioVeiculoProp proprietario;

    public void setCodigoInterno(String string) {
        this.codigoInterno = DFStringValidador.validador(string, "Codigo interno Veiculo Reboque", 10, false, false);
    }

    public String getPlaca() {
        return this.placa;
    }

    public void setPlaca(String string) {
        DFStringValidador.placaDeVeiculo(string, "Placa do reboque");
        this.placa = string;
    }

    public String getRenavam() {
        return this.renavam;
    }

    public void setRenavam(String string) {
        this.renavam = DFStringValidador.validaIntervalo(string, 9, 11, "Renavam do reboque");
    }

    public void setTara(String string) {
        this.tara = DFStringValidador.capacidadeNDigitos(string, "Tara em reboque", 5);
    }

    public String getTara() {
        return this.tara;
    }

    public String getCapacidadeKG() {
        return this.capacidadeKG;
    }

    public void setCapacidadeKG(String string) {
        this.capacidadeKG = DFStringValidador.capacidadeNDigitos(string, "Capacidade em KG reboque", 5);
    }

    public String getCapacidadeM3() {
        return this.capacidadeM3;
    }

    public void setCapacidadeM3(String string) {
        this.capacidadeM3 = DFStringValidador.capacidadeNDigitos(string, "Capacidade em M3 reboque", 2);
    }

    public void setProprietario(MDFInfoModalRodoviarioVeiculoProp mDFInfoModalRodoviarioVeiculoProp) {
        this.proprietario = mDFInfoModalRodoviarioVeiculoProp;
    }

    public MDFInfoModalRodoviarioVeiculoProp getProprietario() {
        return this.proprietario;
    }

    public MDFTipoCarroceria getTipoCarroceria() {
        return this.tipoCarroceria;
    }

    public void setTipoCarroceria(MDFTipoCarroceria mDFTipoCarroceria) {
        this.tipoCarroceria = mDFTipoCarroceria;
    }

    public String getUnidadeFederativa() {
        return this.unidadeFederativa;
    }

    public void setUnidadeFederativa(String string) {
        this.unidadeFederativa = string;
    }

    public void setUnidadeFederativa(DFUnidadeFederativa dFUnidadeFederativa) {
        this.unidadeFederativa = dFUnidadeFederativa.getCodigo();
    }
}

