/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.mdfe3.MDFeConfig;
import com.fincatto.documentofiscal.mdfe3.classes.MDFAutorizador3;
import com.fincatto.documentofiscal.mdfe3.classes.nota.evento.MDFeDetalhamentoEvento;
import com.fincatto.documentofiscal.mdfe3.classes.nota.evento.MDFeEnviaEventoIncluirDFe;
import com.fincatto.documentofiscal.mdfe3.classes.nota.evento.MDFeEnviaEventoIncluirDFeInfDoc;
import com.fincatto.documentofiscal.mdfe3.classes.nota.evento.MDFeEvento;
import com.fincatto.documentofiscal.mdfe3.classes.nota.evento.MDFeInfoEvento;
import com.fincatto.documentofiscal.mdfe3.classes.nota.evento.MDFeRetorno;
import com.fincatto.documentofiscal.mdfe3.classes.parsers.MDFChaveParser;
import com.fincatto.documentofiscal.mdfe3.webservices.recepcaoevento.MDFeRecepcaoEventoStub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSIncluirDFe
implements DFLog {
    private static final String DESCRICAO_EVENTO = "Inclusao DF-e";
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("3.00");
    private static final String EVENTO_ENCERRAMENTO = "110115";
    private final MDFeConfig config;

    WSIncluirDFe(MDFeConfig mDFeConfig) {
        this.config = mDFeConfig;
    }

    MDFeRetorno incluirDFeAssinado(String string, String string2) throws Exception {
        OMElement oMElement = this.efetuaIncluirDFe(string2, string);
        return (MDFeRetorno)this.config.getPersister().read(MDFeRetorno.class, oMElement.toString());
    }

    MDFeRetorno incluirDFe(String string, String string2, String string3, String string4, List<MDFeEnviaEventoIncluirDFeInfDoc> list) throws Exception {
        String string5 = this.gerarDadosEncerramento(string, string2, string3, string4, list).toString();
        String string6 = new DFAssinaturaDigital(this.config).assinarDocumento(string5);
        OMElement oMElement = this.efetuaIncluirDFe(string6, string);
        return (MDFeRetorno)this.config.getPersister().read(MDFeRetorno.class, oMElement.toString());
    }

    private OMElement efetuaIncluirDFe(String string, String string2) throws Exception {
        MDFChaveParser mDFChaveParser = new MDFChaveParser(string2);
        MDFeRecepcaoEventoStub.MdfeCabecMsg mdfeCabecMsg = new MDFeRecepcaoEventoStub.MdfeCabecMsg();
        mdfeCabecMsg.setCUF(mDFChaveParser.getNFUnidadeFederativa().getCodigoIbge());
        mdfeCabecMsg.setVersaoDados(DFBigDecimalValidador.tamanho5Com2CasasDecimais(VERSAO_LEIAUTE, "Versao do Evento"));
        MDFeRecepcaoEventoStub.MdfeCabecMsgE mdfeCabecMsgE = new MDFeRecepcaoEventoStub.MdfeCabecMsgE();
        mdfeCabecMsgE.setMdfeCabecMsg(mdfeCabecMsg);
        MDFeRecepcaoEventoStub.MdfeDadosMsg mdfeDadosMsg = new MDFeRecepcaoEventoStub.MdfeDadosMsg();
        OMElement oMElement = AXIOMUtil.stringToOM((String)string);
        this.getLogger().debug(oMElement.toString());
        mdfeDadosMsg.setExtraElement(oMElement);
        MDFAutorizador3 mDFAutorizador3 = MDFAutorizador3.valueOfCodigoUF(mDFChaveParser.getNFUnidadeFederativa());
        String string3 = mDFAutorizador3.getMDFeRecepcaoEvento(this.config.getAmbiente());
        if (string3 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para RecepcaoEvento " + mDFChaveParser.getModelo().name() + ", autorizador " + mDFAutorizador3.name());
        }
        MDFeRecepcaoEventoStub.MdfeRecepcaoEventoResult mdfeRecepcaoEventoResult = new MDFeRecepcaoEventoStub(string3, this.config).mdfeRecepcaoEvento(mdfeDadosMsg, mdfeCabecMsgE);
        OMElement oMElement2 = mdfeRecepcaoEventoResult.getExtraElement();
        this.getLogger().debug(oMElement2.toString());
        return oMElement2;
    }

    private MDFeEvento gerarDadosEncerramento(String string, String string2, String string3, String string4, List<MDFeEnviaEventoIncluirDFeInfDoc> list) {
        MDFChaveParser mDFChaveParser = new MDFChaveParser(string);
        MDFeEnviaEventoIncluirDFe mDFeEnviaEventoIncluirDFe = new MDFeEnviaEventoIncluirDFe();
        mDFeEnviaEventoIncluirDFe.setDescricaoEvento(DESCRICAO_EVENTO);
        mDFeEnviaEventoIncluirDFe.setnProt(string2);
        mDFeEnviaEventoIncluirDFe.setCodigoMunicipioCarregamento(string3);
        mDFeEnviaEventoIncluirDFe.setNomeMunicipioCarregamento(string4);
        mDFeEnviaEventoIncluirDFe.setInfDoc(list);
        MDFeDetalhamentoEvento mDFeDetalhamentoEvento = new MDFeDetalhamentoEvento();
        mDFeDetalhamentoEvento.setEnviaEventoIncluirDFe(mDFeEnviaEventoIncluirDFe);
        mDFeDetalhamentoEvento.setVersaoEvento(VERSAO_LEIAUTE);
        MDFeInfoEvento mDFeInfoEvento = new MDFeInfoEvento();
        mDFeInfoEvento.setAmbiente(this.config.getAmbiente());
        mDFeInfoEvento.setChave(string);
        mDFeInfoEvento.setCnpj(mDFChaveParser.getCnpjEmitente());
        mDFeInfoEvento.setDataHoraEvento(ZonedDateTime.now(this.config.getTimeZone().toZoneId()));
        mDFeInfoEvento.setId(String.format("ID%s%s0%s", EVENTO_ENCERRAMENTO, string, "1"));
        mDFeInfoEvento.setNumeroSequencialEvento(1);
        mDFeInfoEvento.setOrgao(mDFChaveParser.getNFUnidadeFederativa().getCodigoIbge());
        mDFeInfoEvento.setCodigoEvento(EVENTO_ENCERRAMENTO);
        mDFeInfoEvento.setDetEvento(mDFeDetalhamentoEvento);
        MDFeEvento mDFeEvento = new MDFeEvento();
        mDFeEvento.setInfoEvento(mDFeInfoEvento);
        mDFeEvento.setVersao(VERSAO_LEIAUTE);
        return mDFeEvento;
    }
}

