/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.mdfe3.MDFeConfig;
import com.fincatto.documentofiscal.mdfe3.classes.MDFAutorizador3;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFe;
import com.fincatto.documentofiscal.mdfe3.classes.nota.envio.MDFEnvioRetorno;
import com.fincatto.documentofiscal.mdfe3.classes.nota.envio.MDFEnvioRetornoDados;
import com.fincatto.documentofiscal.mdfe3.webservices.recepcao.MDFeRecepcaoSincStub;
import com.fincatto.documentofiscal.mdfe3.webservices.recepcao.MDFeRecepcaoStub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Iterator;
import java.util.zip.GZIPOutputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;

class WSRecepcaoSinc
implements DFLog {
    private static final String MDFE_ELEMENTO = "MDFe";
    private final MDFeConfig config;

    WSRecepcaoSinc(MDFeConfig mDFeConfig) {
        this.config = mDFeConfig;
    }

    public MDFEnvioRetornoDados envioRecepcaoSinc(MDFe mDFe) throws Exception {
        String string = new DFAssinaturaDigital(this.config).assinarDocumento(mDFe.toString(), "infMDFe");
        MDFe mDFe2 = (MDFe)this.config.getPersister().read(MDFe.class, string);
        MDFEnvioRetorno mDFEnvioRetorno = this.comunicaSinc(string);
        return new MDFEnvioRetornoDados(mDFEnvioRetorno, mDFe2);
    }

    public MDFEnvioRetornoDados envioRecepcaoSincAssinado(String string) throws Exception {
        MDFe mDFe = (MDFe)this.config.getPersister().read(MDFe.class, string);
        MDFEnvioRetorno mDFEnvioRetorno = this.comunicaSinc(string);
        return new MDFEnvioRetornoDados(mDFEnvioRetorno, mDFe);
    }

    private MDFEnvioRetorno comunicaSinc(String string) throws Exception {
        System.setProperty("jdk.xml.maxOccurLimit", "10000");
        DFXMLValidador.validaMDFe(string);
        String string2 = WSRecepcaoSinc.encodeXmlToGZip(string);
        MDFeRecepcaoSincStub.MdfeDadosMsg mdfeDadosMsg = new MDFeRecepcaoSincStub.MdfeDadosMsg();
        mdfeDadosMsg.setExtraElement(string2);
        MDFAutorizador3 mDFAutorizador3 = MDFAutorizador3.valueOfCodigoUF(this.config.getCUF());
        String string3 = mDFAutorizador3.getMDFeRecepcaoSinc(this.config.getAmbiente());
        if (string3 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Recepcao do MDFe, autorizador " + mDFAutorizador3.name() + ", UF " + this.config.getCUF().name());
        }
        MDFeRecepcaoSincStub.MdfeRecepcaoSincResult mdfeRecepcaoSincResult = new MDFeRecepcaoSincStub(string3, this.config).mdfeRecepcaoSinc(mdfeDadosMsg);
        MDFEnvioRetorno mDFEnvioRetorno = (MDFEnvioRetorno)this.config.getPersister().read(MDFEnvioRetorno.class, mdfeRecepcaoSincResult.getExtraElement().toString());
        this.getLogger().debug(mDFEnvioRetorno.toString());
        return mDFEnvioRetorno;
    }

    private MDFeRecepcaoStub.MdfeCabecMsgE getCabecalhoSOAP() {
        MDFeRecepcaoStub.MdfeCabecMsg mdfeCabecMsg = new MDFeRecepcaoStub.MdfeCabecMsg();
        mdfeCabecMsg.setCUF(this.config.getCUF().getCodigoIbge());
        mdfeCabecMsg.setVersaoDados("3.00");
        MDFeRecepcaoStub.MdfeCabecMsgE mdfeCabecMsgE = new MDFeRecepcaoStub.MdfeCabecMsgE();
        mdfeCabecMsgE.setMdfeCabecMsg(mdfeCabecMsg);
        return mdfeCabecMsgE;
    }

    private OMElement mdfeToOMElement(String string) throws XMLStreamException {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        xMLInputFactory.setProperty("javax.xml.stream.isCoalescing", false);
        XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(new StringReader(string));
        StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(xMLStreamReader);
        OMElement oMElement = stAXOMBuilder.getDocumentElement();
        Iterator iterator = oMElement.getChildrenWithLocalName(MDFE_ELEMENTO);
        while (iterator.hasNext()) {
            OMElement oMElement2 = (OMElement)iterator.next();
            if (oMElement2 == null || !MDFE_ELEMENTO.equals(oMElement2.getLocalName())) continue;
            oMElement2.addAttribute("xmlns", "http://www.portalfiscal.inf.br/mdfe", null);
        }
        return oMElement;
    }

    private static String encodeXmlToGZip(String string) throws Exception {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            try (Object object = new GZIPOutputStream(byteArrayOutputStream);){
                ((FilterOutputStream)object).write(string.getBytes(StandardCharsets.UTF_8));
            }
            object = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
            return object;
        }
    }
}

