/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe.webservices.distribuicao;

import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoConsultaChaveAcesso;
import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoConsultaNSU;
import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoInt;
import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoIntRetorno;
import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoNSU;
import com.fincatto.documentofiscal.nfe.webservices.distribuicao.NFeDistribuicaoDFeSoapStub;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import com.fincatto.documentofiscal.utils.DFSocketFactory;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.lang3.StringUtils;

public class WSDistribuicaoNFe {
    private final NFeConfig config;

    public WSDistribuicaoNFe(NFeConfig nFeConfig) {
        this.config = nFeConfig;
    }

    public NFDistribuicaoIntRetorno consultar(String string, DFUnidadeFederativa dFUnidadeFederativa, String string2, String string3) throws Exception {
        return this.consultar(string, dFUnidadeFederativa, string2, string3, null);
    }

    public NFDistribuicaoIntRetorno consultar(String string, DFUnidadeFederativa dFUnidadeFederativa, String string2, String string3, String string4) throws Exception {
        try {
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new DFSocketFactory(this.config), 443));
            String string5 = this.gerarNFDistribuicaoInt(string, dFUnidadeFederativa, string2, string3, string4).toString();
            DFXMLValidador.validaConsultaDfe(string5);
            OMElement oMElement = AXIOMUtil.stringToOM((String)string5);
            NFeDistribuicaoDFeSoapStub.NFeDadosMsg_type0 nFeDadosMsg_type0 = new NFeDistribuicaoDFeSoapStub.NFeDadosMsg_type0();
            nFeDadosMsg_type0.setExtraElement(oMElement);
            NFeDistribuicaoDFeSoapStub.NFeDistDFeInteresse nFeDistDFeInteresse = new NFeDistribuicaoDFeSoapStub.NFeDistDFeInteresse();
            nFeDistDFeInteresse.setNFeDadosMsg(nFeDadosMsg_type0);
            NFeDistribuicaoDFeSoapStub nFeDistribuicaoDFeSoapStub = new NFeDistribuicaoDFeSoapStub(NFAutorizador400.AN.getNFeDistribuicaoDFe(this.config.getAmbiente()), this.config);
            NFeDistribuicaoDFeSoapStub.NFeDistDFeInteresseResponse nFeDistDFeInteresseResponse = nFeDistribuicaoDFeSoapStub.nfeDistDFeInteresse(nFeDistDFeInteresse);
            return (NFDistribuicaoIntRetorno)this.config.getPersister().read(NFDistribuicaoIntRetorno.class, nFeDistDFeInteresseResponse.getNFeDistDFeInteresseResult().getExtraElement().toString());
        }
        catch (RemoteException | XMLStreamException exception) {
            throw new Exception(exception.getMessage());
        }
    }

    public static String decodeGZipToXml(String string) throws Exception {
        if (string == null || string.length() == 0) {
            return "";
        }
        byte[] byArray = Base64.getDecoder().decode(string);
        try (GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));){
            String string2;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)gZIPInputStream, StandardCharsets.UTF_8));){
                String string3;
                StringBuilder stringBuilder = new StringBuilder();
                while ((string3 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string3);
                }
                string2 = stringBuilder.toString();
            }
            return string2;
        }
    }

    private NFDistribuicaoInt gerarNFDistribuicaoInt(String string, DFUnidadeFederativa dFUnidadeFederativa, String string2, String string3, String string4) {
        NFDistribuicaoInt nFDistribuicaoInt = new NFDistribuicaoInt();
        nFDistribuicaoInt.setVersao("1.01");
        nFDistribuicaoInt.setAmbiente(this.config.getAmbiente());
        nFDistribuicaoInt.setUnidadeFederativaAutor(dFUnidadeFederativa);
        if (string.length() == 11) {
            nFDistribuicaoInt.setCpf(string);
        } else {
            nFDistribuicaoInt.setCnpj(string);
        }
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            nFDistribuicaoInt.setConsultaChaveAcesso(new NFDistribuicaoConsultaChaveAcesso().setChaveAcesso(string2));
        } else if (StringUtils.isNotBlank((CharSequence)string4)) {
            nFDistribuicaoInt.setDistribuicaoNSU(new NFDistribuicaoNSU().setUltimoNSU(string4));
        } else {
            nFDistribuicaoInt.setConsultaNSU(new NFDistribuicaoConsultaNSU().setNsu(string3));
        }
        return nFDistribuicaoInt;
    }
}

