/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe310.classes.NFAutorizador31;
import com.fincatto.documentofiscal.nfe310.classes.evento.NFEnviaEventoRetorno;
import com.fincatto.documentofiscal.nfe310.classes.evento.cancelamento.NFEnviaEventoCancelamento;
import com.fincatto.documentofiscal.nfe310.classes.evento.cancelamento.NFEventoCancelamento;
import com.fincatto.documentofiscal.nfe310.classes.evento.cancelamento.NFInfoCancelamento;
import com.fincatto.documentofiscal.nfe310.classes.evento.cancelamento.NFInfoEventoCancelamento;
import com.fincatto.documentofiscal.nfe310.parsers.NotaFiscalChaveParser;
import com.fincatto.documentofiscal.nfe310.webservices.gerado.RecepcaoEventoStub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Collections;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSCancelamento
implements DFLog {
    private static final String DESCRICAO_EVENTO = "Cancelamento";
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("1.00");
    private static final String EVENTO_CANCELAMENTO = "110111";
    private final NFeConfig config;

    WSCancelamento(NFeConfig nFeConfig) {
        this.config = nFeConfig;
    }

    NFEnviaEventoRetorno cancelaNotaAssinada(String string, String string2) throws Exception {
        OMElement oMElement = this.efetuaCancelamento(string2, string);
        return (NFEnviaEventoRetorno)this.config.getPersister().read(NFEnviaEventoRetorno.class, oMElement.toString());
    }

    NFEnviaEventoRetorno cancelaNota(String string, String string2, String string3) throws Exception {
        String string4 = this.gerarDadosCancelamento(string, string2, string3).toString();
        String string5 = new DFAssinaturaDigital(this.config).assinarDocumento(string4);
        OMElement oMElement = this.efetuaCancelamento(string5, string);
        return (NFEnviaEventoRetorno)this.config.getPersister().read(NFEnviaEventoRetorno.class, oMElement.toString());
    }

    private OMElement efetuaCancelamento(String string, String string2) throws Exception {
        String string3;
        RecepcaoEventoStub.NfeCabecMsg nfeCabecMsg = new RecepcaoEventoStub.NfeCabecMsg();
        nfeCabecMsg.setCUF(this.config.getCUF().getCodigoIbge());
        nfeCabecMsg.setVersaoDados(VERSAO_LEIAUTE.toPlainString());
        RecepcaoEventoStub.NfeCabecMsgE nfeCabecMsgE = new RecepcaoEventoStub.NfeCabecMsgE();
        nfeCabecMsgE.setNfeCabecMsg(nfeCabecMsg);
        RecepcaoEventoStub.NfeDadosMsg nfeDadosMsg = new RecepcaoEventoStub.NfeDadosMsg();
        OMElement oMElement = AXIOMUtil.stringToOM((String)string);
        this.getLogger().debug(oMElement.toString());
        nfeDadosMsg.setExtraElement(oMElement);
        NotaFiscalChaveParser notaFiscalChaveParser = new NotaFiscalChaveParser(string2);
        NFAutorizador31 nFAutorizador31 = NFAutorizador31.valueOfChaveAcesso(string2);
        String string4 = string3 = DFModelo.NFCE.equals((Object)notaFiscalChaveParser.getModelo()) ? nFAutorizador31.getNfceRecepcaoEvento(this.config.getAmbiente()) : nFAutorizador31.getRecepcaoEvento(this.config.getAmbiente());
        if (string3 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para RecepcaoEvento " + notaFiscalChaveParser.getModelo().name() + ", autorizador " + nFAutorizador31.name());
        }
        RecepcaoEventoStub.NfeRecepcaoEventoResult nfeRecepcaoEventoResult = new RecepcaoEventoStub(string3, this.config).nfeRecepcaoEvento(nfeDadosMsg, nfeCabecMsgE);
        OMElement oMElement2 = nfeRecepcaoEventoResult.getExtraElement();
        this.getLogger().debug(oMElement2.toString());
        return oMElement2;
    }

    private NFEnviaEventoCancelamento gerarDadosCancelamento(String string, String string2, String string3) {
        NotaFiscalChaveParser notaFiscalChaveParser = new NotaFiscalChaveParser(string);
        NFInfoCancelamento nFInfoCancelamento = new NFInfoCancelamento();
        nFInfoCancelamento.setDescricaoEvento(DESCRICAO_EVENTO);
        nFInfoCancelamento.setVersao(VERSAO_LEIAUTE);
        nFInfoCancelamento.setJustificativa(string3);
        nFInfoCancelamento.setProtocoloAutorizacao(string2);
        NFInfoEventoCancelamento nFInfoEventoCancelamento = new NFInfoEventoCancelamento();
        nFInfoEventoCancelamento.setAmbiente(this.config.getAmbiente());
        nFInfoEventoCancelamento.setChave(string);
        nFInfoEventoCancelamento.setCnpj(notaFiscalChaveParser.getCnpjEmitente());
        nFInfoEventoCancelamento.setDataHoraEvento(ZonedDateTime.now(this.config.getTimeZone().toZoneId()));
        nFInfoEventoCancelamento.setId(String.format("ID%s%s0%s", EVENTO_CANCELAMENTO, string, "1"));
        nFInfoEventoCancelamento.setNumeroSequencialEvento(1);
        nFInfoEventoCancelamento.setOrgao(notaFiscalChaveParser.getNFUnidadeFederativa());
        nFInfoEventoCancelamento.setCodigoEvento(EVENTO_CANCELAMENTO);
        nFInfoEventoCancelamento.setVersaoEvento(VERSAO_LEIAUTE);
        nFInfoEventoCancelamento.setCancelamento(nFInfoCancelamento);
        NFEventoCancelamento nFEventoCancelamento = new NFEventoCancelamento();
        nFEventoCancelamento.setInfoEvento(nFInfoEventoCancelamento);
        nFEventoCancelamento.setVersao(VERSAO_LEIAUTE);
        NFEnviaEventoCancelamento nFEnviaEventoCancelamento = new NFEnviaEventoCancelamento();
        nFEnviaEventoCancelamento.setEvento(Collections.singletonList(nFEventoCancelamento));
        nFEnviaEventoCancelamento.setIdLote(Long.toString(ZonedDateTime.now(this.config.getTimeZone().toZoneId()).toInstant().toEpochMilli()));
        nFEnviaEventoCancelamento.setVersao(VERSAO_LEIAUTE);
        return nFEnviaEventoCancelamento;
    }
}

