/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaCOFINS;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoCOFINSAliquota
extends DFBase {
    private static final long serialVersionUID = -8079337130690627887L;
    private static final List<NFNotaInfoSituacaoTributariaCOFINS> SITUACOES_VALIDAS = Arrays.asList(NFNotaInfoSituacaoTributariaCOFINS.CST_01, NFNotaInfoSituacaoTributariaCOFINS.CST_02);
    @Element(name="CST")
    private NFNotaInfoSituacaoTributariaCOFINS situacaoTributaria;
    @Element(name="vBC")
    private String valorBaseCalculo;
    @Element(name="pCOFINS")
    private String percentualAliquota;
    @Element(name="vCOFINS")
    private String valor;

    public void setSituacaoTributaria(NFNotaInfoSituacaoTributariaCOFINS nFNotaInfoSituacaoTributariaCOFINS) {
        if (!SITUACOES_VALIDAS.contains((Object)nFNotaInfoSituacaoTributariaCOFINS)) {
            throw new IllegalStateException("Situacao tributaria invalido no item COFINS Aliquota.");
        }
        this.situacaoTributaria = nFNotaInfoSituacaoTributariaCOFINS;
    }

    public void setValorBaseCalculo(BigDecimal bigDecimal) {
        this.valorBaseCalculo = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Base de Calculo COFINS Item");
    }

    public void setPercentualAliquota(BigDecimal bigDecimal) {
        this.percentualAliquota = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Aliquota COFINS Item");
    }

    public void setValor(BigDecimal bigDecimal) {
        this.valor = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor COFINS Item");
    }

    public NFNotaInfoSituacaoTributariaCOFINS getSituacaoTributaria() {
        return this.situacaoTributaria;
    }

    public String getValorBaseCalculo() {
        return this.valorBaseCalculo;
    }

    public String getPercentualAliquota() {
        return this.percentualAliquota;
    }

    public String getValor() {
        return this.valor;
    }
}

