/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaPIS;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoPISQuantidade
extends DFBase {
    private static final long serialVersionUID = 8768801743177271906L;
    @Element(name="CST")
    private NFNotaInfoSituacaoTributariaPIS situacaoTributaria = null;
    @Element(name="qBCProd")
    private String quantidadeVendida = null;
    @Element(name="vAliqProd")
    private String valorAliquota = null;
    @Element(name="vPIS")
    private String valorTributo = null;

    public void setSituacaoTributaria(NFNotaInfoSituacaoTributariaPIS nFNotaInfoSituacaoTributariaPIS) {
        if (!NFNotaInfoSituacaoTributariaPIS.CST_03.equals((Object)nFNotaInfoSituacaoTributariaPIS)) {
            throw new IllegalStateException("Situacao tributaria invalido no item PIS Quantidade");
        }
        this.situacaoTributaria = nFNotaInfoSituacaoTributariaPIS;
    }

    public void setQuantidadeVendida(BigDecimal bigDecimal) {
        this.quantidadeVendida = DFBigDecimalValidador.tamanho16ComAte4CasasDecimais(bigDecimal, "Quantidade Vendida PIS Qtde Item");
    }

    public void setValorAliquota(BigDecimal bigDecimal) {
        this.valorAliquota = DFBigDecimalValidador.tamanho15Com4CasasDecimais(bigDecimal, "Valor Aliquota PIS Qtde Item");
    }

    public void setValorTributo(BigDecimal bigDecimal) {
        this.valorTributo = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Tributo PIS Qtde Item");
    }

    public NFNotaInfoSituacaoTributariaPIS getSituacaoTributaria() {
        return this.situacaoTributaria;
    }

    public String getQuantidadeVendida() {
        return this.quantidadeVendida;
    }

    public String getValorAliquota() {
        return this.valorAliquota;
    }

    public String getValorTributo() {
        return this.valorTributo;
    }
}

