/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import com.fincatto.documentofiscal.nfe400.classes.cadastro.NFConsultaCadastro;
import com.fincatto.documentofiscal.nfe400.classes.cadastro.NFInfoConsultaCadastro;
import com.fincatto.documentofiscal.nfe400.classes.cadastro.NFRetornoConsultaCadastro;
import com.fincatto.documentofiscal.nfe400.webservices.consultacadastro.CadConsultaCadastro4Stub;
import com.fincatto.documentofiscal.nfe400.webservices.consultacadastro.MTCadConsultaCadastro4Stub;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSConsultaCadastro
implements DFLog {
    private static final String NOME_SERVICO = "CONS-CAD";
    private static final String VERSAO_SERVICO = "2.00";
    private final NFeConfig config;

    WSConsultaCadastro(NFeConfig nFeConfig) {
        this.config = nFeConfig;
    }

    NFRetornoConsultaCadastro consultaCadastro(String string, DFUnidadeFederativa dFUnidadeFederativa) throws Exception {
        NFConsultaCadastro nFConsultaCadastro = this.getDadosConsulta(string, dFUnidadeFederativa);
        String string2 = nFConsultaCadastro.toString();
        this.getLogger().debug(string2);
        OMElement oMElement = AXIOMUtil.stringToOM((String)string2);
        OMElement oMElement2 = this.efetuaConsulta(dFUnidadeFederativa, oMElement);
        this.getLogger().debug(oMElement2.toString());
        return (NFRetornoConsultaCadastro)this.config.getPersister().read(NFRetornoConsultaCadastro.class, oMElement2.toString());
    }

    private OMElement efetuaConsulta(DFUnidadeFederativa dFUnidadeFederativa, OMElement oMElement) throws Exception {
        NFAutorizador400 nFAutorizador400 = NFAutorizador400.valueOfCodigoUF(dFUnidadeFederativa);
        String string = nFAutorizador400.getConsultaCadastro(this.config.getAmbiente());
        if (string == null) {
            throw new IllegalStateException(String.format("UF %s nao possui autorizador para este servico", dFUnidadeFederativa.getDescricao()));
        }
        if (DFUnidadeFederativa.MT.equals((Object)dFUnidadeFederativa)) {
            MTCadConsultaCadastro4Stub.ConsultaCadastro consultaCadastro = new MTCadConsultaCadastro4Stub.ConsultaCadastro();
            MTCadConsultaCadastro4Stub.NfeDadosMsg_type0 nfeDadosMsg_type0 = new MTCadConsultaCadastro4Stub.NfeDadosMsg_type0();
            nfeDadosMsg_type0.setExtraElement(oMElement);
            consultaCadastro.setNfeDadosMsg(nfeDadosMsg_type0);
            return new MTCadConsultaCadastro4Stub(string).consultaCadastro(consultaCadastro).getConsultaCadastroResult().getExtraElement();
        }
        CadConsultaCadastro4Stub.NfeDadosMsg nfeDadosMsg = new CadConsultaCadastro4Stub.NfeDadosMsg();
        nfeDadosMsg.setExtraElement(oMElement);
        return new CadConsultaCadastro4Stub(string, this.config).consultaCadastro(nfeDadosMsg).getExtraElement();
    }

    private NFConsultaCadastro getDadosConsulta(String string, DFUnidadeFederativa dFUnidadeFederativa) {
        NFConsultaCadastro nFConsultaCadastro = new NFConsultaCadastro();
        nFConsultaCadastro.setVersao(VERSAO_SERVICO);
        nFConsultaCadastro.setConsultaCadastro(new NFInfoConsultaCadastro());
        nFConsultaCadastro.getConsultaCadastro().setCnpj(string);
        nFConsultaCadastro.getConsultaCadastro().setServico(NOME_SERVICO);
        nFConsultaCadastro.getConsultaCadastro().setUf(dFUnidadeFederativa.getCodigo());
        return nFConsultaCadastro;
    }

    NFRetornoConsultaCadastro consultaCadastroInscEst(String string, DFUnidadeFederativa dFUnidadeFederativa) throws Exception {
        NFConsultaCadastro nFConsultaCadastro = this.getDadosConsultaInscEst(string, dFUnidadeFederativa);
        String string2 = nFConsultaCadastro.toString();
        this.getLogger().debug(string2);
        OMElement oMElement = AXIOMUtil.stringToOM((String)string2);
        OMElement oMElement2 = this.efetuaConsulta(dFUnidadeFederativa, oMElement);
        this.getLogger().debug(oMElement2.toString());
        return (NFRetornoConsultaCadastro)this.config.getPersister().read(NFRetornoConsultaCadastro.class, oMElement2.toString());
    }

    private NFConsultaCadastro getDadosConsultaInscEst(String string, DFUnidadeFederativa dFUnidadeFederativa) {
        NFConsultaCadastro nFConsultaCadastro = new NFConsultaCadastro();
        nFConsultaCadastro.setVersao(VERSAO_SERVICO);
        nFConsultaCadastro.setConsultaCadastro(new NFInfoConsultaCadastro());
        nFConsultaCadastro.getConsultaCadastro().setInscricaoEstadual(string);
        nFConsultaCadastro.getConsultaCadastro().setServico(NOME_SERVICO);
        nFConsultaCadastro.getConsultaCadastro().setUf(dFUnidadeFederativa.getCodigo());
        return nFConsultaCadastro;
    }
}

