/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.utils;

import com.fincatto.documentofiscal.DFConfig;
import com.fincatto.documentofiscal.DFLog;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.X509KeyManager;

public class DFKeyManager
implements X509KeyManager,
DFLog {
    private KeyStore ks;
    private String alias;
    private String password;

    public DFKeyManager(DFConfig dFConfig) throws KeyStoreException {
        this.ks = dFConfig.getCertificadoKeyStore();
        this.alias = DFKeyManager.getAlias(this.ks);
        this.password = dFConfig.getCertificadoSenha();
    }

    @Override
    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        return this.alias;
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        return this.alias;
    }

    @Override
    public String[] getClientAliases(String string, Principal[] principalArray) {
        return new String[]{this.alias};
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        return new String[]{this.alias};
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        try {
            Certificate[] certificateArray = this.ks.getCertificateChain(string);
            X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
            System.arraycopy(certificateArray, 0, x509CertificateArray, 0, certificateArray.length);
            return x509CertificateArray;
        }
        catch (KeyStoreException keyStoreException) {
            this.getLogger().error("N\u00e3o foi poss\u00edvel carregar o keystore para o alias:" + string, (Throwable)keyStoreException);
            return null;
        }
    }

    @Override
    public PrivateKey getPrivateKey(String string) {
        try {
            return (PrivateKey)this.ks.getKey(string, this.password == null ? null : this.password.toCharArray());
        }
        catch (Exception exception) {
            this.getLogger().error("N\u00e3o foi poss\u00edvel carregar o keystore para o alias:" + string, (Throwable)exception);
            return null;
        }
    }

    private static String getAlias(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            return string;
        }
        throw new KeyStoreException("Nenhum alias encontrado no certificado");
    }
}

