/*
 * Decompiled with CFR 0.152.
 */
package com.zenvia.api.sdk.client;

import com.zenvia.api.sdk.client.AbstractClient;
import com.zenvia.api.sdk.client.ChannelType;
import com.zenvia.api.sdk.client.exceptions.HttpConnectionFailException;
import com.zenvia.api.sdk.client.exceptions.HttpConnectionTimeoutException;
import com.zenvia.api.sdk.client.exceptions.HttpIOException;
import com.zenvia.api.sdk.client.exceptions.HttpSocketTimeoutException;
import com.zenvia.api.sdk.client.exceptions.UnsuccessfulRequestException;
import com.zenvia.api.sdk.client.exceptions.UnsupportedContentException;
import com.zenvia.api.sdk.contents.Content;
import com.zenvia.api.sdk.messages.Message;
import com.zenvia.api.sdk.messages.MessageRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Channel {
    public final ChannelType type;
    public final String url;
    protected final AbstractClient client;

    protected Channel(ChannelType type, AbstractClient client) {
        this.type = type;
        this.client = client;
        this.url = client.getApiUrl() + type.messagePath;
    }

    public Message sendMessage(String from, String to, Content ... contents) throws UnsupportedContentException, UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        return this.sendMessage(new MessageRequest(from, to, contents == null ? null : Arrays.asList(contents)));
    }

    public Message sendMessage(String from, String to, Collection<Content> contents) throws UnsupportedContentException, UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        return this.sendMessage(new MessageRequest(from, to, (List<Content>)(contents == null ? null : new ArrayList<Content>(contents))));
    }

    public Message sendMessage(String from, String to, List<Content> contents) throws UnsupportedContentException, UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        return this.sendMessage(new MessageRequest(from, to, contents));
    }

    protected Message sendMessage(MessageRequest messageRequest) throws UnsupportedContentException, UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        messageRequest.contents.forEach(content -> this.contentSupportValidation((Content)content));
        return this.client.sendMessage(this, messageRequest);
    }

    private void contentSupportValidation(Content content) throws UnsupportedContentException {
        if (!this.type.supportsContent(content.type)) {
            throw new UnsupportedContentException(content.type, this.type);
        }
    }

    public String toString() {
        return this.type.name();
    }
}

