/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.utils.DFCadeiaCertificados;
import com.sun.javafx.application.LauncherImpl;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.exception.ToolException;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basenativeequipments.comunicadorconsultapreco.ComunicadorConsultaPrecoTCPSocket;
import com.touchcomp.basenativeequipments.comunicadorconsultapreco.InterfaceConsultaDadosProduto;
import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.MainEvents;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.DialogsHelperShowInfoFrame;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.controller.header.HeaderController;
import com.touchcomp.touchnfce.controller.splash.impl.SplashIniciaSistema;
import com.touchcomp.touchnfce.controller.status.StatusConexaoController;
import com.touchcomp.touchnfce.helpers.preco.HelperPrecosTerminalConsulta;
import com.touchcomp.touchnfce.listeners.ShortcutListener;
import com.touchcomp.touchnfce.lockinstance.BlockMoreInstanceApp;
import com.touchcomp.touchnfce.modeltemp.ControllerPath;
import com.touchcomp.touchnfce.properties.ConfPropertiesLoader;
import com.touchcomp.touchnfce.properties.PropertiesBD;
import com.touchcomp.touchnfce.properties.PropertiesLoader;
import com.touchcomp.touchnfce.repo.RepoBaseJPAImpl;
import com.touchcomp.touchnfce.service.impl.ServiceMsgComandosNFCe;
import com.touchcomp.touchnfce.service.impl.ServiceOtimizacaoBanco;
import com.touchcomp.touchnfce.utils.Style;
import com.touchcomp.touchnfce.utils.UtilDataSincCheck;
import com.touchcomp.touchnfce.utils.UtilImageSvg;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.application.Preloader;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ButtonType;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.commons.io.FileUtils;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@ComponentScan(value={"com.touchcomp.touchnfce"})
@SpringBootApplication
@EnableJpaRepositories(repositoryBaseClass=RepoBaseJPAImpl.class)
public class Main
extends Application {
    private static ApplicationContext context;
    private Stage primaryStage;
    private BorderPane rootLayout;
    private Scene scene;
    private static Main instance;
    private BaseController atualController;
    private BaseController lastController;
    private ControllerPath lastControllerPath;
    private ControllerPath atualControllerPath;
    private static TrayIcon trayIcon;
    private BooleanProperty ready = new SimpleBooleanProperty(false);
    private FXMLLoader screenLoader;
    private StatusConexaoController footerController;
    private HeaderController headerController;
    private ArrayList<Stage> openedDialogs;

    public static Main get() {
        return instance;
    }

    public static void setContext(ApplicationContext context) {
        Main.context = context;
    }

    public void init() throws Exception {
        super.init();
        this.openedDialogs = new ArrayList();
        instance = this;
        this.longStart();
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[]{Main.class});
        context = builder.run(this.getParameters().getRaw().toArray(new String[0]));
        this.screenLoader = new FXMLLoader();
        this.getFxmlLoader().setControllerFactory(arg_0 -> ((ApplicationContext)this.getContext()).getBean(arg_0));
    }

    private void longStart() {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                int max = 100;
                for (int i = 1; i <= max; ++i) {
                    Thread.sleep(100L);
                    Main.this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification((double)i / (double)max));
                }
                Main.this.ready.setValue(Boolean.TRUE);
                Main.this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.StateChangeNotification(Preloader.StateChangeNotification.Type.BEFORE_START));
                return null;
            }
        };
        new Thread((Runnable)task).start();
    }

    public void start(Stage stage) throws Exception {
        try {
            this.finalizarComandosEncerramentoSistema();
            if (ConfPropertiesLoader.get().getPossuiConsultaPreco() != null && ToolMethods.isEquals((Object)Short.valueOf(ConfPropertiesLoader.get().getPossuiConsultaPreco()), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                this.iniciarTerminalConsultaPrecos();
            }
            MainEvents.setInstance(new MainEvents(stage));
            this.primaryStage = stage;
            this.initStage(this.primaryStage);
            this.setSize(700, 400);
            FXMLLoader loader = new FXMLLoader();
            if (StaticObjects.getDadosSincronizacao().getAppConfigurado() != 1) {
                Alerts.showAlertWarning("Aten\u00e7\u00e3o", "Seja Bem Vindo! Este \u00e9 o seu primeiro acesso e precisamos de configurar o sistema. Isso deve levar alguns minutos.");
                loader.setLocation(((Object)((Object)this)).getClass().getResource(Controllers.OPCOES_SINCRONIZACAO.getViewPath()));
                this.setSize(Controllers.OPCOES_SINCRONIZACAO.getWidth(), Controllers.OPCOES_SINCRONIZACAO.getHeight());
            } else if (StaticObjects.getDadosSincronizacao().getSincronizadoCompeletamente() != 1) {
                Alerts.showAlertWarning("Aten\u00e7\u00e3o", "O sistema ainda n\u00e3o foi completamente sincronizado. Iremos sincronizar. Deve levar alguns minutos, por favor aguarde.");
                loader.setLocation(((Object)((Object)this)).getClass().getResource(Controllers.SPLASH_SINC.getViewPath()));
                this.setSize(Controllers.SPLASH_SINC.getWidth(), Controllers.SPLASH_SINC.getHeight());
            } else {
                this.primaryStage.initStyle(StageStyle.UNDECORATED);
                loader.setLocation(((Object)((Object)this)).getClass().getResource(Controllers.LOGIN.getViewPath()));
                this.checaDataPCVsUltSinc();
            }
            AnchorPane footerLayout = (AnchorPane)loader.load();
            footerLayout.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/styles/style.css").toExternalForm());
            this.rootLayout.setCenter((Node)footerLayout);
            this.primaryStage.setResizable(false);
            this.addListenersResize();
            this.primaryStage.show();
            this.setOnCloseQuestion();
            this.otimizarBancoDados();
        }
        catch (Exception e) {
            e.printStackTrace();
            TLogger.get(((Object)((Object)this)).getClass()).error(e.getClass(), (Throwable)e);
        }
    }

    private void checaDataPCVsUltSinc() {
        UtilDataSincCheck.checaDataPCVsUltSinc();
    }

    private void otimizarBancoDados() {
        Date hoje;
        Date last;
        String str = ConfPropertiesLoader.get().getLastOtimizacaoBanco();
        if (str != null && str.length() > 0 && ToolDate.difBetweenDatesInDays((Date)(last = ToolDate.strToDate((String)str)), (Date)(hoje = new Date())) < 20L) {
            return;
        }
        new Thread(this){

            @Override
            public void run() {
                ServiceOtimizacaoBanco service = Main.getBean(ServiceOtimizacaoBanco.class);
                service.otimizarBanco();
                ConfPropertiesLoader.get().setLastOtimizacaoBanco(ToolDate.dateToStr((Date)new Date()));
            }
        }.start();
    }

    private void initStage(Stage stage) {
        stage.setResizable(false);
        stage.setTitle("Touch Comp PDV");
        this.initRootLayout(stage);
    }

    private void addListenersResize() {
        this.scene.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(this){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldSceneWidth, Number newSceneWidth) {
                System.out.println("Width: " + String.valueOf(newSceneWidth));
            }
        });
        this.scene.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(this){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldSceneHeight, Number newSceneHeight) {
                System.out.println("Height: " + String.valueOf(newSceneHeight));
            }
        });
    }

    private void setOnCloseQuestion() {
        this.primaryStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                if (StaticObjects.getCentralAbastecimentoController() != null) {
                    Alerts.showAlertInfo("Primeiro, feche a central de abastecimento.");
                    return;
                }
                Optional<ButtonType> res = Alerts.showQuestion("Deseja realmente sair?");
                if (res.get().equals(ButtonType.YES) || res.get().equals(ButtonType.OK)) {
                    Main.this.sincronizaEnvioAndExit();
                } else {
                    event.consume();
                }
            }
        });
    }

    private void baixarCertificados() {
        File file = new File("touch_comp.jks");
        try {
            if (!file.exists()) {
                FileUtils.writeByteArrayToFile((File)file, (byte[])DFCadeiaCertificados.geraCadeiaCertificados((DFAmbiente)DFAmbiente.PRODUCAO, (String)"touchcomp"));
                FileUtils.writeByteArrayToFile((File)new File("touch_comp.jks"), (byte[])DFCadeiaCertificados.geraCadeiaCertificados((DFAmbiente)DFAmbiente.HOMOLOGACAO, (String)"touchcomp"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setSize(int width, int height) {
        this.rootLayout.setPrefHeight((double)height);
        this.rootLayout.setPrefWidth((double)width);
    }

    public void stop() throws Exception {
        super.stop();
        if (context instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.getContext()).stop();
        }
    }

    public static void main(String[] args) {
        try {
            if (BlockMoreInstanceApp.getInstance().checkForBlocks()) {
                DialogsHelperShowInfoFrame.show("TouchComp NFCe j\u00e1 est\u00e1 aberto.");
                System.exit(0);
            }
            Main.checkConfigBdAndAdjust();
            BlockMoreInstanceApp.getInstance().setNewBlock();
            Main.initIcon();
            LauncherImpl.launchApplication(Main.class, SplashIniciaSistema.class, (String[])args);
        }
        catch (Exception t) {
            t.printStackTrace();
            if (ToolException.findException((Throwable)t, (String)"Unable to complete").booleanValue()) {
                DialogsHelperShowInfoFrame.show("Ocorreu uma falha ao conectar ao banco de dados local. Verifique se o Firebird est\u00e1 sendo executado. Tente reiniciar a m\u00e1quina ou reinstalar o Firebird.\n\n\n" + ToolException.getFullPrintStrack((Throwable)t));
            } else {
                DialogsHelperShowInfoFrame.show("Ocorreu uma falha ao entrar na aplica\u00e7\u00e3o. Verifique o Log e consulte auxilio t\u00e9cnico.\n" + ToolException.getFullPrintStrack((Throwable)t));
            }
            System.exit(0);
        }
    }

    private static void initTrayIcon() {
        Toolkit.getDefaultToolkit();
        if (SystemTray.isSupported()) {
            try {
                SystemTray tray = SystemTray.getSystemTray();
                Image image = Toolkit.getDefaultToolkit().getImage(Main.class.getResource("/images/icone.png"));
                trayIcon = new TrayIcon(image, "Touch Comp PDV");
                trayIcon.setImage(image);
                trayIcon.setImageAutoSize(true);
                trayIcon.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println("In here");
                    }
                });
                tray.add(trayIcon);
            }
            catch (AWTException e) {
                System.err.println("TrayIcon could not be added.");
            }
        }
    }

    public void showMessage(String title, String message) {
        this.showMessage(title, message, TrayIcon.MessageType.INFO);
    }

    public void showMessage(String title, String message, TrayIcon.MessageType type) {
        trayIcon.displayMessage(title, message, type);
    }

    public Stage getPrimaryStage() {
        return this.primaryStage;
    }

    public void setPrimaryStage(Stage stage) {
        this.primaryStage = stage;
    }

    public Scene getScene() {
        return this.scene;
    }

    public FXMLLoader getFxmlLoader() {
        return this.screenLoader;
    }

    public ApplicationContext getContext() {
        return context;
    }

    public static <T> T getBean(Class<T> beanClass) {
        return (T)context.getBean(beanClass);
    }

    public BorderPane getRootLayout() {
        return this.rootLayout;
    }

    private void initRootLayout(Stage stage) {
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(Main.class.getResource("/view/RootLayout.fxml"));
            this.rootLayout = (BorderPane)loader.load();
            this.scene = new Scene((Parent)this.rootLayout);
            this.screenLoader = loader;
            stage.setScene(this.scene);
            stage.getIcons().add((Object)new javafx.scene.image.Image(Main.class.getResource("/images/icone.png").toString()));
            stage.setUserData((Object)this.screenLoader);
            this.setOnCloseQuestion();
        }
        catch (IOException ex) {
            Alerts.showAlertError("Erro", "Ocorreu um erro ao abrir a pr\u00f3xima tela do sistema" + ex.getMessage());
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void initIcon() {
        try {
            UtilImageSvg.generateImageFromSvg("icone");
            Main.initTrayIcon();
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
        catch (IOException | TranscoderException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
    }

    public void showFooterLayout() {
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(Main.class.getResource("/view/status/StatusConexaoLayout.fxml"));
            AnchorPane footerLayout = (AnchorPane)loader.load();
            this.footerController = (StatusConexaoController)loader.getController();
            PropertiesLoader props = PropertiesLoader.get();
            Style style = new Style();
            footerLayout.setStyle(style.getStyleHeader(props.getCorBackground_5()));
            new Thread(this.footerController).start();
            this.rootLayout.setBottom((Node)footerLayout);
        }
        catch (IOException e) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void showHeaderLayout() {
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(Main.class.getResource("/view/header/HeaderLayout.fxml"));
            AnchorPane headerLayout = (AnchorPane)loader.load();
            this.headerController = (HeaderController)loader.getController();
            PropertiesLoader props = PropertiesLoader.get();
            Style style = new Style();
            headerLayout.setStyle(style.getStyleHeader(props.getCorBackground_1()));
            this.rootLayout.setTop((Node)headerLayout);
        }
        catch (IOException e) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void mudaTelaUndecorated(ControllerPath path) {
        if (this.primaryStage.getStyle().equals((Object)StageStyle.UNDECORATED)) {
            this.primaryStage.close();
            Stage newStage = new Stage();
            newStage.getIcons().add((Object)new javafx.scene.image.Image(Main.class.getResource("/images/icone.png").toString()));
            newStage.initStyle(StageStyle.DECORATED);
            this.initStage(newStage);
            this.primaryStage = newStage;
            this.primaryStage.setOnCloseRequest(evt -> {
                Optional<ButtonType> res = Alerts.showQuestion("Deseja realmente sair?");
                if (res.get().equals(ButtonType.YES) || res.get().equals(ButtonType.OK)) {
                    this.sincronizaEnvioAndExit();
                } else {
                    evt.consume();
                }
            });
            this.primaryStage.setFullScreenExitKeyCombination(KeyCombination.NO_MATCH);
            this.primaryStage.show();
        }
        this.mudaTela(path);
    }

    public void maximized() {
        Screen screen = Screen.getPrimary();
        Rectangle2D bounds = screen.getVisualBounds();
        this.primaryStage.setX(bounds.getMinX());
        this.primaryStage.setY(bounds.getMinY());
        this.primaryStage.setWidth(bounds.getWidth());
        this.primaryStage.setHeight(bounds.getHeight());
    }

    public void mudaTela(ControllerPath path, Map data) {
        try {
            if (path == null) {
                path = Controllers.MENU_PRINCIPAL;
            }
            this.lastControllerPath = this.atualControllerPath;
            this.atualControllerPath = path;
            StaticObjects.setUltimaPagina(path);
            this.screenLoader = new FXMLLoader();
            this.screenLoader.setLocation(Main.class.getResource(path.getViewPath()));
            AnchorPane footerLayout = (AnchorPane)this.screenLoader.load();
            this.primaryStage.setUserData((Object)this.screenLoader);
            footerLayout.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/styles/style.css").toExternalForm());
            this.rootLayout.setCenter((Node)footerLayout);
            if (this.rootLayout.getBottom() == null) {
                this.showFooterLayout();
            }
            if (this.rootLayout.getTop() == null) {
                this.showHeaderLayout();
            }
            Main.get().getPrimaryStage().requestFocus();
            this.setController(data);
        }
        catch (IOException ex) {
            Alerts.showAlertError("Erro", "Ocorreu um erro ao abrir a pr\u00f3xima tela do sistema" + ex.getMessage());
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setController(Map data) {
        if (this.screenLoader != null && this.screenLoader.getController() instanceof BaseController) {
            this.atualController = (BaseController)this.screenLoader.getController();
            Platform.runLater(() -> MainEvents.getInstance().setListener((ShortcutListener)this.screenLoader.getController(), this.primaryStage));
            if (this.atualController != null && this.lastController != null) {
                this.atualController.paramsData(this.lastController.getClass(), data);
            }
            this.lastController = this.atualController;
        }
    }

    public void mudaTela(ControllerPath path) {
        this.mudaTela(path, new HashMap());
    }

    public void mudaTela(ControllerPath path, ControllerPath lastPath) {
        StaticObjects.setUltimaPagina(lastPath);
        this.mudaTela(path, new HashMap());
    }

    public void goBack() {
        this.mudaTela(this.lastControllerPath, new HashMap());
    }

    public ControllerPath getLastControllerPath() {
        return this.lastControllerPath;
    }

    public void goBack(Map data) {
        this.mudaTela(this.lastControllerPath, data);
    }

    public Object showDialog(ControllerPath controllerPath) {
        return this.showDialog(controllerPath, new HashMap());
    }

    public Object showDialog(ControllerPath controllerPath, Map data) {
        return this.showDialog(controllerPath, data, null);
    }

    public Object showDialog(ControllerPath controllerPath, Map data, Stage owner) {
        ShortcutListener temp = MainEvents.getInstance().getListener();
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(Main.class.getResource(controllerPath.getViewPath()));
        Scene scene = null;
        try {
            scene = new Scene((Parent)((AnchorPane)loader.load()));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        Stage stage = new Stage();
        stage.getIcons().add((Object)new javafx.scene.image.Image(Main.class.getResource("/images/icone.png").toString()));
        stage.setUserData((Object)loader);
        scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/styles/style.css").toExternalForm());
        Object controller = loader.getController();
        if (controller instanceof ShortcutListener) {
            MainEvents.getInstance().setListener((ShortcutListener)controller, stage);
        }
        if (controller instanceof BaseDialog) {
            ((BaseDialog)controller).eventKey(null);
            ((BaseDialog)controller).setStage(stage);
            ((BaseDialog)controller).setParams(data);
            ((BaseDialog)controller).posInitialize();
        }
        stage.setTitle(controllerPath.getDescricao());
        stage.setScene(scene);
        if (owner != null) {
            stage.initOwner((Window)owner);
        } else if (this.openedDialogs.isEmpty()) {
            stage.initOwner((Window)this.primaryStage);
        } else {
            stage.initOwner((Window)this.openedDialogs.get(this.openedDialogs.size() - 1));
        }
        stage.initModality(Modality.APPLICATION_MODAL);
        Dimension d = this.getBestSizeDialog();
        if (controllerPath.getHeight() != 0) {
            stage.setHeight((double)controllerPath.getHeight());
        } else {
            stage.setHeight(d.getHeight());
            stage.setY(this.primaryStage.getY());
        }
        if (controllerPath.getWidth() != 0) {
            stage.setWidth((double)controllerPath.getWidth());
        } else {
            stage.setWidth(d.getWidth());
            stage.setX(this.primaryStage.getX());
        }
        stage.getScene().getWindow().addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, evt -> this.openedDialogs.remove(stage));
        this.openedDialogs.add(0, stage);
        stage.showAndWait();
        Object cont = loader.getController();
        MainEvents.getInstance().setListener(temp);
        Main.get().getPrimaryStage().requestFocus();
        return cont;
    }

    public void closeDialog(Stage stage) {
        if (!this.openedDialogs.isEmpty() && this.openedDialogs.contains(stage)) {
            this.openedDialogs.remove(stage);
        }
    }

    Dimension getBestSizeDialog() {
        double allWidth = this.primaryStage.getWidth();
        double allHeight = this.primaryStage.getHeight();
        Dimension d = new Dimension((int)allWidth, (int)(allHeight * 90.0 / 100.0));
        return d;
    }

    public StatusConexaoController getFooterController() {
        return this.footerController;
    }

    public HeaderController getHeaderController() {
        return this.headerController;
    }

    private void finalizarComandosEncerramentoSistema() {
        Main.getBean(ServiceMsgComandosNFCe.class).encerrarComandosPendentes();
    }

    private void sincronizaEnvioAndExit() {
        try {
            Stage stage = new Stage();
            stage.setAlwaysOnTop(false);
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(((Object)((Object)this)).getClass().getResource(Controllers.SPLASH_SINC_ENV.getViewPath()));
            Scene scene = new Scene((Parent)((AnchorPane)loader.load()));
            stage.setUserData((Object)loader);
            stage.setScene(scene);
            stage.setHeight((double)Controllers.SPLASH_SINC_ENV.getHeight());
            stage.setWidth((double)Controllers.SPLASH_SINC_ENV.getWidth());
            stage.setTitle("Sincronizando Touch Comp PDV");
            stage.showAndWait();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static void checkConfigBdAndAdjust() {
        String port = PropertiesBD.get().getPort();
        String host = PropertiesBD.get().getHost();
        String user = PropertiesBD.get().getUser();
        String pass = PropertiesBD.get().getPass();
        String url = PropertiesBD.get().getURLDatabase();
        try {
            Class.forName("org.firebirdsql.jdbc.FBDriver");
            Connection connection = DriverManager.getConnection(url, user, pass);
            connection.close();
            return;
        }
        catch (ClassNotFoundException ex) {
            TLogger.get(Main.class).error((Throwable)ex);
            return;
        }
        catch (SQLException ex) {
            TLogger.get(Main.class).error((Throwable)ex);
            if (port.equals("3051")) {
                port = "3052";
            } else if (port.equals("3052")) {
                port = "3051";
            } else {
                return;
            }
            PropertiesBD.get().setPort(port);
            return;
        }
    }

    private void iniciarTerminalConsultaPrecos() {
        try {
            InterfaceConsultaDadosProduto service = Main.getBean(HelperPrecosTerminalConsulta.class);
            new ComunicadorConsultaPrecoTCPSocket(Integer.parseInt(ConfPropertiesLoader.get().getPortaConsultaPreco()), ConfPropertiesLoader.get().getTempoDuracaoConsultaPreco(), ConfPropertiesLoader.get().getTamanhoCaracterMsgLinhaConsultaPreco(), service).start();
        }
        catch (IOException ex) {
            TLogger.get(((Object)((Object)this)).getClass()).error((Throwable)ex);
            Platform.runLater(() -> Alerts.showAlertError("Erro ao iniciar terminal de consulta."));
        }
    }
}

