/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.components;

import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.components.TouchTextField;
import java.util.Collection;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.PopupControl;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.stage.PopupWindow;
import javafx.util.Callback;
import org.apache.commons.lang3.StringUtils;

public class AutoCompleteTextField<T>
extends TouchTextField {
    private final SortedSet<T> entries = new TreeSet<T>();
    private PopupControl entriesPopup = new PopupControl();
    private String currentTextValue;
    private ObjectProperty<T> selectedItemProperty;
    private ObservableList<T> listViewItems;
    private ListView<T> listView;
    private T selectedValue;
    private ItemSelListener itemSelListener;
    private ItemSourceFilter itemSourceFilter;

    public ObjectProperty<T> selectedItemProperty() {
        return this.selectedItemProperty;
    }

    public AutoCompleteTextField(int width) {
        this(new TreeSet(), width);
    }

    public AutoCompleteTextField() {
        this(new TreeSet(), 500.0);
    }

    public AutoCompleteTextField(SortedSet items, double prefWidth) {
        this.entriesPopup.setPrefWidth(Double.NEGATIVE_INFINITY);
        this.entriesPopup.setAutoFix(true);
        this.entriesPopup.setAutoHide(true);
        this.setupListView(prefWidth);
        ((Pane)this.entriesPopup.getScene().getRoot()).getChildren().setAll((Object[])new Node[]{this.listView});
        this.entriesPopup.setAnchorLocation(PopupWindow.AnchorLocation.WINDOW_TOP_LEFT);
        this.setItems(items);
        this.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String oldVal, String newVal) {
                AutoCompleteTextField.this.updatePopup();
            }
        });
        this.setOnMouseClicked(e -> this.showPopupAllItems());
        this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean oldValue, Boolean newValue) {
                if (oldValue.booleanValue()) {
                    AutoCompleteTextField.this.entriesPopup.hide();
                    AutoCompleteTextField.this.currentTextValue = null;
                }
            }
        });
    }

    public void setWidthListView(double width) {
        this.setupListView(width);
    }

    private void setupListView(double prefWidth) {
        this.listView = new ListView();
        if (prefWidth > 0.0) {
            this.listView.setMinWidth(prefWidth);
        }
        this.listView.setPrefHeight(230.0);
        this.listView.setStyle("-fx-background-color: white; -fx-background-insets: 0, 1, 2; -fx-background-radius: 5, 4, 3;");
        this.setupListViewCellFactory();
        this.listView.getSelectionModel().selectedItemProperty().addListener((observe, oldVal, newVal) -> {
            Object selectedItem = this.listView.getSelectionModel().getSelectedItem();
            if (selectedItem != null) {
                this.selectedItemProperty().setValue(selectedItem);
            }
        });
    }

    private void setupListViewCellFactory() {
        this.listView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                AutoCompleteTextField.this.selectItem();
            }
        });
        this.listView.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ENTER) {
                    AutoCompleteTextField.this.selectItem();
                }
            }
        });
        this.listView.setCellFactory(new Callback<ListView<T>, ListCell<T>>(this){

            public ListCell<T> call(ListView<T> p) {
                return new ListCell<T>(this){

                    protected void updateItem(T t, boolean empty) {
                        super.updateItem(t, empty);
                        if (!empty) {
                            Label lbl = new Label();
                            lbl.setText(t.toString());
                            lbl.setStyle("-fx-font-size: 200.0%");
                            lbl.setMaxWidth(Double.MAX_VALUE);
                            this.setGraphic((Node)lbl);
                        } else {
                            this.setGraphic(null);
                        }
                    }

                    public void startEdit() {
                        super.startEdit();
                    }
                };
            }
        });
    }

    private void selectItem() {
        if (this.itemSelListener != null) {
            this.entriesPopup.hide();
            if (this.selectedItemProperty.get() != null) {
                this.setText(this.selectedItemProperty.get().toString());
            }
            this.selectedValue = this.selectedItemProperty.get();
            this.itemSelListener.onItemListener(this.selectedItemProperty.get());
        }
    }

    public T getSelectedValue() {
        return this.selectedValue;
    }

    public void selectValue(T data) {
        this.selectedValue = data;
        if (data != null) {
            this.setText(data.toString());
        } else {
            this.clear();
        }
    }

    public void setItems(SortedSet<T> items) {
        if (items.size() > 0) {
            this.initializeSelectedItemProperty(items.first());
        } else {
            this.initializeSelectedItemProperty(null);
        }
        this.initializeListViewItems(items);
        this.entries.clear();
        this.entries.addAll(items);
        this.entriesPopup.hide();
    }

    private void initializeListViewItems(Collection<T> items) {
        if (this.listViewItems == null) {
            this.listViewItems = FXCollections.observableArrayList(items);
        }
        this.listView.setItems(this.listViewItems);
    }

    private void initializeSelectedItemProperty(T t) {
        if (this.selectedItemProperty == null) {
            this.selectedItemProperty = new SimpleObjectProperty();
        }
        this.selectedItemProperty.set(t);
    }

    private void updatePopup() {
        Object selectedItem = this.listView.getSelectionModel().getSelectedItem();
        if (selectedItem != null && this.getText().equals(selectedItem.toString())) {
            return;
        }
        if (StringUtils.equals((CharSequence)this.currentTextValue, (CharSequence)this.getText())) {
            return;
        }
        this.currentTextValue = this.getText();
        if (!ToolMethods.isStrWithData((String)this.currentTextValue)) {
            this.selectedValue = null;
        }
        LinkedList searchResult = new LinkedList();
        if (this.itemSourceFilter != null) {
            SortedSet sort = this.itemSourceFilter.onTextChange(this.currentTextValue);
            if (sort != null) {
                searchResult.addAll(sort);
                this.entries.addAll(sort);
            }
        } else {
            searchResult.addAll(this.entries.stream().filter(x -> StringUtils.containsIgnoreCase((CharSequence)x.toString(), (CharSequence)this.getText())).collect(Collectors.toList()));
        }
        if (!searchResult.isEmpty() && !this.entries.isEmpty()) {
            this.listViewItems.setAll(searchResult);
            this.listView.getSelectionModel().selectFirst();
            if (!this.entriesPopup.isShowing()) {
                Point2D p = this.localToScene(0.0, 0.0);
                if (this.getScene() != null && this.getScene().getWindow() != null) {
                    double x2 = p.getX() + this.getScene().getX() + this.getScene().getWindow().getX();
                    double y = p.getY() + this.getScene().getY() + this.getScene().getWindow().getY() + this.getHeight();
                    this.listView.setPrefWidth(this.getWidth());
                    this.entriesPopup.show((Node)this, x2, y);
                }
            }
        } else {
            this.entriesPopup.hide();
            this.currentTextValue = null;
        }
    }

    public void showPopupAllItems() {
        if (!this.entriesPopup.isShowing() && !this.entries.isEmpty()) {
            this.listViewItems.setAll(this.entries);
            Point2D p = this.localToScene(0.0, 0.0);
            if (this.getScene() != null) {
                double x = p.getX() + this.getScene().getX() + this.getScene().getWindow().getX();
                double y = p.getY() + this.getScene().getY() + this.getScene().getWindow().getY() + this.getHeight();
                this.listView.setPrefWidth(this.getWidth());
                this.entriesPopup.show((Node)this, x, y);
            }
            System.out.println("Showing popup");
        } else {
            this.entriesPopup.hide();
        }
    }

    public SortedSet<T> getEntries() {
        return this.entries;
    }

    public ListView getListView() {
        return this.listView;
    }

    public PopupControl getPopup() {
        return this.entriesPopup;
    }

    public ItemSelListener getItemSelListener() {
        return this.itemSelListener;
    }

    public void setItemSelListener(ItemSelListener itemSelListener) {
        this.itemSelListener = itemSelListener;
    }

    public boolean popupIsShowing() {
        return this.entriesPopup.isShowing();
    }

    public void hidePopup() {
        if (this.entriesPopup == null) {
            return;
        }
        if (!this.entriesPopup.isShowing()) {
            return;
        }
        this.entriesPopup.hide();
    }

    public void clear() {
        this.selectedValue = null;
        this.entries.clear();
        this.listView.refresh();
        this.setText("");
    }

    public void requestFocus() {
        super.requestFocus();
        this.showPopupAllItems();
    }

    public ItemSourceFilter getItemSourceFilter() {
        return this.itemSourceFilter;
    }

    public void setItemSourceFilter(ItemSourceFilter itemSourceFilter) {
        this.itemSourceFilter = itemSourceFilter;
    }

    public static interface ItemSelListener<T> {
        public void onItemListener(T var1);
    }

    public static interface ItemSourceFilter<T> {
        public SortedSet onTextChange(String var1);
    }
}

