/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.components;

import com.touchcomp.touchnfce.components.TouchTextField;
import java.text.NumberFormat;
import java.util.Locale;
import javafx.application.Platform;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.NodeOrientation;

public class TouchMonetaryField
extends TouchTextField {
    private NumberFormat format;
    private SimpleDoubleProperty amount;

    public TouchMonetaryField(Locale locale) {
        this(locale, 0.0);
    }

    public TouchMonetaryField() {
        this(new Locale("pt", "BR"), 0.0);
    }

    public TouchMonetaryField(Locale locale, Double initialAmount) {
        this.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
        this.amount = new SimpleDoubleProperty((Object)this, "amount", initialAmount.doubleValue());
        this.format = NumberFormat.getCurrencyInstance(locale);
        this.formatText(this.format.format(initialAmount));
        this.focusedProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(() -> {
            int lenght = this.getText().length();
            this.selectRange(lenght, lenght);
            this.positionCaret(lenght);
        }));
        this.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                TouchMonetaryField.this.formatText(newValue);
            }
        });
    }

    public Double getAmount() {
        return this.amount.get();
    }

    public SimpleDoubleProperty amountProperty() {
        return this.amount;
    }

    public void setAmount(Double newAmount) {
        if (newAmount >= 0.0) {
            this.amount.set(newAmount.doubleValue());
            this.formatText(this.format.format(newAmount));
        }
    }

    public void setCurrencyFormat(Locale locale) {
        this.format = NumberFormat.getCurrencyInstance(locale);
        this.formatText(this.format.format(this.getAmount()));
    }

    private void formatText(String text) {
        if (text != null && !text.isEmpty()) {
            Object plainText = text.replaceAll("[^0-9]", "");
            while (((String)plainText).length() < 3) {
                plainText = "0" + (String)plainText;
            }
            StringBuilder builder = new StringBuilder((String)plainText);
            builder.insert(((String)plainText).length() - 2, ".");
            Double newValue = Double.parseDouble(builder.toString());
            this.amount.set(newValue.doubleValue());
            this.setText(this.format.format(newValue));
            Platform.runLater(() -> {
                int lenght = this.getText().length();
                this.selectRange(lenght, lenght);
                this.positionCaret(lenght);
            });
        }
    }

    public void deleteText(int start, int end) {
        StringBuilder builder = new StringBuilder(this.getText());
        builder.delete(start, end);
        this.formatText(builder.toString());
        this.selectRange(start, start);
    }
}

