/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.consultaPreco;

import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.protocol.sc504.commands.IDContinue;
import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.protocol.sc504.commands.IDvDispClear;
import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.protocol.sc504.commands.IDvLive;
import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.protocol.sc504.commands.IDvShowText;
import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.protocol.sc504.commands.IDwGetIdentify;
import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.NamedColor;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.ConnectionChannel;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.socket.SocketChannel;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.constants.EnumTipoPesqProduto;
import com.touchcomp.touchnfce.exceptions.ExceptionTabelaPrecosDinamica;
import com.touchcomp.touchnfce.helpers.preco.HelperPrecos;
import com.touchcomp.touchnfce.modeltemp.TempPesquisaProduto;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.List;

public class ConsultaPrecoTerminal
extends Thread {
    private final Socket sock;
    private final ConnectionChannel channel;

    public ConsultaPrecoTerminal(Socket sockCliente) throws Exception {
        this.sock = sockCliente;
        this.channel = new SocketChannel(this.sock);
    }

    private DataInputStream getInputStream() throws IOException {
        return new DataInputStream(this.sock.getInputStream());
    }

    private String lerSocket(String prefix) throws Exception {
        int qtdLida = this.getInputStream().available();
        byte[] vetor = new byte[qtdLida];
        this.getInputStream().read(vetor);
        String hex = ToolHexString.encodeToHex((byte[])vetor);
        System.out.println(prefix + " hex: " + hex);
        System.out.println("original dat: " + new String(vetor));
        String comando = new String(vetor);
        return comando.substring(0, qtdLida);
    }

    @Override
    public void run() {
        try {
            this.iniciarConfirmacaoConexao();
            this.aguardaEnviaComandos();
            this.startThreadAlwaysLive();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private void startThreadAlwaysLive() {
        Runnable run = () -> {
            while (true) {
                try {
                    while (true) {
                        ConsultaPrecoTerminal.sleep(30000L);
                        IDvLive cmd = new IDvLive();
                        cmd.write(this.channel);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        };
        new Thread(run).start();
    }

    private void aguardaEnviaComandos() {
        Runnable run = () -> {
            while (true) {
                try {
                    while (true) {
                        String comandoRecebido;
                        DataInputStream in = this.getInputStream();
                        System.out.println("Available: " + in.available());
                        if (in.available() > 0 && (comandoRecebido = this.lerSocket("leitura_socket")).length() > 22) {
                            String data = comandoRecebido.substring(6, 22);
                            this.lerProduto(data);
                        }
                        ConsultaPrecoTerminal.sleep(1000L);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        };
        new Thread(run).start();
    }

    private void iniciarConfirmacaoConexao() throws IOException, Exception {
        System.out.println("Gravando comando de solicitar identidade");
        new IDwGetIdentify().write(this.channel);
        Thread.sleep(1000L);
        System.out.println("Lendo Resposta: solicitar identidade");
        this.lerSocket("solicitar_identidade");
        System.out.println("Gravando comando de confirmar identidade");
        new IDContinue(true).write(this.channel);
        Thread.sleep(1000L);
        System.out.println("Lendo Resposta: confirmar identidade");
        this.lerSocket("confirmar_identidade");
    }

    private void enviaComandoProduto(String nomeProduto, Double valorUnitario) throws Exception {
        new IDvDispClear(NamedColor.WHITE.getId().shortValue()).write(this.channel);
        String comandoRecebido = this.lerSocket("gravar_produto");
        System.out.println(comandoRecebido);
        System.out.println(nomeProduto);
        new IDvShowText(10, 10, this.tratarNomeProduto(nomeProduto), "DejaVuSans-Bold.ttf", 30, NamedColor.BLACK.getId().shortValue(), -1).write(this.channel);
        System.out.println(valorUnitario);
        new IDvShowText(50, 190, "R$ " + ToolFormatter.formataNumero((Number)valorUnitario, (int)2), "DejaVuSans-Bold.ttf", 50, NamedColor.BLACK.getId().shortValue(), -1).write(this.channel);
    }

    private void enviaComandoProdutoNaoEncontrado() throws Exception {
        new IDvDispClear(NamedColor.WHITE.getId().shortValue()).write(this.channel);
        String comandoRecebido = this.lerSocket("gravar_produto");
        System.out.println(comandoRecebido);
        new IDvShowText(30, 40, "PRODUTO\nN\u00c3O\nENCONTRADO", "DejaVuSans-Bold.ttf", 50, NamedColor.BLACK.getId().shortValue(), -1).write(this.channel);
    }

    private void lerProduto(String data) throws Exception {
        if ((data = TString.onlyNumbers((String)data)).isEmpty()) {
            return;
        }
        TempPesquisaProduto t = this.pesquisarProdutoPreco(data);
        if (t != null) {
            this.enviaComandoProduto(t.getNomeProduto(), t.getValorUnitario());
        } else {
            this.enviaComandoProdutoNaoEncontrado();
        }
    }

    private TempPesquisaProduto pesquisarProdutoPreco(String data) throws ExceptionTabelaPrecosDinamica, ExceptionAvaliadorExpressoes {
        HelperPrecos helper = Main.getBean(HelperPrecos.class);
        List<TempPesquisaProduto> prod = helper.getProdutos(data, StaticObjects.getEmpresa(), null, StaticObjects.getOpcoes(), null, StaticObjects.getUsuario(), StaticObjects.getGrupo(), null, null, null, 1, (Integer)1, EnumTipoPesqProduto.TIPO_PESQ_COD_BARRAS);
        return prod != null && !prod.isEmpty() ? prod.get(0) : null;
    }

    private String tratarNomeProduto(String nomeProduto) {
        Object nome = "";
        int i = 0;
        Boolean b = true;
        while (b.booleanValue()) {
            if (nomeProduto.length() > 21) {
                if (((String)nome).length() > 0) {
                    nome = (String)nome + "\n";
                }
                nome = (String)nome + nomeProduto.substring(0, 21);
                nomeProduto = nomeProduto.substring(21);
            } else {
                if (((String)nome).length() > 0) {
                    nome = (String)nome + "\n";
                }
                nome = (String)nome + nomeProduto.substring(0, nomeProduto.length());
                b = false;
            }
            if (++i != 5) continue;
            b = false;
        }
        return nome;
    }
}

