/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller;

import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.MainEvents;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchButton;
import com.touchcomp.touchnfce.listeners.ShortcutListener;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.NFCeControleCaixa;
import com.touchcomp.touchnfce.model.Usuario;
import com.touchcomp.touchnfce.modeltemp.ControllerPath;
import com.touchcomp.touchnfce.properties.ConfPropertiesLoader;
import com.touchcomp.touchnfce.properties.PropertiesLoader;
import com.touchcomp.touchnfce.utils.Style;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;

public abstract class BaseController
implements Initializable,
ShortcutListener {
    private BaseController lastController;

    public void initialize(URL url, ResourceBundle rb) {
        this.initializeController(rb);
        this.beforeShow();
        this.initEvents();
        this.requestFocusOnOpenInternal();
        MainEvents.getInstance().setListener(this);
        this.setStyle();
    }

    private void setStyle() {
        Field[] fields = this.getClass().getDeclaredFields();
        this.setStyleFields(fields);
        if (this.getClass().getSuperclass() != null) {
            Field[] fieldsSuperClass = this.getClass().getSuperclass().getDeclaredFields();
            this.setStyleFields(fieldsSuperClass);
        }
    }

    public Usuario getUsuarioLogado() {
        return StaticObjects.getUsuario();
    }

    public Empresa getEmpresaLogado() {
        return StaticObjects.getEmpresa();
    }

    public NFCeControleCaixa getControleCaixaAberto() {
        return StaticObjects.getControleCaixa();
    }

    private void setStyleFields(Field[] fields) {
        PropertiesLoader props = PropertiesLoader.get();
        Style style = new Style();
        for (Field f : fields) {
            try {
                f.setAccessible(true);
                Object it = f.get(this);
                if (it instanceof TextField) continue;
                if (it instanceof TouchButton) {
                    ((Button)it).setFocusTraversable(false);
                    TouchButton aux = (TouchButton)((Object)it);
                    if (aux.isScreenStyled()) continue;
                    aux.setStyle(style.getStyleButton(props.getCorBordaButton(), props.getCorRadiusButton1(), props.getCorRadiusButton2(), props.getCorTextoButton()));
                    continue;
                }
                if (it instanceof Button) {
                    ((Button)it).setFocusTraversable(false);
                    ((Button)it).setStyle(style.getStyleButton(props.getCorBordaButton(), props.getCorRadiusButton1(), props.getCorRadiusButton2(), props.getCorTextoButton()));
                    continue;
                }
                if (it instanceof Label) {
                    ((Label)it).setStyle(style.getCorTexto(props.getCorTexto()));
                    continue;
                }
                if (it instanceof CheckBox) {
                    ((CheckBox)it).setStyle(style.getCorTextoCheckBox(props.getCorTexto()));
                    continue;
                }
                if (it instanceof RadioButton) {
                    ((RadioButton)it).setStyle(style.getCorTextoCheckBox(props.getCorTexto()));
                    continue;
                }
                if (!(it instanceof AnchorPane)) continue;
                ((AnchorPane)it).setStyle(style.getCorBody(props.getCorBackground_1(), props.getCorBackground_2(), props.getCorBackground_3(), props.getCorBackground_4(), props.getCorBackground_5()));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void requestFocusOnOpenInternal() {
        Platform.runLater(this::requestFocusOnOpen);
    }

    protected abstract void initializeController(ResourceBundle var1);

    public void beforeShow() {
    }

    public void initEvents() {
    }

    protected abstract void requestFocusOnOpen();

    public abstract void eventKey(KeyEvent var1);

    public abstract void eventAltControl(KeyEvent var1);

    @Override
    public void evtKey(KeyEvent evt) {
        this.eventKey(evt);
    }

    @Override
    public void firstEscapeKey(KeyEvent evt) {
    }

    public void mudaTela(ControllerPath path) {
        Main.get().mudaTela(path);
    }

    @Override
    public void evtAltControl(KeyEvent event) {
        switch (event.getCode()) {
            case F: {
                this.checkFullScreen();
            }
        }
        this.eventAltControl(event);
    }

    public void setLastController(BaseController lastController, ControllerPath lastControllerPath) {
        this.lastController = lastController;
    }

    public void goBack() {
        Main.get().goBack();
    }

    public void goBack(Map data) {
        Main.get().goBack(data);
    }

    public void paramsData(Class<? extends BaseController> aClass, Map data) {
    }

    protected boolean validate(List data) {
        return data != null && data.size() > 0;
    }

    protected boolean validate(String data) {
        return data != null && data.trim().length() > 0;
    }

    protected boolean validate(Number data) {
        return data != null && data.doubleValue() > 0.0;
    }

    protected boolean validate(Object data) {
        return data != null;
    }

    public <T> T getBean(Class<T> bean) {
        return Main.getBean(bean);
    }

    private void checkFullScreen() {
        boolean full = Main.get().getPrimaryStage().isFullScreen();
        Main.get().getPrimaryStage().setFullScreen(!full);
        if (!full) {
            Main.get().getPrimaryStage().setMaximized(true);
        }
        ConfPropertiesLoader.get().adicionaProperties(ConfPropertiesLoader.FULL_SCREEN, String.valueOf(full));
    }
}

