/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.abastecimento.threads;

import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.ComunicadorResposta;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.model.LeituraAbastecimento;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.abastecimento.auxiliar.HelperFuncoesMaster;
import com.touchcomp.touchnfce.exceptions.ExceptionTabelaPrecosDinamica;
import com.touchcomp.touchnfce.helpers.preco.HelperPrecos;
import com.touchcomp.touchnfce.model.BicoBombaCombustivel;
import com.touchcomp.touchnfce.model.NFCePreAbastecimento;
import com.touchcomp.touchnfce.modeltemp.DeParaBicoBomba;
import com.touchcomp.touchnfce.modeltemp.TempPesquisaProduto;
import com.touchcomp.touchnfce.service.impl.ServiceNFCePreAbastecimento;
import com.touchcomp.touchnfce.utils.UtilAbastecimento;
import com.touchcomp.touchnfce.utils.UtilNFCeSerial;
import com.touchcomp.touchnfce.utils.abastecimentocompanytec.UtilCentralAbastecimento;
import java.util.List;
import javafx.application.Platform;

public class ThreadSincronizacaoAutomacao
extends Thread {
    private Boolean breakThreadSincAutomacao = false;
    private Boolean continueThread = true;
    private Boolean dead;
    private final HelperFuncoesMaster helperFuncosMaster = new HelperFuncoesMaster();
    private final ServiceNFCePreAbastecimento serviceNFCePreAbastecimento = Main.getBean(ServiceNFCePreAbastecimento.class);
    private final List<DeParaBicoBomba> listDeParaBicos;
    private int count;
    private int countErrors;

    public ThreadSincronizacaoAutomacao(List<DeParaBicoBomba> listDeParaBicos) {
        this.listDeParaBicos = listDeParaBicos;
    }

    @Override
    public void run() {
        this.dead = false;
        try {
            while (this.getContinueThread().booleanValue()) {
                block14: {
                    try {
                        if (this.getBreakThreadSincAutomacao().booleanValue()) break block14;
                        this.sincronizaAutomacao();
                        this.countErrors = 0;
                    }
                    catch (Exception ex) {
                        Alerts.showAlertErrorRunLater("Erro ao enviar comandos para automacao: " + ex.getMessage());
                        TLogger.get(this.getClass()).error((Throwable)ex);
                        ++this.countErrors;
                        if (this.countErrors <= 3) break block14;
                        Alerts.showAlertErrorRunLater("Apos falhas sucessivas, a sincronizacao com automacao sera interrompida. Reconecte na automa\u00e7\u00e3o quando os problemas forem resolvidos");
                        this.setContinueThread(false);
                        break;
                    }
                }
                ThreadSincronizacaoAutomacao.sleep(StaticObjects.getOpcoes().getTempoSincronizacaoBomba());
            }
        }
        catch (InterruptedException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
        }
        finally {
            try {
                UtilCentralAbastecimento.get().disconnectSocketAutomacao();
            }
            catch (Exception ex) {
                TLogger.get(this.getClass()).error((Throwable)ex);
            }
        }
        this.dead = true;
    }

    @Override
    public void interrupt() {
        this.setContinueThread(false);
        super.interrupt();
    }

    private void sincronizaAutomacao() throws Exception {
        if (UtilCentralAbastecimento.get().isControlMaster()) {
            this.findAbastecimentosPendente();
            this.helperFuncosMaster.verificaExecutaComdAutomacao();
            if (UtilCentralAbastecimento.get().isItemNTAbastCanc()) {
                UtilCentralAbastecimento.get().setItemNTAbastCanc(false);
            }
        }
    }

    private void findAbastecimentosPendente() throws Exception {
        ComunicadorResposta<LeituraAbastecimento> ret = UtilCentralAbastecimento.get().leituraAbastecimento();
        if (!this.validateAbastecimentosPendentes(ret)) {
            return;
        }
        BicoBombaCombustivel bico = UtilCentralAbastecimento.get().getBicoBomba(((LeituraAbastecimento)ret.getResultado()).getCodBico());
        NFCePreAbastecimento pr = this.createNFCePreAbastecimento(ret, bico);
        if (pr == null || pr.getIdentificador() <= 0L) {
            return;
        }
        if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getBloquearBombaAuto(), (Object)1)) {
            UtilCentralAbastecimento.get().bloqueiaBombaAbastecimento(bico);
            for (DeParaBicoBomba d : this.listDeParaBicos) {
                if (d.getBico().getAtivo() != 1 || !d.getBico().equals(bico)) continue;
                d.setPreAbastecimento(pr);
                break;
            }
        }
        this.incrementarPonteiroAbastecimento();
    }

    private boolean validateAbastecimentosPendentes(ComunicadorResposta<LeituraAbastecimento> ret) throws Exception {
        block9: {
            block8: {
                if (ret != null && ToolMethods.isEquals((Object)ret.getRetorno(), (Object)"-1")) {
                    ++this.countErrors;
                    if (this.countErrors > 5) {
                        this.setContinueThread(false);
                    }
                }
                if (ret == null || ret.getRetorno() == null || ret.getResultado() == null || ((LeituraAbastecimento)ret.getResultado()).getCodBico() == null) break block8;
                String string = ret.getRetorno();
                UtilCentralAbastecimento.get();
                if (!string.equals("0")) break block9;
            }
            return false;
        }
        if (((LeituraAbastecimento)ret.getResultado()).getTotalAPagar() <= 0.0) {
            this.incrementarPonteiroAbastecimento();
            return false;
        }
        if (UtilCentralAbastecimento.get().getBicoBomba(((LeituraAbastecimento)ret.getResultado()).getCodBico()) == null) {
            Platform.runLater(() -> {
                this.setContinueThread(true);
                Alerts.showAlertError("O bico de c\u00f3digo " + ((LeituraAbastecimento)ret.getResultado()).getCodBico() + " n\u00e3o esta cadastrado no sistema.\nA conex\u00e3o com a Automa\u00e7\u00e3o foi encerrada. Cadastre o mesmo para dar seguimento na leitura dos abastecimentos!");
            });
            return false;
        }
        NFCePreAbastecimento ultimoPreAbastecimento = this.serviceNFCePreAbastecimento.getUltimoAbastecimento();
        if (ultimoPreAbastecimento != null && ToolMethods.isEquals((Object)ultimoPreAbastecimento.getIndiceAbastecimento(), (Object)((LeituraAbastecimento)ret.getResultado()).getNumeroAbastecimento())) {
            Platform.runLater(() -> {
                Alerts.showAlertError("O abastecimento de indice " + ultimoPreAbastecimento.getIndiceAbastecimento() + " j\u00e1 foi lido anteriormente!");
                this.incrementarPonteiroAbastecimento();
            });
            return false;
        }
        return true;
    }

    private NFCePreAbastecimento createNFCePreAbastecimento(ComunicadorResposta<LeituraAbastecimento> ret, BicoBombaCombustivel bico) {
        NFCePreAbastecimento p = this.serviceNFCePreAbastecimento.getByEncerramenteBombaData(bico, ((LeituraAbastecimento)ret.getResultado()).getNrEncerramenteBico(), ((LeituraAbastecimento)ret.getResultado()).getDataAbastecimento());
        if (p == null) {
            p = new NFCePreAbastecimento();
        }
        p.setBico(bico);
        p.setDataAbastecimento(((LeituraAbastecimento)ret.getResultado()).getDataAbastecimento());
        p.setQuantidade(((LeituraAbastecimento)ret.getResultado()).getVolumeAbastecido());
        p.setValorUnitario(((LeituraAbastecimento)ret.getResultado()).getValorUnitario());
        p.setValorTotal(((LeituraAbastecimento)ret.getResultado()).getTotalAPagar());
        p.setIndiceAbastecimento(((LeituraAbastecimento)ret.getResultado()).getNumeroAbastecimento());
        p.setSerialForSinc(UtilNFCeSerial.getSerial(StaticObjects.getNFCeCaixa()));
        this.setQuantidade(p);
        this.setAndAjustaEncerrante(p, ret);
        try {
            this.setValorCustoEReferencia(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.serviceNFCePreAbastecimento.save(p);
    }

    private void setValorCustoEReferencia(NFCePreAbastecimento pre) throws Exception {
        List<TempPesquisaProduto> prod = this.getProdutosPrecos(pre.getBico().getGradeCor().getProdutoGrade().getProduto().getIdentificador());
        if (prod == null || prod.isEmpty()) {
            throw new Exception("Produto sem tabela de pre\u00e7o: " + String.valueOf(pre.getBico().getGradeCor().getProdutoGrade().getProduto()));
        }
        Double valorCusto = prod.get(0).getPrecoCusto();
        Double valorUnid = prod.get(0).getValorUnitario();
        pre.setValorCusto(valorCusto);
        pre.setValorUnitarioSugerido(valorUnid);
    }

    private List<TempPesquisaProduto> getProdutosPrecos(Long idProd) throws ExceptionTabelaPrecosDinamica, ExceptionAvaliadorExpressoes {
        HelperPrecos helper = Main.getBean(HelperPrecos.class);
        List<TempPesquisaProduto> prod = null;
        prod = helper.getProdutos(idProd, StaticObjects.getEmpresa(), StaticObjects.getNfceAberta().getUnidadeFatCliente(), StaticObjects.getOpcoes(), StaticObjects.getNfceAberta().getRepresentante(), StaticObjects.getUsuario(), StaticObjects.getGrupo(), StaticObjects.getNfceAberta().getDadosTransporte().getTipoFrete(), StaticObjects.getNfceAberta().getNaturezaOperacao(), StaticObjects.getNfceAberta().getCondicoesPagamento(), null, null);
        return prod;
    }

    private void setQuantidade(NFCePreAbastecimento pre) {
        if (pre.getValorTotal() > 0.0 && pre.getValorUnitario() > 0.0) {
            pre.setQuantidade(ToolFormatter.arrredondarNumero((Double)(pre.getValorTotal() / pre.getValorUnitario()), (int)3, (int)6));
        }
    }

    private void setAndAjustaEncerrante(NFCePreAbastecimento p, ComunicadorResposta<LeituraAbastecimento> ret) {
        Double valorEncerrante = ((LeituraAbastecimento)ret.getResultado()).getNrEncerramenteBico();
        Double ultEncerranete = 0.0;
        NFCePreAbastecimento ultimo = this.serviceNFCePreAbastecimento.getUltimoAbastecimento(p.getBico());
        if (ultimo != null) {
            ultEncerranete = ultimo.getValorEncerrante();
        }
        p.setValorEncerrante(UtilAbastecimento.calcAjustaEncerrante(valorEncerrante, ultEncerranete, p.getBico().getBombaCombustivel().getMedicaoInicial(), p.getBico()));
    }

    public Boolean getBreakThreadSincAutomacao() {
        return this.breakThreadSincAutomacao;
    }

    public void setBreakThreadSincAutomacao(Boolean breakThreadSincAutomacao) {
        this.breakThreadSincAutomacao = breakThreadSincAutomacao;
    }

    public Boolean getContinueThread() {
        return this.continueThread;
    }

    public void setContinueThread(Boolean continueThread) {
        this.continueThread = continueThread;
    }

    private void incrementarPonteiroAbastecimento() {
        try {
            UtilCentralAbastecimento.get().incrementarPonteiroAbastecimento();
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            Alerts.showAlertErrorRunLater("Erro ao enviar comando para automacao. Se problema persistir, verifique a conexao com automacao: " + ex.getMessage());
        }
    }

    public Boolean getDead() {
        return this.dead;
    }

    public void setDead(Boolean dead) {
        this.dead = dead;
    }
}

