/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.caixa;

import com.touchcomp.basementor.constants.enums.EnumConstAbertoFechado;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchDoubleField;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.controller.splash.impl.SplashSaveAberturaNFCeEncerranteAbastecimento;
import com.touchcomp.touchnfce.model.Representante;
import com.touchcomp.touchnfce.model.Usuario;
import com.touchcomp.touchnfce.service.impl.ServiceRepresentante;
import java.util.Date;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import org.springframework.stereotype.Controller;

@Controller
public class AberturaCaixaController
extends BaseController {
    @FXML
    private Label lblStatusCaixa;
    @FXML
    private Label lblDataHoraAbert;
    @FXML
    private Label lblUsuario;
    @FXML
    private Label lblSuprimento;
    @FXML
    private TouchTextField tfUsuario;
    @FXML
    private TouchTextField tfDataHoraAbert;
    @FXML
    private TouchDoubleField tfValorSuprimento;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnSair;
    @FXML
    private AnchorPane body;
    private Usuario u = new Usuario();
    private final Date dataAbertura = new Date();

    @Override
    protected void initializeController(ResourceBundle rb) {
        this.tfDataHoraAbert.setText(ToolDate.dateToStr((Date)this.dataAbertura, (String)"dd/MM/yyyy hh:mm:ss"));
        this.tfDataHoraAbert.setEditable(false);
        this.tfValorSuprimento.setDouble(0.0);
        this.tfUsuario.setText(this.getUsuarioLogado().getPessoa().getNome());
        this.tfUsuario.setEditable(false);
        this.lblStatusCaixa.setVisible(false);
        this.tfDataHoraAbert.setLabel(this.lblDataHoraAbert);
        this.tfUsuario.setLabel(this.lblUsuario);
        this.tfValorSuprimento.setLabel(this.lblSuprimento);
    }

    @Override
    public void initEvents() {
        this.btnConfirmar.setOnAction(event -> this.saveAbertCaixa());
        this.btnSair.setOnAction(event -> this.goBack());
    }

    @Override
    protected void requestFocusOnOpen() {
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent evt) {
        switch (evt.getCode()) {
            case F12: {
                this.saveAbertCaixa();
                break;
            }
            case ENTER: {
                this.saveAbertCaixa();
                break;
            }
            case ESCAPE: {
                this.goBack();
                break;
            }
        }
    }

    @FXML
    public void teste() {
    }

    public void saveAbertCaixa() {
        if (StaticObjects.getControleCaixa() == null || StaticObjects.getControleCaixa().getStatus() == EnumConstAbertoFechado.FECHADO.value) {
            if (this.isValidUsuarioRepresentante()) {
                SplashSaveAberturaNFCeEncerranteAbastecimento splash = new SplashSaveAberturaNFCeEncerranteAbastecimento(EnumConstAbertoFechado.ABERTO.value, this.dataAbertura, this.tfValorSuprimento.getDouble());
                splash.show();
            } else {
                Alerts.showAlertError("Erro", "O usu\u00e1rio logado n\u00e3o \u00e9 um vendedor!");
            }
        } else {
            Alerts.showAlertError("Erro", "Um usu\u00e1rio j\u00e1 est\u00e1 com este caixa aberto. Para utiliz\u00e1-lo \u00e9 preciso fech\u00e1-lo.");
        }
    }

    private boolean isValidUsuarioRepresentante() {
        ServiceRepresentante serviceRep = Main.getBean(ServiceRepresentante.class);
        Representante rep = serviceRep.getRepresentanteByPessoa(StaticObjects.getUsuario().getPessoa().getIdentificador());
        return rep != null;
    }
}

