/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.caixa;

import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchComboBox;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.model.NFCeCaixa;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeCaixa;
import java.util.List;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import org.springframework.stereotype.Controller;

@Controller
public class CaixaFiscalController
extends BaseController {
    @FXML
    private Label lblCaixa;
    @FXML
    private TouchComboBox<NFCeCaixa> cmbCaixas;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnCancelar;

    @Override
    protected void initializeController(ResourceBundle rb) {
        this.cmbCaixas.setLabel(this.lblCaixa);
    }

    @Override
    public void beforeShow() {
        List<NFCeCaixa> caixas = this.getBean(ServiceNFCeCaixa.class).getByIDEmpresa(StaticObjects.getDadosSincronizacao().getIdEmpresa());
        this.cmbCaixas.setObjects(caixas);
    }

    @Override
    public void initEvents() {
        this.btnCancelar.setOnAction(event -> this.goBack());
        this.btnConfirmar.setOnAction(event -> this.salvaCaixaFiscal());
    }

    @Override
    protected void requestFocusOnOpen() {
        this.cmbCaixas.requestFocus();
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent evt) {
        switch (evt.getCode()) {
            case F12: {
                this.salvaCaixaFiscal();
                break;
            }
            case ESCAPE: {
                this.goBack();
                break;
            }
        }
    }

    private void salvaCaixaFiscal() {
        NFCeCaixa selected = (NFCeCaixa)this.cmbCaixas.getSelectionModel().getSelectedItem();
        if (selected == null) {
            Alerts.showAlertError("Erro", "Selecione um caixa para poder continuar");
            return;
        }
        StaticObjects.setNFCeCaixa(selected);
        StaticObjects.getDadosSincronizacao().setNfCeCaixa(selected);
        StaticObjects.getDadosSincronizacao().setAppConfiguradoCaixa((short)1);
        StaticObjects.refreshDadosSincronizacao();
        if (selected.getEmpresa() == null) {
            Alerts.showAlertError("Erro", "Empresa n\u00e3o foi informada no caixa fiscal.");
            return;
        }
        if (StaticObjects.getOpcoes() == null) {
            Alerts.showAlertError("Erro", "Op\u00e7\u00f5es NFCe n\u00e3o foram definidas para esta grupoEmpresa/caixa.");
            return;
        }
        this.mudaTela(Controllers.MENU_PRINCIPAL);
    }
}

