/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.dadosveiculo;

import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.AutoCompleteTextField;
import com.touchcomp.touchnfce.components.TouchComboBox;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.model.ClienteVeiculo;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.utils.MaskField;
import com.touchcomp.touchnfce.utils.abastecimentocompanytec.UtilCentralAbastecimento;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;

public class DadosVeiculoController
extends BaseDialog {
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnCancelar;
    @FXML
    private TouchTextField tfPlaca;
    @FXML
    private TouchTextField tfNome;
    @FXML
    private TouchTextField tfKm;
    @FXML
    private AutoCompleteTextField tfCpfCnpj;
    @FXML
    private Label lblCpfCnpj;
    @FXML
    private Label lblNome;
    @FXML
    private Label lblKM;
    @FXML
    private Label lblPlaca;
    @FXML
    private Label lblVeiculos;
    @FXML
    private AnchorPane body;
    @FXML
    private TouchComboBox<ClienteVeiculo> cmbVeiculos;

    @Override
    public void initializeController(ResourceBundle rb) {
        this.btnConfirmar.setOnAction(event -> this.saveAndClose());
        this.btnCancelar.setOnAction(event -> this.getStage().close());
        this.cmbVeiculos.setOnAction(event -> {
            if (this.cmbVeiculos.getSelectionModel().getSelectedItem() != null) {
                ClienteVeiculo cv = (ClienteVeiculo)this.cmbVeiculos.getSelectionModel().getSelectedItem();
                this.tfPlaca.setText(cv.getVeiculo().getPlaca());
            }
        });
        this.lblVeiculos.setVisible(false);
        this.cmbVeiculos.setVisible(false);
        this.tfNome.setEditable(false);
        this.tfCpfCnpj.setEditable(false);
        MaskField.cpfCnpjField(this.tfCpfCnpj);
        this.showDadosCliente(this.getNFCe());
        this.showDadosConsumidor(this.getNFCe());
        this.setLabelsTextFields();
    }

    private void setLabelsTextFields() {
        this.cmbVeiculos.setLabel(this.lblVeiculos);
        this.tfNome.setFocusTraversable(false);
        this.tfCpfCnpj.setFocusTraversable(false);
        this.tfPlaca.setLabel(this.lblPlaca);
        this.tfKm.setLabel(this.lblKM);
    }

    @Override
    public void posInitialize() {
        super.posInitialize();
    }

    private void showDadosCliente(NFCe nfce) {
        if (nfce == null) {
            return;
        }
        if (nfce.getUnidadeFatCliente() != null) {
            this.tfCpfCnpj.setText(nfce.getUnidadeFatCliente().getPessoa().getComplemento().getCnpj());
            this.tfNome.setText(nfce.getUnidadeFatCliente().getPessoa().getNome());
            this.cmbVeiculos.setItems(FXCollections.observableArrayList(nfce.getUnidadeFatCliente().getCliente().getVeiculos()));
            this.lblVeiculos.setVisible(true);
            this.cmbVeiculos.setVisible(true);
        }
        this.tfPlaca.setText(nfce.getPlacaVeiculo());
        this.tfKm.setText(String.valueOf(nfce.getKm()));
    }

    @Override
    public void requestFocusOnOpen() {
        Platform.runLater(() -> this.tfCpfCnpj.requestFocus());
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt == null) {
            return;
        }
        switch (evt.getCode()) {
            case ESCAPE: {
                this.getStage().close();
                break;
            }
            case F12: {
                this.saveAndClose();
            }
        }
    }

    private NFCe getNFCe() {
        return StaticObjects.getNfceAberta();
    }

    private boolean isValidBefore() {
        if (this.tfKm.getText() == null || this.tfKm.getText().isEmpty()) {
            Alerts.showAlertError("Primeiro informe o KM!");
            return false;
        }
        try {
            Integer take = Integer.valueOf(this.tfKm.getText());
            if (take > 999999999) {
                Alerts.showAlertError("KM inv\u00e1lido! N\u00famero muito grande.");
                return false;
            }
        }
        catch (Exception ex) {
            Alerts.showAlertError("KM inv\u00e1lido! Informe apenas n\u00fameros");
            return false;
        }
        if (this.tfPlaca.getText() == null || this.tfPlaca.getText().isEmpty()) {
            Alerts.showAlertError("Primeiro informe o Veiculo ou o mesmo esta sem placa!");
            return false;
        }
        return true;
    }

    private void vinculaDadosPreAbastecimento() {
        UtilCentralAbastecimento.get().setPlacaAndKMNFCePreAbastecimento(this.getNFCe(), this.tfPlaca.getText(), this.tfKm.getText());
        StaticObjects.refreshNFCe();
    }

    private void showDadosConsumidor(NFCe nfce) {
        if (nfce == null || nfce.getNfCeConsumidor() == null) {
            return;
        }
        this.tfCpfCnpj.setText(nfce.getNfCeConsumidor().getCpfCnpj());
        this.tfNome.setText(nfce.getNfCeConsumidor().getNome());
        for (NFCeItem i : this.getNFCe().getItens()) {
            if (i.getPreAbastecimento() == null) continue;
            this.tfPlaca.setText(i.getPreAbastecimento().getPlaca());
            this.tfKm.setText(i.getPreAbastecimento().getKm());
        }
    }

    private void saveAndClose() {
        if (this.isValidBefore()) {
            this.vinculaDadosPreAbastecimento();
            this.closeDialog();
        }
    }
}

