/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.dialogs;

import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.components.TouchDoubleField;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;

public class DialogDoubleField
extends BaseDialog {
    public static final String LABEL = "label";
    public static final String VALOR = "valor";
    @FXML
    private AnchorPane body;
    @FXML
    private Label descricao;
    @FXML
    private TouchDoubleField field;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnCancelar;
    private String label;
    private Double valorInformado;

    @Override
    public void initializeController(ResourceBundle resources) {
        this.btnCancelar.setOnAction(evt -> {
            this.valorInformado = null;
            this.closeDialog();
        });
        this.btnConfirmar.setOnAction(evt -> {
            this.valorInformado = this.field.getDouble();
            this.closeDialog();
        });
        this.field.setOnKeyPressed(evt -> {
            switch (evt.getCode()) {
                case ENTER: {
                    if (this.field.getDouble() == null || !(this.field.getDouble() > 0.0)) break;
                    this.valorInformado = this.field.getDouble();
                    this.closeDialog();
                }
            }
        });
        this.field.setLabel(this.descricao);
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt != null) {
            switch (evt.getCode()) {
                case F12: {
                    this.valorInformado = this.field.getDouble();
                    this.closeDialog();
                    break;
                }
                case ESCAPE: {
                    this.valorInformado = null;
                    this.closeDialog();
                    break;
                }
                case ENTER: {
                    if (!this.btnConfirmar.isFocused()) break;
                    this.valorInformado = this.field.getDouble();
                    this.closeDialog();
                }
            }
        }
    }

    public Double getValorInformado() {
        return this.valorInformado;
    }

    @Override
    public void requestFocusOnOpen() {
        this.field.requestFocus();
    }

    @Override
    public void posInitialize() {
        this.label = (String)this.getParams().get(LABEL);
        if (this.getParams().get(VALOR) != null) {
            this.field.setDouble((Double)this.getParams().get(VALOR));
        }
        this.descricao.setText(this.label);
    }

    @Override
    public void eventAltControl(KeyEvent event) {
    }
}

