/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.endereco;

import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.others.cpfcnpj.ValidadeCPFCNPJ;
import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.AutoCompleteTextField;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.components.listener.FocusListener;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.model.Cidade;
import com.touchcomp.touchnfce.model.Endereco;
import com.touchcomp.touchnfce.model.EnderecoEntregaPedido;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeEnderecoEntrega;
import com.touchcomp.touchnfce.model.Pedido;
import com.touchcomp.touchnfce.model.UnidadeFederativa;
import com.touchcomp.touchnfce.modeltemp.TempImplLogradouro;
import com.touchcomp.touchnfce.service.impl.ServiceCidade;
import com.touchcomp.touchnfce.service.impl.ServiceUnidadeFederativa;
import com.touchcomp.touchnfce.tasks.utils.UtilPesquisaCEP;
import com.touchcomp.touchnfce.utils.MaskField;
import java.util.List;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;

public class EnderecoEntregaNFCeController
extends BaseDialog
implements AutoCompleteTextField.ItemSelListener,
AutoCompleteTextField.ItemSourceFilter {
    public static final Boolean isPedido = false;
    @FXML
    private Label lblLogradouro;
    @FXML
    private Label lblNumero;
    @FXML
    private Label lblBairro;
    @FXML
    private Label lblCidade;
    @FXML
    private Label lblReferencia;
    @FXML
    private Label lblComplemento;
    @FXML
    private Label lblObservacao;
    @FXML
    private Label lblCEP;
    @FXML
    private Label lblCpfCnpjRes;
    @FXML
    private Label lblReponsavel;
    @FXML
    private Button btnCancelar;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnExcEndNfce;
    @FXML
    private Button btnPesquisarEndCliente;
    @FXML
    private TouchTextField tfLogradouro;
    @FXML
    private TouchTextField tfNumero;
    @FXML
    private TouchTextField tfBairro;
    @FXML
    private TouchTextField tfReferencia;
    @FXML
    private TouchTextField tfComplemento;
    @FXML
    private TouchTextField tfObservacao;
    @FXML
    private TouchTextField tfCEP;
    @FXML
    private TouchTextField tfCpfCnpjRes;
    @FXML
    private TouchTextField tfResponsavel;
    @FXML
    private AutoCompleteTextField<Cidade> tfCidade;
    @FXML
    private ComboBox<UnidadeFederativa> cmbUF;
    @FXML
    private AnchorPane body;

    @Override
    public void initializeController(ResourceBundle rb) {
        this.tfNumero.textProperty().addListener((observableValue, antigo, novo) -> this.tfNumero.setText(MaskField.onlyDigitsDoubleValue(this.tfNumero)));
        this.tfCEP.textProperty().addListener((observableValue, antigo, novo) -> {
            if (this.tfCEP.getText().length() < 10) {
                this.tfCEP.setText(ToolFormatter.formatCNPJCPF((String)novo) != null ? ToolFormatter.formatCNPJCPF((String)novo) : novo);
            }
        });
        this.tfCEP.addFocusListener(new FocusListener(){

            @Override
            public void onFocusGained() {
            }

            @Override
            public void onFocusLost() {
                EnderecoEntregaNFCeController.this.findEnderecoByCEP();
            }
        });
        this.btnCancelar.setOnAction(event -> this.closeDialog());
        this.btnConfirmar.setOnAction(event -> this.informaEndereco());
        this.btnPesquisarEndCliente.setOnAction(event -> this.findEnderecoEntregaCliente());
        this.btnExcEndNfce.setOnAction(event -> this.findEnderecoEntregaCliente());
        this.iniciaCombo();
        MaskField.cpfCnpjField(this.tfCpfCnpjRes);
        this.setLabelsTextField();
        this.tfCidade.setItemSelListener(this);
        this.tfCidade.setItemSourceFilter(this);
    }

    private void setLabelsTextField() {
        this.tfBairro.setLabel(this.lblBairro);
        this.tfCEP.setLabel(this.lblCEP);
        this.tfComplemento.setLabel(this.lblComplemento);
        this.tfCpfCnpjRes.setLabel(this.lblCpfCnpjRes);
        this.tfLogradouro.setLabel(this.lblLogradouro);
        this.tfNumero.setLabel(this.lblNumero);
        this.tfObservacao.setLabel(this.lblObservacao);
        this.tfReferencia.setLabel(this.lblReferencia);
        this.tfResponsavel.setLabel(this.lblReponsavel);
        this.tfCidade.setLabel(this.lblCidade);
        this.btnCancelar.setFocusTraversable(false);
        this.btnConfirmar.setFocusTraversable(false);
        this.btnExcEndNfce.setFocusTraversable(false);
        this.btnPesquisarEndCliente.setFocusTraversable(false);
    }

    @Override
    public void requestFocusOnOpen() {
        this.tfCEP.requestFocus();
    }

    private void limpaCampos() {
        this.tfBairro.setText("");
        this.tfCEP.setText("");
        this.tfComplemento.setText("");
        this.tfCpfCnpjRes.setText("");
        this.tfLogradouro.setText("");
        this.tfNumero.setText("");
        this.tfObservacao.setText("");
        this.tfReferencia.setText("");
        this.tfResponsavel.setText("");
        this.tfCidade.setText("");
        this.tfCidade.clear();
    }

    private void excluiEnderecoNFCe() {
        if (isPedido.booleanValue()) {
            this.getPedido().setEnderecoEntrega(null);
            StaticObjects.refreshPedido();
            Alerts.showAlertInfo("Endere\u00e7o exclu\u00eddo do pedido!");
        } else {
            this.getNFCe().setEnderecoEntrega(null);
            StaticObjects.refreshNFCe();
            Alerts.showAlertInfo("Endere\u00e7o exclu\u00eddo da NFCe!");
        }
        this.limpaCampos();
        this.closeDialog();
    }

    @Override
    public void posInitialize() {
        this.currentToScreen();
    }

    private NFCe getNFCe() {
        return StaticObjects.getNfceAberta();
    }

    private Pedido getPedido() {
        return StaticObjects.getPedidoAberto();
    }

    private void currentToScreen() {
        if (this.getNFCe() == null || this.getNFCe().getEnderecoEntrega() == null) {
            return;
        }
        NFCeEnderecoEntrega endereco = this.getNFCe().getEnderecoEntrega();
        this.tfLogradouro.setText(endereco.getLogradouro());
        this.tfBairro.setText(endereco.getBairro());
        this.tfNumero.setText(endereco.getNumero());
        this.tfCEP.setText(endereco.getCep());
        this.tfComplemento.setText(endereco.getComplemento());
        this.tfReferencia.setText(endereco.getReferencia());
        this.tfObservacao.setText(endereco.getObservacao());
        this.tfResponsavel.setText(endereco.getNomePessoaResp());
        this.tfCpfCnpjRes.setText(endereco.getCpfCnpj());
        if (endereco.getCidade() != null) {
            this.cmbUF.getSelectionModel().select((Object)endereco.getCidade().getUf());
            this.tfCidade.setText(endereco.getCidade().getDescricao());
        }
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt == null) {
            return;
        }
        switch (evt.getCode()) {
            case F12: {
                this.informaEndereco();
                break;
            }
            case F2: {
                this.findEnderecoEntregaCliente();
                break;
            }
            case ESCAPE: {
                this.closeDialog();
                break;
            }
            case DELETE: {
                this.excluiEnderecoNFCe();
                break;
            }
            case ENTER: {
                if (!this.tfCEP.isFocused() || this.tfCEP.getText() == null || this.tfCEP.getText().length() <= 0) break;
                this.findEnderecoByCEP();
                this.tfNumero.requestFocus();
                break;
            }
        }
    }

    private void informaEndereco() {
        String cpfCnpj = ToolString.onlyNumbers((String)this.tfCpfCnpjRes.getText());
        if (cpfCnpj != null && cpfCnpj.length() > 0 && !ValidadeCPFCNPJ.isValid((String)cpfCnpj)) {
            Alerts.showAlertError("O CPF/CNPJ informado \u00e9 inv\u00e1lido", this.getStage());
            return;
        }
        if (this.isInformadoEndereco() && this.isValidBeforeEndereco()) {
            if (isPedido.booleanValue()) {
                EnderecoEntregaPedido endPedido = new EnderecoEntregaPedido();
                endPedido.setLogradouro(this.tfLogradouro.getText());
                endPedido.setBairro(this.tfBairro.getText());
                endPedido.setCep(this.tfCEP.getText());
                endPedido.setCidade(this.tfCidade.getSelectedValue());
                endPedido.setComplemento(this.tfComplemento.getText());
                endPedido.setNumero(this.tfNumero.getText());
                endPedido.setObservacao(this.tfObservacao.getText());
                endPedido.setReferencia(this.tfReferencia.getText());
                endPedido.setNomePessoaResp(this.tfResponsavel.getText());
                endPedido.setCpfCnpj(cpfCnpj);
                this.getPedido().setEnderecoEntrega(endPedido);
                StaticObjects.refreshPedido();
            }
            if (!isPedido.booleanValue()) {
                NFCeEnderecoEntrega endereco = new NFCeEnderecoEntrega();
                endereco.setLogradouro(this.tfLogradouro.getText());
                endereco.setBairro(this.tfBairro.getText());
                endereco.setCep(this.tfCEP.getText());
                endereco.setCidade(this.tfCidade.getSelectedValue());
                endereco.setComplemento(this.tfComplemento.getText());
                endereco.setNumero(this.tfNumero.getText());
                endereco.setObservacao(this.tfObservacao.getText());
                endereco.setReferencia(this.tfReferencia.getText());
                endereco.setNomePessoaResp(this.tfResponsavel.getText());
                endereco.setCpfCnpj(cpfCnpj);
                this.getNFCe().setEnderecoEntrega(endereco);
                StaticObjects.refreshNFCe();
            }
            this.closeDialog();
        }
    }

    private boolean isInformadoEndereco() {
        String str = this.tfLogradouro.getText();
        return str != null && str.length() > 0;
    }

    private void iniciaCombo() {
        ServiceUnidadeFederativa serviceUF = Main.getBean(ServiceUnidadeFederativa.class);
        List ufs = serviceUF.getAll();
        this.cmbUF.setItems(FXCollections.observableArrayList(ufs));
    }

    private boolean isValidBeforeEndereco() {
        boolean retValue = this.tfLogradouro.getText().isEmpty();
        if (retValue) {
            Alerts.showAlertInfo("Campo Logradouro \u00e9 obrigat\u00f3rio.", this.getStage());
            this.tfLogradouro.requestFocus();
            return false;
        }
        retValue = this.tfNumero.getText().isEmpty();
        if (retValue) {
            Alerts.showAlertInfo("Campo numero \u00e9 obrigat\u00f3rio.", this.getStage());
            this.tfNumero.requestFocus();
            return false;
        }
        retValue = this.tfBairro.getText().isEmpty();
        if (retValue) {
            Alerts.showAlertInfo("Campo bairro \u00e9 obrigat\u00f3rio.", this.getStage());
            this.tfBairro.requestFocus();
            return false;
        }
        boolean bl = retValue = this.tfCidade.getSelectedValue() == null;
        if (retValue) {
            Alerts.showAlertInfo("Campo Cidade \u00e9 obrigat\u00f3rio.", this.getStage());
            this.tfCidade.requestFocus();
            return false;
        }
        boolean bl2 = retValue = this.tfCpfCnpjRes.getText() == null || this.tfCpfCnpjRes.getText().isEmpty();
        if (retValue) {
            Alerts.showAlertInfo("Campo CPF/CNPJ Respons\u00e1vel \u00e9 obrigat\u00f3rio.", this.getStage());
            this.tfCpfCnpjRes.requestFocus();
            return false;
        }
        return true;
    }

    public UnidadeFederativa getUF() {
        return (UnidadeFederativa)this.cmbUF.getValue();
    }

    private void findEnderecoEntregaCliente() {
        NFCe nfce = StaticObjects.getNfceAberta();
        if (nfce == null) {
            Alerts.showAlertError("Nenhuma NFCe aberta para pesquisa do endere\u00e7o do cliente!", this.getStage());
            return;
        }
        if (nfce.getUnidadeFatCliente() == null) {
            Alerts.showAlertError("Nenhum cliente encontrado para a NFCe aberta no sistema!", this.getStage());
            return;
        }
        if (nfce.getUnidadeFatCliente().getEnderecoEntrega() != null) {
            Endereco end = nfce.getUnidadeFatCliente().getEnderecoEntrega();
            this.tfCEP.setText(end.getCep());
            this.tfLogradouro.setText(end.getLogradouro());
            this.tfBairro.setText(end.getBairro());
            this.tfComplemento.setText(end.getComplemento());
            this.tfObservacao.setText(end.getObservacao());
            this.tfNumero.setText(end.getNumero());
            this.tfReferencia.setText(end.getReferencia());
            this.tfCidade.selectValue(end.getCidade());
        } else if (nfce.getUnidadeFatCliente().getPessoa() != null) {
            Endereco end = nfce.getUnidadeFatCliente().getPessoa().getEndereco();
            this.tfCEP.setText(end.getCep());
            this.tfLogradouro.setText(end.getLogradouro());
            this.tfBairro.setText(end.getBairro());
            this.tfComplemento.setText(end.getComplemento());
            this.tfObservacao.setText(end.getObservacao());
            this.tfNumero.setText(end.getNumero());
            this.tfReferencia.setText(end.getReferencia());
            this.tfCidade.selectValue(end.getCidade());
        }
    }

    @Override
    public void eventAltControl(KeyEvent event) {
    }

    private void findEnderecoByCEP() {
        try {
            String cep = this.tfCEP.getText();
            cep = ToolString.completaZeros((String)ToolString.refina((String)cep), (int)8, (boolean)false);
            TempImplLogradouro temp = UtilPesquisaCEP.pesquisaEnderecoCep(cep);
            if (temp != null) {
                this.tfLogradouro.setText(temp.getLogradouro());
                this.tfBairro.setText(temp.getBairro());
                this.tfComplemento.setText(temp.getComplemento());
                this.tfCidade.selectValue(temp.getCidade());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Alerts.showAlertInfo("Erro ao carreggar endere\u00e7o de forma automatica. " + String.valueOf(ex.getCause()), this.getStage());
        }
    }

    public void onItemListener(Object data) {
        Cidade cidadeSel = (Cidade)data;
        if (cidadeSel != null) {
            this.cmbUF.getSelectionModel().select((Object)cidadeSel.getUf());
        }
    }

    @Override
    public SortedSet onTextChange(String text) {
        TreeSet<Cidade> cidades = new TreeSet<Cidade>();
        ServiceCidade serviceCidade = Main.getBean(ServiceCidade.class);
        cidades.addAll(serviceCidade.findCidadeDescricao(text, (UnidadeFederativa)this.cmbUF.getSelectionModel().getSelectedItem()));
        return cidades;
    }
}

