/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.endereco;

import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.others.cpfcnpj.ValidadeCPFCNPJ;
import com.touchcomp.basementorvalidator.others.data.ValidateData;
import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.AutoCompleteTextField;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.components.listener.FocusListener;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.model.Cidade;
import com.touchcomp.touchnfce.model.Endereco;
import com.touchcomp.touchnfce.model.EnderecoEntregaPedido;
import com.touchcomp.touchnfce.model.Pedido;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.modeltemp.TempImplLogradouro;
import com.touchcomp.touchnfce.service.impl.ServiceCidade;
import com.touchcomp.touchnfce.tasks.utils.UtilPesquisaCEP;
import com.touchcomp.touchnfce.utils.MaskField;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;

public class EnderecoEntregaPedidoController
extends BaseDialog
implements AutoCompleteTextField.ItemSelListener,
AutoCompleteTextField.ItemSourceFilter {
    @FXML
    private Label lblLogradouro;
    @FXML
    private Label lblNumero;
    @FXML
    private Label lblBairro;
    @FXML
    private Label lblCidade;
    @FXML
    private Label lblReferencia;
    @FXML
    private Label lblComplemento;
    @FXML
    private Label lblObservacao;
    @FXML
    private Label lblCEP;
    @FXML
    private Label lblCpfCnpjRes;
    @FXML
    private Label lblReponsavel;
    @FXML
    private Button btnCancelar;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnExcEndNfce;
    @FXML
    private Button btnPesquisarEndCliente;
    @FXML
    private TouchTextField tfLogradouro;
    @FXML
    private TouchTextField tfNumero;
    @FXML
    private TouchTextField tfBairro;
    @FXML
    private TouchTextField tfReferencia;
    @FXML
    private TouchTextField tfComplemento;
    @FXML
    private TouchTextField tfObservacao;
    @FXML
    private TouchTextField tfCEP;
    @FXML
    private TouchTextField tfCpfCnpjRes;
    @FXML
    private TouchTextField tfResponsavel;
    @FXML
    private AutoCompleteTextField<Cidade> tfCidade;
    @FXML
    private AnchorPane body;

    @Override
    public void initializeController(ResourceBundle rb) {
        this.tfNumero.textProperty().addListener((observableValue, antigo, novo) -> this.tfNumero.setText(MaskField.onlyDigitsDoubleValue(this.tfNumero)));
        this.tfCEP.textProperty().addListener((observableValue, antigo, novo) -> {
            if (this.tfCEP.getText().length() < 10) {
                this.tfCEP.setText(ToolFormatter.formatCNPJCPF((String)novo) != null ? ToolFormatter.formatCNPJCPF((String)novo) : novo);
            }
        });
        this.tfCEP.addFocusListener(new FocusListener(){

            @Override
            public void onFocusGained() {
            }

            @Override
            public void onFocusLost() {
                EnderecoEntregaPedidoController.this.findEnderecoByCEP();
            }
        });
        this.btnCancelar.setOnAction(event -> this.closeDialog());
        this.btnPesquisarEndCliente.setOnAction(event -> this.findEnderecoCliente());
        this.btnConfirmar.setOnAction(event -> this.informaEndereco());
        this.btnExcEndNfce.setOnAction(event -> this.excluiEnderecoPedido());
        MaskField.cpfCnpjField(this.tfCpfCnpjRes);
        this.setLabelsTextField();
    }

    private void setLabelsTextField() {
        this.tfBairro.setLabel(this.lblBairro);
        this.tfCEP.setLabel(this.lblCEP);
        this.tfComplemento.setLabel(this.lblComplemento);
        this.tfCpfCnpjRes.setLabel(this.lblCpfCnpjRes);
        this.tfLogradouro.setLabel(this.lblLogradouro);
        this.tfNumero.setLabel(this.lblNumero);
        this.tfObservacao.setLabel(this.lblObservacao);
        this.tfReferencia.setLabel(this.lblReferencia);
        this.tfResponsavel.setLabel(this.lblReponsavel);
        this.tfCidade.setLabel(this.lblCidade);
        this.btnCancelar.setFocusTraversable(false);
        this.btnConfirmar.setFocusTraversable(false);
        this.btnExcEndNfce.setFocusTraversable(false);
        this.btnPesquisarEndCliente.setFocusTraversable(false);
        this.tfCidade.setItemSelListener(this);
        this.tfCidade.setItemSourceFilter(this);
    }

    @Override
    public void requestFocusOnOpen() {
        this.tfCEP.requestFocus();
    }

    private void limpaCampos() {
        this.tfBairro.setText("");
        this.tfCEP.setText("");
        this.tfComplemento.setText("");
        this.tfCpfCnpjRes.setText("");
        this.tfLogradouro.setText("");
        this.tfNumero.setText("");
        this.tfObservacao.setText("");
        this.tfReferencia.setText("");
        this.tfResponsavel.setText("");
        this.tfCidade.selectValue(null);
    }

    private void excluiEnderecoPedido() {
        if (this.getPedido() != null && this.getPedido().getEnderecoEntrega() != null) {
            this.getPedido().setEnderecoEntrega(null);
            Alerts.showAlertInfo("Endere\u00e7o exclu\u00eddo do Pedido!");
            this.atualizaPedido();
            this.limpaCampos();
        } else {
            Alerts.showAlertError("Nenhum endere\u00e7o de entrega vinculado a este Pedido!");
        }
    }

    @Override
    public void posInitialize() {
        this.currentToScreen();
    }

    private Pedido getPedido() {
        return StaticObjects.getPedidoAberto();
    }

    private void currentToScreen() {
        if (this.getPedido() == null) {
            return;
        }
        EnderecoEntregaPedido endereco = this.getPedido().getEnderecoEntrega();
        if (endereco == null) {
            return;
        }
        this.tfLogradouro.setText(endereco.getLogradouro());
        this.tfBairro.setText(endereco.getBairro());
        this.tfNumero.setText(endereco.getNumero());
        this.tfCEP.setText(endereco.getCep());
        this.tfComplemento.setText(endereco.getComplemento());
        this.tfReferencia.setText(endereco.getReferencia());
        this.tfObservacao.setText(endereco.getObservacao());
        this.tfCidade.selectValue(endereco.getCidade());
        this.tfCpfCnpjRes.setText(endereco.getCpfCnpj());
        this.tfResponsavel.setText(endereco.getNomePessoaResp());
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt == null) {
            return;
        }
        switch (evt.getCode()) {
            case F12: {
                this.informaEndereco();
                break;
            }
            case F2: {
                this.findEnderecoCliente();
                break;
            }
            case ESCAPE: {
                this.closeDialog();
                break;
            }
            case DELETE: {
                Optional<ButtonType> type = Alerts.showQuestion("Tem certeza que deseja excluir o endere\u00e7o desse pedido?");
                if (type.get() == ButtonType.OK) break;
                this.excluiEnderecoPedido();
                break;
            }
            case ENTER: {
                if (!this.tfCEP.isFocused() || this.tfCEP.getText() == null || this.tfCEP.getText().length() <= 0) break;
                this.findEnderecoByCEP();
                this.tfNumero.requestFocus();
                break;
            }
        }
    }

    private void informaEndereco() {
        try {
            if (!this.isValidBefore()) {
                return;
            }
            EnderecoEntregaPedido endereco = new EnderecoEntregaPedido();
            String cpfCnpj = this.tfCpfCnpjRes.getText();
            if (!cpfCnpj.isEmpty()) {
                if (!ValidateData.isValid((String[])new String[]{cpfCnpj})) {
                    Alerts.showAlertError("O CPF/CNPJ informado \u00e9 inv\u00e1lido");
                    return;
                }
                if (!ValidadeCPFCNPJ.isValid((String)cpfCnpj)) {
                    Alerts.showAlertError("O CPF/CNPJ informado \u00e9 inv\u00e1lido");
                    return;
                }
            }
            endereco.setLogradouro(this.tfLogradouro.getText());
            endereco.setBairro(this.tfBairro.getText());
            endereco.setCep(this.tfCEP.getText());
            endereco.setCidade(this.tfCidade.getSelectedValue());
            endereco.setComplemento(this.tfComplemento.getText());
            endereco.setNumero(this.tfNumero.getText());
            endereco.setObservacao(this.tfObservacao.getText());
            endereco.setReferencia(this.tfReferencia.getText());
            endereco.setNomePessoaResp(this.tfResponsavel.getText());
            cpfCnpj = this.tfCpfCnpjRes.getText();
            if (cpfCnpj != null && !cpfCnpj.isEmpty()) {
                cpfCnpj = cpfCnpj.replace(".", "");
                cpfCnpj = cpfCnpj.replace("-", "");
                cpfCnpj = cpfCnpj.replace("/", "");
            }
            endereco.setCpfCnpj(cpfCnpj);
            this.getPedido().setEnderecoEntrega(endereco);
            this.atualizaPedido();
            this.closeDialog();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Alerts.showAlertInfo("Erro ao atualizar o pedido com o endere\u00e7o informado. " + ex.getMessage(), this.getStage());
        }
    }

    private void atualizaPedido() {
        try {
            StaticObjects.refreshPedido();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Alerts.showAlertInfo("Erro ao atualizar o pedido com o endere\u00e7o informado. " + ex.getMessage(), this.getStage());
        }
    }

    private boolean isValidBefore() {
        boolean retValue = false;
        retValue = this.tfLogradouro.getText().isEmpty();
        if (retValue) {
            Alerts.showAlertInfo("Campo Logradouro \u00e9 obrigat\u00f3rio.");
            this.tfLogradouro.requestFocus();
            return false;
        }
        retValue = this.tfNumero.getText().isEmpty();
        if (retValue) {
            Alerts.showAlertInfo("Campo numero \u00e9 obrigat\u00f3rio.");
            this.tfNumero.requestFocus();
            return false;
        }
        retValue = this.tfBairro.getText().isEmpty();
        if (retValue) {
            Alerts.showAlertInfo("Campo bairro \u00e9 obrigat\u00f3rio.");
            this.tfBairro.requestFocus();
            return false;
        }
        boolean bl = retValue = this.tfCidade.getSelectedValue() == null;
        if (retValue) {
            Alerts.showAlertInfo("Campo Cidade \u00e9 obrigat\u00f3rio.");
            this.tfCidade.requestFocus();
            return false;
        }
        return true;
    }

    private void findEnderecoCliente() {
        if (this.getPedido() == null) {
            Alerts.showAlertError("Nenhuma Pedido aberto para pesquisa do endere\u00e7o do cliente!");
            return;
        }
        if (this.getPedido().getUnidadeFatCliente() == null) {
            Alerts.showAlertError("Nenhum cliente encontrado para o Pedido aberto no sistema!");
            return;
        }
        if (this.getPedido().getUnidadeFatCliente().getEnderecoEntrega() != null) {
            UnidadeFatCliente u = StaticObjects.getPedidoAberto().getUnidadeFatCliente();
            this.tfLogradouro.setText(u.getEnderecoEntrega().getLogradouro());
            this.tfBairro.setText(u.getEnderecoEntrega().getBairro());
            this.tfNumero.setText(u.getEnderecoEntrega().getNumero());
            this.tfCEP.setText(u.getEnderecoEntrega().getCep());
            this.tfComplemento.setText(u.getEnderecoEntrega().getComplemento());
            this.tfReferencia.setText(u.getEnderecoEntrega().getReferencia());
            this.tfObservacao.setText(u.getEnderecoEntrega().getObservacao());
            this.tfCidade.selectValue(u.getEnderecoEntrega().getCidade());
        } else if (this.getPedido().getUnidadeFatCliente().getPessoa() != null) {
            Endereco end = StaticObjects.getPedidoAberto().getUnidadeFatCliente().getPessoa().getEndereco();
            this.tfCEP.setText(end.getCep());
            this.tfLogradouro.setText(end.getLogradouro());
            this.tfBairro.setText(end.getBairro());
            this.tfComplemento.setText(end.getComplemento());
            this.tfObservacao.setText(end.getObservacao());
            this.tfNumero.setText(end.getNumero());
            this.tfReferencia.setText(end.getReferencia());
            this.tfCidade.selectValue(end.getCidade());
        }
    }

    @Override
    public void eventAltControl(KeyEvent event) {
    }

    private void findEnderecoByCEP() {
        try {
            String cep = this.tfCEP.getText();
            cep = ToolString.completaZeros((String)ToolString.refina((String)cep), (int)8, (boolean)false);
            if (cep.length() > 8) {
                Alerts.showAlertError("o CEP n\u00e3o pode conter mais que 8 digitos");
                return;
            }
            TempImplLogradouro temp = UtilPesquisaCEP.pesquisaEnderecoCep(cep);
            if (temp != null) {
                this.tfLogradouro.setText(temp.getLogradouro());
                this.tfBairro.setText(temp.getBairro());
                this.tfComplemento.setText(temp.getComplemento());
                this.tfCidade.selectValue(temp.getCidade());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Alerts.showAlertInfo("Erro ao consultar CEP online. " + ex.getMessage() + "\n\n Certifique se o mesmo foi degitado de forma correta ou cadastre o endere\u00e7o de forma manual!", this.getStage());
        }
    }

    public void onItemListener(Object data) {
        Cidade cidadeSel = (Cidade)data;
    }

    @Override
    public SortedSet onTextChange(String text) {
        TreeSet<Cidade> cidades = new TreeSet<Cidade>();
        ServiceCidade serviceCidade = Main.getBean(ServiceCidade.class);
        cidades.addAll(serviceCidade.findCidadeDescricao(text));
        return cidades;
    }
}

