/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.formapagamento;

import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoAutenticacao;
import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoDesconto;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoPagNFe;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.AutoCompleteTextField;
import com.touchcomp.touchnfce.components.TouchButton;
import com.touchcomp.touchnfce.components.TouchDoubleField;
import com.touchcomp.touchnfce.components.listener.FocusListener;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.controller.login.LoginAutorizacaoController;
import com.touchcomp.touchnfce.model.ItemPedido;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeOpcoesGrupoDesc;
import com.touchcomp.touchnfce.model.TipoPagamentoNFe;
import com.touchcomp.touchnfce.service.impl.ServiceTipoPagamentoNFe;
import com.touchcomp.touchnfce.utils.UtilPermissaoUsuario;
import java.util.HashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyEvent;
import javafx.scene.text.TextAlignment;

public abstract class GrupoFormaPagamento
extends BaseController {
    @FXML
    protected Label lblTotalItens;
    @FXML
    protected Label vlrRecebido;
    @FXML
    protected Label totalCompra;
    @FXML
    protected Label troco;
    @FXML
    protected Label lblAcrescimo;
    @FXML
    protected Label lblOpPagamento;
    @FXML
    protected Label lblOpPag1;
    @FXML
    protected Label lblOpPag2;
    @FXML
    protected Label lblOpPag3;
    @FXML
    protected Label lblOpPag4;
    @FXML
    protected Label lblDesconto;
    @FXML
    protected Label lblFormaPag;
    @FXML
    protected TouchButton acrescimoPor;
    @FXML
    protected TouchButton acrescimoReais;
    @FXML
    protected TouchButton descontoPor;
    @FXML
    protected TouchButton descontoReais;
    @FXML
    protected TouchButton btnFocusOpPagamento;
    @FXML
    protected TouchButton finalizar;
    @FXML
    protected TouchButton voltar;
    @FXML
    protected TouchButton btnPreferenciaTP1;
    @FXML
    protected TouchButton btnPreferenciaTP2;
    @FXML
    protected TouchButton btnPreferenciaTP3;
    @FXML
    protected TouchButton btnPreferenciaTP4;
    @FXML
    protected TouchButton btnPagamentos;
    @FXML
    protected TouchButton enviaNFeEmail;
    @FXML
    protected TouchButton btnCondicoesPagamento;
    @FXML
    protected TouchDoubleField tfTotalItens;
    @FXML
    protected TouchDoubleField tfVlrRecebido;
    @FXML
    protected TouchDoubleField tfTotalCompra;
    @FXML
    protected TouchDoubleField tfTroco;
    @FXML
    protected TouchDoubleField tfAcrescimo;
    @FXML
    protected TouchDoubleField tfDesconto;
    @FXML
    protected AutoCompleteTextField txtOperacaoPagamento;
    @FXML
    protected TableView tableFormasPag;
    private Short tipoDesconto;
    private Short tipoAcrescimo;
    public static boolean pagamentoEmAndamento = false;
    public NFCeOpcoesGrupoDesc grupo = null;

    @Override
    protected void initializeController(ResourceBundle rb) {
        this.setPropertiesTablePagamentos();
        this.lblOpPagamento.setText("Selecione uma forma de pagamento!");
        this.tfDesconto.setEditable(false);
        this.tfAcrescimo.setEditable(false);
        this.setActionButttonsPadrao();
        this.intializeWidgets();
        this.setTipoPagamentoButton();
        this.initialize();
        this.setPropertiesWidgets();
        this.txtOperacaoPagamento.setLabel(this.lblOpPagamento);
        this.tfAcrescimo.setLabel(this.lblAcrescimo);
        this.tfDesconto.setLabel(this.lblDesconto);
    }

    private void setPropertiesWidgets() {
        this.tfTotalCompra.setFocusTraversable(false);
        this.tfTotalItens.setFocusTraversable(false);
        this.tfTroco.setFocusTraversable(false);
        this.tfVlrRecebido.setFocusTraversable(false);
        this.tableFormasPag.setFocusTraversable(false);
        this.txtOperacaoPagamento.setLabel(this.lblOpPagamento);
        this.tfDesconto.setLabel(this.lblDesconto);
        this.tfAcrescimo.setLabel(this.lblAcrescimo);
    }

    private void verificaTpPagPrincipais(TouchButton btnPreferencia) {
        if (((TipoPagamentoNFe)btnPreferencia.getUserData()).getCodigo().equals(EnumConstNFeTipoPagNFe.CARTAO_CREDITO.getCodigo())) {
            btnPreferencia.getStyleClass().add((Object)"menu-button-circle-credit");
        } else if (((TipoPagamentoNFe)btnPreferencia.getUserData()).getCodigo().equals(EnumConstNFeTipoPagNFe.CARTAO_DEBITO.getCodigo())) {
            btnPreferencia.getStyleClass().add((Object)"menu-button-circle-debit");
        } else if (((TipoPagamentoNFe)btnPreferencia.getUserData()).getCodigo().equals(EnumConstNFeTipoPagNFe.CHEQUE.getCodigo())) {
            btnPreferencia.getStyleClass().add((Object)"menu-button-circle-cheque");
        } else {
            btnPreferencia.getStyleClass().add((Object)"menu-button-circle-money");
        }
    }

    private void setTipoPagamentoButton() {
        ServiceTipoPagamentoNFe serviceTpPag = Main.getBean(ServiceTipoPagamentoNFe.class);
        if (StaticObjects.getOpcoes().getPreferencial1() == null) {
            this.btnPreferenciaTP1.setUserData(serviceTpPag.findByCodigo(EnumConstNFeTipoPagNFe.DINHEIRO.getCodigo()));
        } else {
            this.btnPreferenciaTP1.setUserData(StaticObjects.getOpcoes().getPreferencial1());
        }
        if (StaticObjects.getOpcoes().getPreferencial2() == null) {
            this.btnPreferenciaTP2.setUserData(serviceTpPag.findByCodigo(EnumConstNFeTipoPagNFe.CARTAO_CREDITO.getCodigo()));
        } else {
            this.btnPreferenciaTP2.setUserData(StaticObjects.getOpcoes().getPreferencial2());
        }
        if (StaticObjects.getOpcoes().getPreferencial3() == null) {
            this.btnPreferenciaTP3.setUserData(serviceTpPag.findByCodigo(EnumConstNFeTipoPagNFe.CARTAO_DEBITO.getCodigo()));
        } else {
            this.btnPreferenciaTP3.setUserData(StaticObjects.getOpcoes().getPreferencial3());
        }
        if (StaticObjects.getOpcoes().getPreferencial4() == null) {
            this.btnPreferenciaTP4.setUserData(serviceTpPag.findByCodigo(EnumConstNFeTipoPagNFe.CHEQUE.getCodigo()));
        } else {
            this.btnPreferenciaTP4.setUserData(StaticObjects.getOpcoes().getPreferencial4());
        }
        this.verificaTpPagPrincipais(this.btnPreferenciaTP1);
        this.verificaTpPagPrincipais(this.btnPreferenciaTP2);
        this.verificaTpPagPrincipais(this.btnPreferenciaTP3);
        this.verificaTpPagPrincipais(this.btnPreferenciaTP4);
        this.lblOpPag1.setText(this.getDescricaoPagamentoNFCe(((TipoPagamentoNFe)this.btnPreferenciaTP1.getUserData()).getCodigo()));
        this.lblOpPag2.setText(this.getDescricaoPagamentoNFCe(((TipoPagamentoNFe)this.btnPreferenciaTP2.getUserData()).getCodigo()));
        this.lblOpPag3.setText(this.getDescricaoPagamentoNFCe(((TipoPagamentoNFe)this.btnPreferenciaTP3.getUserData()).getCodigo()));
        this.lblOpPag4.setText(this.getDescricaoPagamentoNFCe(((TipoPagamentoNFe)this.btnPreferenciaTP4.getUserData()).getCodigo()));
    }

    @Override
    public void goBack() {
        this.voltar();
        super.goBack();
    }

    @Override
    protected void requestFocusOnOpen() {
        this.txtOperacaoPagamento.requestFocus();
    }

    public abstract void setPropertiesTablePagamentos();

    public abstract void initialize();

    public abstract void voltar();

    public abstract void aplicaDesconto(Short var1);

    public abstract void aplicaAcrescimo(Short var1);

    public abstract void enviaDocumentoFiscalEmail();

    public abstract void fecharDocumentoFiscal();

    public abstract void removePagamento();

    public abstract void eventKeyAux(KeyEvent var1);

    public abstract void removeDescontoAcrescimoNFCe();

    private void intializeWidgets() {
        this.lblOpPagamento.setAlignment(Pos.CENTER);
        this.lblOpPagamento.setTextAlignment(TextAlignment.CENTER);
        this.btnPreferenciaTP2.setScreenStyled(true);
        this.btnPreferenciaTP3.setScreenStyled(true);
        this.btnPreferenciaTP4.setScreenStyled(true);
        this.btnPreferenciaTP1.setScreenStyled(true);
        this.tfTroco.setEditable(false);
        this.tfTotalCompra.setEditable(false);
        this.tfTotalItens.setEditable(false);
        this.tfVlrRecebido.setEditable(false);
    }

    @Override
    public void eventKey(KeyEvent evt) {
        this.defaultTrataEventos(evt);
    }

    private void defaultTrataEventos(KeyEvent evt) {
        switch (evt.getCode()) {
            case F5: {
                this.removeDescontoAcrescimoNFCe();
                break;
            }
            case F12: {
                this.fecharDocumentoFiscal();
                break;
            }
            case F6: {
                this.tableFormasPag.requestFocus();
                this.tableFormasPag.getSelectionModel().selectLast();
                break;
            }
            case F7: {
                if (this.enviaNFeEmail == null) break;
                this.enviaDocumentoFiscalEmail();
                break;
            }
            case DELETE: {
                if (!this.tableFormasPag.isFocused()) break;
                this.verificaRemocaoPagamento();
                break;
            }
            case ESCAPE: {
                this.goBack();
            }
            case ENTER: {
                if (this.tfAcrescimo.isFocused()) {
                    this.tableFormasPag.requestFocus();
                    break;
                }
                if (!this.tfDesconto.isFocused()) break;
                this.tableFormasPag.requestFocus();
                break;
            }
        }
        this.eventKeyAux(evt);
    }

    private void verificaRemocaoPagamento() {
        Optional<ButtonType> type = Alerts.showQuestion("Deseja remover este pagamento?");
        if (type.get() == ButtonType.OK) {
            this.removePagamento();
            this.tableFormasPag.refresh();
            this.txtOperacaoPagamento.requestFocus();
            this.tableFormasPag.getSelectionModel().select(null);
        }
    }

    protected void verificaAplicacaoDesconto() {
        if (!this.isPagamentoFinalizado(true)) {
            return;
        }
        if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getPermitirDescSobDesc(), (Object)0) && StaticObjects.getNfceAberta() != null) {
            boolean descontoItem = false;
            for (NFCeItem i : StaticObjects.getNfceAberta().getItens()) {
                if (!ToolMethods.isEquals((Object)i.getStatus(), (Object)1) || !ToolMethods.isEquals((Object)i.getTipoDesconto(), (Object)EnumConstNFCeTipoDesconto.DESCONTO_ACRESCIMO_ITEM.getValue())) continue;
                descontoItem = true;
                break;
            }
            if (descontoItem) {
                Alerts.showAlertError("N\u00e3o \u00e9 permitido conceder desconto sobre desconto!");
                return;
            }
        }
        this.tfDesconto.setEditable(true);
        this.tfDesconto.requestFocus();
    }

    protected void verificaAplicacaoDescontoPedido() {
        if (!this.isPagamentoFinalizado(true)) {
            return;
        }
        if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getPermitirDescSobDesc(), (Object)0) && StaticObjects.getPedidoAberto() != null) {
            boolean descontoItem = false;
            for (ItemPedido i : StaticObjects.getPedidoAberto().getItemPedido()) {
                if (!ToolMethods.isEquals((Object)i.getDescontoItem(), (Object)1)) continue;
                descontoItem = true;
                break;
            }
            if (descontoItem) {
                Alerts.showAlertError("N\u00e3o \u00e9 permitido conceder desconto sobre desconto!");
                return;
            }
        }
        this.tfDesconto.setEditable(true);
        this.tfDesconto.requestFocus();
    }

    protected void verificaPermissaoDesconto() {
        Double percDesc = this.tfDesconto.getDouble();
        if (ToolMethods.isEquals((Object)this.tipoDesconto, (Object)1)) {
            percDesc = ToolFormatter.arrredondarNumero((Double)(this.tfDesconto.getDouble() / this.tfTotalItens.getDouble() * 100.0), (int)4);
        }
        if (percDesc >= 100.0) {
            Alerts.showAlertError("Percentual de desconto n\u00e3o pode ser maior que 100%.");
            this.tfDesconto.setDouble(0.0);
            this.tfDesconto.requestFocus();
            return;
        }
        boolean res = UtilPermissaoUsuario.isPermitidoDesconto(StaticObjects.getUsuario(), percDesc);
        if (!res) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("tipo_autenticacao", EnumConstNFCeTipoAutenticacao.AUTENTICACAO_DESCONTO_GERAL);
            h.put("percentual", percDesc);
            LoginAutorizacaoController loginController = (LoginAutorizacaoController)Main.get().showDialog(Controllers.LOGIN_AUTORIZACAO, h);
            if (loginController.getUsuario() == null) {
                Alerts.showAlertError("Voc\u00ea n\u00e3o possui autoriza\u00e7\u00e3o para realizar essa opera\u00e7\u00e3o");
                this.tfDesconto.setDouble(0.0);
                this.tfDesconto.requestFocus();
                return;
            }
            if (StaticObjects.getNfceAberta() != null) {
                UtilPermissaoUsuario.createAndAddLogNotExists(loginController.getUsuario(), EnumConstNFCeTipoAutenticacao.AUTENTICACAO_DESCONTO_GERAL, StaticObjects.getNfceAberta(), null);
            }
        }
        this.aplicaDesconto();
    }

    protected void verificaPermissaoAcrescimo() {
        Double percAcresc = this.tfAcrescimo.getDouble();
        if (ToolMethods.isEquals((Object)this.tipoAcrescimo, (Object)1)) {
            percAcresc = ToolFormatter.arrredondarNumero((Double)(this.tfAcrescimo.getDouble() / this.tfTotalItens.getDouble() * 100.0), (int)4);
        }
        this.aplicaAcrescimo();
    }

    protected void verificaAplicacaoAcrescimo() {
        if (!this.isPagamentoFinalizado(true)) {
            return;
        }
        this.tfAcrescimo.setEditable(true);
        this.tfAcrescimo.requestFocus();
    }

    protected abstract boolean isPagamentoFinalizado(boolean var1);

    private void aplicaDesconto() {
        this.aplicaDesconto(this.getTipoDesconto());
        this.txtOperacaoPagamento.requestFocus();
        this.tfDesconto.setEditable(false);
    }

    private void aplicaAcrescimo() {
        this.aplicaAcrescimo(this.getTipoAcrescimo());
        this.txtOperacaoPagamento.requestFocus();
        this.tfAcrescimo.setEditable(false);
    }

    private void setActionButttonsPadrao() {
        this.finalizar.setOnAction(event -> this.fecharDocumentoFiscal());
        this.btnFocusOpPagamento.setOnAction(event -> this.removeDescontoAcrescimoNFCe());
        this.voltar.setOnAction(event -> this.goBack());
        this.btnPagamentos.setOnAction(event -> {
            this.tableFormasPag.requestFocus();
            this.tableFormasPag.getSelectionModel().selectFirst();
        });
        this.descontoPor.setOnAction(event -> {
            this.setTipoDesconto((short)0);
            this.verificaAplicacaoDesconto();
        });
        this.descontoReais.setOnAction(event -> {
            this.setTipoDesconto((short)1);
            this.verificaAplicacaoDesconto();
        });
        this.acrescimoPor.setOnAction(event -> {
            this.setTipoAcrescimo((short)0);
            this.verificaAplicacaoAcrescimo();
        });
        this.acrescimoReais.setOnAction(event -> {
            this.setTipoAcrescimo((short)1);
            this.verificaAplicacaoAcrescimo();
        });
        this.voltar.setOnAction(event -> this.goBack());
        if (this.enviaNFeEmail != null) {
            this.enviaNFeEmail.setOnAction(event -> this.enviaDocumentoFiscalEmail());
        }
        this.tfDesconto.addFocusListener(new FocusListener(){

            @Override
            public void onFocusGained() {
            }

            @Override
            public void onFocusLost() {
                if (GrupoFormaPagamento.this.tfDesconto.isEditable()) {
                    GrupoFormaPagamento.this.verificaPermissaoDesconto();
                }
            }
        });
        this.tfAcrescimo.addFocusListener(new FocusListener(){

            @Override
            public void onFocusGained() {
            }

            @Override
            public void onFocusLost() {
                if (GrupoFormaPagamento.this.tfAcrescimo.isEditable()) {
                    GrupoFormaPagamento.this.verificaPermissaoAcrescimo();
                }
            }
        });
    }

    private String getDescricaoPagamentoNFCe(String codigo) {
        if (codigo.equals("01")) {
            return "Dinheiro";
        }
        if (codigo.equals("02")) {
            return "Cheque";
        }
        if (codigo.equals("03")) {
            return "Cart. Cred.";
        }
        if (codigo.equals("04")) {
            return "Cart. Deb.";
        }
        if (codigo.equals("05")) {
            return "Cred. Loja";
        }
        if (codigo.equals("10")) {
            return "Vale Ali.";
        }
        if (codigo.equals("11")) {
            return "Vale Ref.";
        }
        if (codigo.equals("12")) {
            return "Vale Pres.";
        }
        if (codigo.equals("13")) {
            return "Vale Comb.";
        }
        if (codigo.equals("15")) {
            return "Boleto";
        }
        if (codigo.equals("90")) {
            return "Sem Pag.";
        }
        if (codigo.equals("99")) {
            return "Outros";
        }
        if (codigo.equals("14")) {
            return "Duplicata";
        }
        if (codigo.equals("17") || codigo.equals("20")) {
            return "Pix";
        }
        return "N\u00e3o Info.";
    }

    public Short getTipoDesconto() {
        return this.tipoDesconto;
    }

    public void setTipoDesconto(Short tipoDesconto) {
        this.tipoDesconto = tipoDesconto;
        if (ToolMethods.isEquals((Object)tipoDesconto, (Object)0)) {
            this.lblDesconto.setText("Desconto %");
        } else {
            this.lblDesconto.setText("Desconto $");
        }
    }

    public Short getTipoAcrescimo() {
        return this.tipoAcrescimo;
    }

    public void setTipoAcrescimo(Short tipoAcrescimo) {
        this.tipoAcrescimo = tipoAcrescimo;
        if (ToolMethods.isEquals((Object)tipoAcrescimo, (Object)0)) {
            this.lblAcrescimo.setText("Acrescimo %");
        } else {
            this.lblAcrescimo.setText("Acrescimo $");
        }
    }
}

