/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.menu;

import com.touchcomp.basementor.constants.enums.EnumConstAbertoFechado;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.controller.abastecimento.CentralAbastecimentoSimplificada;
import com.touchcomp.touchnfce.properties.ConfPropertiesLoader;
import java.awt.Dimension;
import java.util.Date;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class MenuPrincipalNFCeController
extends BaseController {
    public static final String VIEW_PATH = "/view/menu/MenuPrincipalNFCeLayout.fxml";
    public static final Dimension PREF_WIDTH = new Dimension(720, 1280);
    @FXML
    private VBox paneAbertCaixa;
    @FXML
    private VBox paneEntradaMov;
    @FXML
    private VBox paneFechamentoCaixa;
    @FXML
    private VBox panePreVenda;
    @FXML
    private VBox paneOutrasOp;
    @FXML
    private VBox paneAbastecimento;
    @FXML
    private VBox paneOpcoesSincronizacao;
    @FXML
    private VBox paneSaidaMov;
    @FXML
    private VBox paneConsistNfce;
    @FXML
    private VBox paneVendas;
    @FXML
    private VBox paneSincronizarDados;
    @FXML
    private Label lblEmpresa;
    @FXML
    private Label lblVendas;
    @FXML
    private Label lblConsistNfce;
    @FXML
    private Label lblAbertCaixa;
    @FXML
    private Label lblOutrasOp;
    @FXML
    private Label lblOpSinc;
    @FXML
    private Label lblSincDados;
    @FXML
    private Label lblFecCaixa;
    @FXML
    private Label lblEntradaMov;
    @FXML
    private Label lblSaidaMov;
    @FXML
    private Label lblPreVenda;
    @FXML
    private AnchorPane body;

    @Override
    protected void initializeController(ResourceBundle rb) {
        this.paneVendas.setOnMouseClicked(event -> this.vaiTelaVenda());
        this.paneAbertCaixa.setOnMouseClicked(event -> this.vaiTelaAbreCaixa());
        this.paneEntradaMov.setOnMouseClicked(event -> this.vaiEntradaMovCaixa());
        this.paneSaidaMov.setOnMouseClicked(event -> this.vaiSaidaMovCaixa());
        this.paneSincronizarDados.setOnMouseClicked(event -> Main.get().mudaTela(Controllers.SINCRONIZAR_DADOS));
        this.paneOutrasOp.setOnMouseClicked(event -> Main.get().mudaTela(Controllers.OUTRAS_OPCOES));
        this.paneOpcoesSincronizacao.setOnMouseClicked(event -> Main.get().mudaTela(Controllers.OPCOES_SINCRONIZACAO, Controllers.MENU_PRINCIPAL));
        this.paneConsistNfce.setOnMouseClicked(event -> Main.get().mudaTela(Controllers.CONSISTENCIA_NFCE));
        this.paneFechamentoCaixa.setOnMouseClicked(event -> this.vaiTelaFechamentoCaixa());
        this.panePreVenda.setOnMouseClicked(event -> this.vaiTelaPreVenda());
        this.paneAbastecimento.setOnMouseClicked(event -> this.vaiTelaAbastecimento());
        if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getUtilizarPreVenda(), (Object)1)) {
            this.panePreVenda.setDisable(Boolean.FALSE.booleanValue());
            if (ToolMethods.isEquals((Object)StaticObjects.getDadosConfiguracaoLocal().getTerminalPreVenda(), (Object)1)) {
                this.disableOpcoesIrrelevantesPreVendas(Boolean.TRUE);
            }
        } else {
            this.panePreVenda.setDisable(Boolean.TRUE.booleanValue());
        }
        if (!ToolMethods.isEquals((Object)StaticObjects.getEmpresa().getEmpresaDados().getTipoEmpresa().getCodigo().shortValue(), (Object)6)) {
            this.paneAbastecimento.setDisable(Boolean.TRUE.booleanValue());
        }
    }

    @Override
    protected void requestFocusOnOpen() {
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent evt) {
        switch (evt.getCode()) {
            case F1: {
                if (this.terminalPreVenda()) break;
                this.vaiTelaAbreCaixa();
                break;
            }
            case F2: {
                Main.get().mudaTela(Controllers.OUTRAS_OPCOES);
                break;
            }
            case F3: {
                if (this.terminalPreVenda()) break;
                Main.get().mudaTela(Controllers.CONSISTENCIA_NFCE);
                break;
            }
            case F4: {
                if (this.terminalPreVenda()) break;
                this.vaiTelaVenda();
                break;
            }
            case F5: {
                Main.get().mudaTela(Controllers.OPCOES_SINCRONIZACAO, Controllers.MENU_PRINCIPAL);
                break;
            }
            case F6: {
                Main.get().mudaTela(Controllers.SINCRONIZAR_DADOS);
                break;
            }
            case F7: {
                if (this.terminalPreVenda()) break;
                this.vaiTelaFechamentoCaixa();
                break;
            }
            case F8: {
                if (this.terminalPreVenda()) break;
                this.vaiEntradaMovCaixa();
                break;
            }
            case F9: {
                if (this.terminalPreVenda()) break;
                this.vaiSaidaMovCaixa();
                break;
            }
            case F10: {
                this.vaiTelaPreVenda();
                break;
            }
            case F11: {
                if (this.terminalPreVenda()) break;
                this.vaiTelaAbastecimento();
                break;
            }
        }
    }

    private void vaiTelaAbreCaixa() {
        Main.get().mudaTela(Controllers.ABERTURA_CAIXA);
    }

    private void vaiTelaFechamentoCaixa() {
        if (StaticObjects.getControleCaixa() != null && StaticObjects.getControleCaixa().getStatus() == EnumConstAbertoFechado.ABERTO.value) {
            Main.get().mudaTela(Controllers.FECHAMENTO_CAIXA);
        } else if (StaticObjects.getControleCaixa() == null || StaticObjects.getControleCaixa().getStatus() == EnumConstAbertoFechado.FECHADO.value) {
            Alerts.showAlertError("Para realizar o fechamento do caixa \u00e9 preciso abri-lo");
        }
    }

    private void vaiTelaVenda() {
        if (StaticObjects.getControleCaixa() != null && StaticObjects.getControleCaixa().getStatus() == EnumConstAbertoFechado.ABERTO.value) {
            Date dataAtual;
            if (!StaticObjects.getControleCaixa().getUsuario().equals(StaticObjects.getUsuario())) {
                Alerts.showAlertInfo("Informa\u00e7\u00e3o", "O usu\u00e1rio que fez a abertura do caixa deve ser o mesmo para realizar as vendas! Usuario:  " + String.valueOf(StaticObjects.getControleCaixa().getUsuario()), "");
                return;
            }
            Date dataCaixa = ToolDate.dataSemHora((Date)StaticObjects.getControleCaixa().getDataAbertura());
            if (!dataCaixa.equals(dataAtual = ToolDate.dataSemHora((Date)new Date()))) {
                Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Data atual \u00e9 diferente da data de abertura do caixa. Verifique se necess\u00e1rio o fechamento e reabertura do mesmo.", "");
            }
            Main.get().mudaTela(Controllers.VENDA);
        } else {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Para realizar vendas \u00e9 preciso abrir seu caixa!", "");
        }
    }

    private void vaiTelaPreVenda() {
        if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getUtilizarPreVenda(), (Object)1)) {
            if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getBloqueioPreVenda(), (Object)1) && ToolMethods.isNull((Object)StaticObjects.getControleCaixa()).booleanValue()) {
                Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Para realizar vendas \u00e9 preciso abrir seu caixa!", "");
            } else {
                Main.get().mudaTela(Controllers.PRE_VENDA);
            }
        }
    }

    private void vaiEntradaMovCaixa() {
        if (StaticObjects.getControleCaixa() != null && StaticObjects.getControleCaixa().getStatus() == EnumConstAbertoFechado.ABERTO.value) {
            Main.get().mudaTela(Controllers.ENTRADA_MOV);
        } else {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Para realizar vendas \u00e9 preciso abrir seu caixa!", "");
        }
    }

    private void vaiSaidaMovCaixa() {
        if (StaticObjects.getControleCaixa() != null && StaticObjects.getControleCaixa().getStatus() == EnumConstAbertoFechado.ABERTO.value) {
            Main.get().mudaTela(Controllers.SAIDA_MOV);
        } else {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Para realizar vendas \u00e9 preciso abrir seu caixa!", "");
        }
    }

    private void vaiTelaAbastecimento() {
        if (StaticObjects.getControleCaixa() != null && StaticObjects.getControleCaixa().getStatus() == EnumConstAbertoFechado.ABERTO.value) {
            if (StaticObjects.getCentralAbastecimentoController() != null) {
                Alerts.showAlertError("J\u00e1 existe uma instancia do posto aberta!");
                return;
            }
            if (!ToolMethods.isEquals((Object)StaticObjects.getEmpresa().getEmpresaDados().getTipoEmpresa().getCodigo().shortValue(), (Object)6)) {
                Alerts.showAlertInfo("Erro", "Para Acessar este recurso a empresa dever\u00e1 ser do tipo posto de Combustivel!", "");
            } else if (StaticObjects.getOpcoes() == null) {
                Alerts.showAlertInfo("Erro", "Op\u00e7\u00f5es NFCe n\u00e3o foram definidas para esta grupoEmpresa/caixa.", "");
            } else if (StaticObjects.getOpcoes().getHostAutomacao() == null || StaticObjects.getOpcoes().getHostAutomacao().isEmpty()) {
                Alerts.showAlertInfo("Erro", "Host da automa\u00e7\u00e3o n\u00e3o informado no cadastro das op\u00e7\u00f5es NFCe.", "");
            } else if (StaticObjects.getOpcoes().getPortAutomacao() == null) {
                Alerts.showAlertInfo("Erro", "Port da automa\u00e7\u00e3o n\u00e3o informado no cadastro das op\u00e7\u00f5es NFCe.", "");
            } else if (StaticObjects.getOpcoes().getTipoAutomacaoPosto() == null) {
                Alerts.showAlertInfo("Erro", "Modelo Automa\u00e7\u00e3o Bomba Combust\u00edvel n\u00e3o informado no cadastro das op\u00e7\u00f5es NFCe.", "");
            } else {
                this.createStageTelaAbastecimentoResumida();
            }
        } else {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Para realizar vendas \u00e9 preciso abrir seu caixa!", "");
        }
    }

    private void createStageTelaAbastecimentoResumida() {
        Stage stage = new Stage();
        CentralAbastecimentoSimplificada centralAbastecimento = null;
        try {
            stage.setAlwaysOnTop(true);
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(this.getClass().getResource(Controllers.ABASTECIMENTO_SIMPLIFICADO.getViewPath()));
            Scene scene = new Scene((Parent)((AnchorPane)loader.load()));
            centralAbastecimento = (CentralAbastecimentoSimplificada)loader.getController();
            centralAbastecimento.setElements(stage);
            stage.setUserData((Object)loader);
            stage.setTitle("Central de Abastecimentos");
            stage.getIcons().add((Object)new Image(Main.class.getResource("/images/icone.png").toString()));
            stage.setScene(scene);
            if (ConfPropertiesLoader.get().getXAbastecimentoScreen() != 0.0) {
                stage.setX(ConfPropertiesLoader.get().getXAbastecimentoScreen().doubleValue());
            }
            if (ConfPropertiesLoader.get().getYAbastecimentoScreen() != 0.0) {
                stage.setY(ConfPropertiesLoader.get().getYAbastecimentoScreen().doubleValue());
            }
            if (ConfPropertiesLoader.get().getHeigthAbastecimentoScreen() != 0.0) {
                stage.setHeight(ConfPropertiesLoader.get().getHeigthAbastecimentoScreen().doubleValue());
            }
            if (ConfPropertiesLoader.get().getWidthAbastecimentoScreen() != 0.0) {
                stage.setWidth(ConfPropertiesLoader.get().getWidthAbastecimentoScreen().doubleValue());
            }
            this.paneAbastecimento.setDisable(true);
            stage.showAndWait();
            this.paneAbastecimento.setDisable(false);
        }
        catch (Exception ex) {
            Alerts.showAlertError("Erro ao abrir a tela de abastecimento \n\n" + String.valueOf(ex.getCause()));
            this.paneAbastecimento.setDisable(false);
        }
    }

    private void disableOpcoesIrrelevantesPreVendas(Boolean flag) {
        this.paneVendas.setDisable(flag.booleanValue());
        this.paneAbertCaixa.setDisable(flag.booleanValue());
        this.paneEntradaMov.setDisable(flag.booleanValue());
        this.paneSaidaMov.setDisable(flag.booleanValue());
        this.paneConsistNfce.setDisable(flag.booleanValue());
        this.paneFechamentoCaixa.setDisable(flag.booleanValue());
        this.paneAbastecimento.setDisable(flag.booleanValue());
    }

    private boolean terminalPreVenda() {
        return ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getUtilizarPreVenda(), (Object)1) && ToolMethods.isEquals((Object)StaticObjects.getDadosConfiguracaoLocal().getTerminalPreVenda(), (Object)1);
    }
}

