/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.pessoa;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.condicoespagamento.EnumConstCondPagVistaPrazo;
import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoAutenticacao;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.table.impl.PaginationTableCliente;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.auxwizardvendas.AuxGetTipoFaturamento;
import com.touchcomp.touchnfce.controller.login.LoginAutorizacaoController;
import com.touchcomp.touchnfce.controller.pessoa.autorizadasdesautorizadas.PessoasVinculadasAutDesautController;
import com.touchcomp.touchnfce.controller.venda.auxmodelofiscal.AuxModeloFiscal;
import com.touchcomp.touchnfce.exceptions.ExceptionClienteFinanceiro;
import com.touchcomp.touchnfce.model.Cliente;
import com.touchcomp.touchnfce.model.CondicoesPagamento;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.ItemPedido;
import com.touchcomp.touchnfce.model.ModeloFiscal;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeOpcoesValidMeioPagamento;
import com.touchcomp.touchnfce.model.NaturezaOperacao;
import com.touchcomp.touchnfce.model.Pedido;
import com.touchcomp.touchnfce.model.Pessoa;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.utils.UtilCliente;
import com.touchcomp.touchnfce.utils.UtilClienteCondicoesPagamento;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import com.touchcomp.touchnfce.utils.UtilShowDialogTable;
import com.touchcomp.touchnfce.utils.pedido.UtilPedido;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;

public class PesquisaPessoaController
extends BaseDialog {
    @FXML
    private Label lblPessoa;
    @FXML
    private Label lblTabela;
    @FXML
    private PaginationTableCliente tablePessoas;
    @FXML
    private Button btnVoltar;
    @FXML
    private Button btnSelecionar;
    @FXML
    private Button btnCriarPessoa;
    @FXML
    private Button btnDelPesNfce;
    @FXML
    private Button btnPessoaAutorizada;
    @FXML
    private AnchorPane body;
    private List<UnidadeFatCliente> filterElements = new LinkedList<UnidadeFatCliente>();
    private boolean lastControllerIsPreVenda = true;

    @Override
    public void initializeController(ResourceBundle rb) {
        this.lastControllerIsPreVenda = ToolMethods.isEquals((Object)StaticObjects.getUltimaPagina(), (Object)Controllers.PRE_VENDA);
        this.btnVoltar.setOnAction(event -> this.closeDialog());
        this.btnCriarPessoa.setOnAction(event -> this.cadastrarPessoa());
        this.btnSelecionar.setOnAction(event -> this.atualizaNFCeOrPedido());
        this.btnPessoaAutorizada.setOnAction(event -> this.selecionarPessoaAutorizada());
        this.btnDelPesNfce.setOnAction(event -> this.deletaPesNFCe());
        this.setClienteNFCe();
    }

    private NFCe getNFCeAberta() {
        return StaticObjects.getNfceAberta();
    }

    private Pedido getPedidoAberto() {
        return StaticObjects.getPedidoAberto();
    }

    private void setClienteNFCe() {
        LinkedList<UnidadeFatCliente> list = new LinkedList<UnidadeFatCliente>();
        if (!this.lastControllerIsPreVenda) {
            if (this.getNFCeAberta() != null && this.getNFCeAberta().getUnidadeFatCliente() != null) {
                list.add(StaticObjects.getNfceAberta().getUnidadeFatCliente());
                this.tablePessoas.getTfFilter().setText(StaticObjects.getNfceAberta().getUnidadeFatCliente().getPessoa().toString());
            }
        } else if (this.getPedidoAberto() != null && this.getPedidoAberto().getUnidadeFatCliente() != null) {
            list.add(StaticObjects.getPedidoAberto().getUnidadeFatCliente());
            this.tablePessoas.getTfFilter().setText(StaticObjects.getPedidoAberto().getUnidadeFatCliente().getPessoa().toString());
        } else if (StaticObjects.getOpcoes().getUnidadeFatCliente() != null) {
            list.add(StaticObjects.getOpcoes().getUnidadeFatCliente());
        }
        this.tablePessoas.setItemsTable(FXCollections.observableArrayList(list));
        this.tablePessoas.getTable().getSelectionModel().selectFirst();
    }

    private void deletaPesNFCe() {
        if (!this.lastControllerIsPreVenda) {
            this.removerPessoaNFCe();
        } else {
            this.removerPessoaPedido();
        }
        this.closeDialog();
    }

    private void removerPessoaPedido() {
        if (StaticObjects.getPedidoAberto() == null) {
            Alerts.showAlertError("Nenhum Pedido foi criado!", this.getStage());
            return;
        }
        if (StaticObjects.getPedidoAberto().getUnidadeFatCliente() == null) {
            return;
        }
        StaticObjects.getPedidoAberto().setUnidadeFatCliente(null);
        StaticObjects.getPedidoAberto().setPessoaAutorizada(null);
        this.tablePessoas.getTfFilter().setText("");
        this.tablePessoas.getTable().getItems().clear();
    }

    private void removerPessoaNFCe() {
        if (StaticObjects.getNfceAberta() == null) {
            Alerts.showAlertError("Nenhuma Nota foi criada!", this.getStage());
            return;
        }
        if (StaticObjects.getNfceAberta().getItens().size() > 0) {
            Alerts.showAlertError("Documento j\u00e1 possui itens, n\u00e3o sendo poss\u00edvel remover o cliente!", this.getStage());
            return;
        }
        if (StaticObjects.getNfceAberta().getUnidadeFatCliente() == null) {
            return;
        }
        StaticObjects.getNfceAberta().setUnidadeFatCliente(null);
        StaticObjects.getNfceAberta().setPessoaAutorizada(null);
        this.tablePessoas.getTfFilter().setText("");
        this.tablePessoas.getTable().getItems().clear();
    }

    @Override
    public void requestFocusOnOpen() {
        Platform.runLater(() -> this.tablePessoas.getTfFilter().requestFocus());
    }

    private void atualizaNFCeOrPedido() {
        try {
            UnidadeFatCliente u = (UnidadeFatCliente)this.tablePessoas.getTable().getSelectionModel().getSelectedItem();
            if (u == null) {
                Alerts.showAlertError("Selecione um cliente para continuar", this.getStage());
                return;
            }
            if (u.getPessoa() != null && ToolMethods.isEquals((Object)u.getPessoa().getAtivo(), (Object)0)) {
                Alerts.showAlertError("Pessoa Inativo", this.getStage());
                return;
            }
            if (u.getCliente() != null && ToolMethods.isEquals((Object)u.getCliente().getAtivo(), (Object)0)) {
                Alerts.showAlertError("Cliente Inativo", this.getStage());
                return;
            }
            this.tablePessoas.getTable().getSelectionModel().clearSelection();
            CondicoesPagamento condicao = this.getCondicaoPagamento(u);
            if (condicao == null && ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getValidarLimiteInicioVenda(), (Object)1)) {
                return;
            }
            Pessoa autorizado = this.selectPessoaAutorizada(u);
            if (autorizado == null) {
                return;
            }
            Short tipoFaturamento = this.getTipoFaturamento(u.getCliente(), StaticObjects.getEmpresa());
            if (tipoFaturamento == null) {
                return;
            }
            if (!this.lastControllerIsPreVenda) {
                this.startCreateNFCe(u, condicao, autorizado, tipoFaturamento);
            } else {
                this.startCreatePedido(u, condicao, autorizado, tipoFaturamento);
            }
            this.closeDialog();
        }
        catch (Exception ex) {
            TLogger.get((Object)ex).error((Throwable)ex);
            Alerts.showAlertInfo("Erro ao selecionar o cliente/Iniciar venda:\n" + ex.getMessage(), this.getStage());
        }
    }

    private boolean ehNecessarioAvaliarCliente(UnidadeFatCliente u, CondicoesPagamento condicao) {
        if (StaticObjects.getOpcoes().getMeiosPagamentoValid().size() > 0) {
            for (NFCeOpcoesValidMeioPagamento mp : StaticObjects.getOpcoes().getMeiosPagamentoValid()) {
                if (condicao.getMeioPagamento() == null || !ToolMethods.isEquals((Object)mp.getAtivo(), (Object)1) || !ToolMethods.isEquals((Object)mp.getTipoPagamentoNFe(), (Object)condicao.getMeioPagamento().getTipoPagamentoNFe())) continue;
                return true;
            }
        } else if (condicao.getTpCondicao().equals(EnumConstCondPagVistaPrazo.PAGAMENTO_A_PRAZO.getValue())) {
            return true;
        }
        return false;
    }

    private CondicoesPagamento getCondicaoPagamento(UnidadeFatCliente u) {
        CondicoesPagamento condicao = null;
        while ((condicao = this.getCondicaoPagamentoInicioVenda(u)) != null && this.ehNecessarioAvaliarCliente(u, condicao)) {
            EnumConstantsMentorSimNao ret;
            if (u.getCliente() != null && ToolMethods.isEquals((Object)u.getCliente().getFinanceiro().getHabilParaCompra(), (Object)0)) {
                Alerts.showAlertError("Cliente/Pessoa Inabilitado", this.getStage());
                condicao = null;
                break;
            }
            try {
                UtilCliente.analiseCreditoCliente(u.getCliente(), (Double)0.0);
            }
            catch (ExceptionClienteFinanceiro ex) {
                ret = Alerts.showQuestionYesNo("", "", "Existe ocorr\u00eancias quanto a an\u00e1lise do cliente: \n" + ex.getMessage() + "\n\nDeseja definir outra condi\u00e7\u00e3o de pagamento sem a necessidade de an\u00e1lise?", this.getStage());
                if (ret.equals((Object)EnumConstantsMentorSimNao.SIM) || !this.isAutorizadoContinuar(u, condicao, ex.getErrorCode())) continue;
            }
            catch (Exception ex) {
                ret = Alerts.showQuestionYesNo("", "", "Erro ao realizar a an\u00e1lise do cliente, devido a problemas de conex\u00e3o \n\n\nDeseja definir outra condi\u00e7\u00e3o de pagamento sem a necessidade de an\u00e1lise?", this.getStage());
                if (ret.equals((Object)EnumConstantsMentorSimNao.SIM) || !this.isAutorizadoContinuar(u, condicao, new ArrayList<Integer>())) continue;
            }
            break;
        }
        return condicao;
    }

    private boolean isAutorizadoContinuar(UnidadeFatCliente u, CondicoesPagamento condicao, List<Integer> errosLibFinanceira) {
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("tipo_autenticacao", EnumConstNFCeTipoAutenticacao.AUTENTICACAO_LIBERACAO_FINANCEIRA_CLIENTE);
        h.put("validacoes_liberacao_financeira", errosLibFinanceira);
        LoginAutorizacaoController loginController = (LoginAutorizacaoController)Main.get().showDialog(Controllers.LOGIN_AUTORIZACAO, h);
        if (loginController.getUsuario() == null) {
            Alerts.showAlertError("Voc\u00ea n\u00e3o possui autoriza\u00e7\u00e3o para realizar essa opera\u00e7\u00e3o", this.getStage());
            return false;
        }
        return true;
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt != null) {
            switch (evt.getCode()) {
                case ESCAPE: {
                    this.closeDialog();
                    break;
                }
                case F3: {
                    this.tablePessoas.requestFocus();
                    this.tablePessoas.getTable().getSelectionModel().selectFirst();
                    break;
                }
                case F2: {
                    this.tablePessoas.getTable().getSelectionModel().select(null);
                    this.tablePessoas.getTfFilter().requestFocus();
                    break;
                }
                case F5: {
                    this.selecionarPessoaAutorizada();
                    break;
                }
                case F12: {
                    this.atualizaNFCeOrPedido();
                    break;
                }
                case DELETE: {
                    this.deletaPesNFCe();
                    break;
                }
                case F7: {
                    this.tablePessoas.anterior();
                    break;
                }
                case F8: {
                    this.tablePessoas.proximo();
                    break;
                }
                case DOWN: {
                    if (!this.tablePessoas.getTfFilter().isFocused()) break;
                    this.tablePessoas.getTable().requestFocus();
                    this.tablePessoas.getTable().getSelectionModel().selectFirst();
                    break;
                }
                case ENTER: {
                    if (this.tablePessoas.getTable().getSelectionModel().getSelectedItem() != null) {
                        this.atualizaNFCeOrPedido();
                        break;
                    }
                    if (this.tablePessoas.getTfFilter().getText() != null && !this.tablePessoas.getTfFilter().getText().isEmpty() && this.tablePessoas.getTfFilter().getText().startsWith("=")) {
                        this.tablePessoas.carregaRegistros(this.tablePessoas.getTfFilter().getText());
                        break;
                    }
                    if (this.tablePessoas.getTfFilter().isFocused()) break;
                    this.closeDialog();
                    break;
                }
            }
        }
    }

    private void criarNFCe(NaturezaOperacao nat, UnidadeFatCliente u) throws Exception {
        if (this.getNFCeAberta() == null) {
            StaticObjects.setNfceAberta(UtilNFCe.getNewNFCe(nat, u));
        } else {
            if (!ToolMethods.isEquals((Object)nat, (Object)this.getNFCeAberta().getNaturezaOperacao())) {
                String str = "N\u00e3o \u00e9 permitido alterar a natureza de opera\u00e7\u00e3o de um documento em andamento. Cancele a opera\u00e7\u00e3o e comece novamente.";
                throw new Exception(str);
            }
            if (this.getNFCeAberta().getItens().isEmpty() || ToolMethods.isEquals((Object)this.getNFCeAberta().getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
                StaticObjects.getNfceAberta().setUnidadeFatCliente(u);
            } else {
                String str = "N\u00e3o \u00e9 permitido alterar um cliente quando j\u00e1 foi adicionado itens ao documento fiscal. Cancele a opera\u00e7\u00e3o e comece novamente.";
                throw new Exception(str);
            }
        }
    }

    private Short getTipoFaturamento(Cliente cliente, Empresa empresa) {
        Short tipoFaturamento = new AuxGetTipoFaturamento().getTipoFaturamento(cliente, empresa);
        StaticObjects.checaExcluiNFCeTemp();
        if (!this.lastControllerIsPreVenda && (ToolMethods.isEquals((Object)tipoFaturamento, (Object)3) ? StaticObjects.getNfceAberta() != null && ToolMethods.isEquals((Object)StaticObjects.getNfceAberta().getNfeTransferencia(), (Object)0) : StaticObjects.getNfceAberta() != null && ToolMethods.isEquals((Object)StaticObjects.getNfceAberta().getNfeTransferencia(), (Object)1))) {
            throw new RuntimeException("J\u00e1 existe uma NF-e criada e a mesma n\u00e3o pode ter seu tipo alterado, por trabalhar com pre\u00e7o de venda. Cancele a mesma para prosseguir!");
        }
        return tipoFaturamento;
    }

    private Pessoa selectPessoaAutorizada(UnidadeFatCliente u) {
        if (ToolMethods.isWithData(u.getCliente().getFichaFinanceira().getPessoasAutorizadas())) {
            return this.showDialogPessoaAutorizada(u);
        }
        return u.getCliente().getPessoa();
    }

    private Pessoa showDialogPessoaAutorizada(UnidadeFatCliente u) {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("cliente", u);
        params.put("is_order", Boolean.valueOf(this.lastControllerIsPreVenda));
        PessoasVinculadasAutDesautController vincControler = (PessoasVinculadasAutDesautController)Main.get().showDialog(Controllers.PESSOAS_VINCULADAS_AUT_DESAULT, params);
        return vincControler.getPessoaAutorizada();
    }

    private void selecionarPessoaAutorizada() {
        if (!this.lastControllerIsPreVenda) {
            if (StaticObjects.getNfceAberta() == null) {
                Alerts.showAlertInfo("Primeiro, abra uma NFCe selecionando um Cliente!", this.getStage());
                return;
            }
            if (StaticObjects.getNfceAberta().getUnidadeFatCliente() == null) {
                Alerts.showAlertInfo("Primeiro, informe um cliente para NFCe!", this.getStage());
                return;
            }
            this.showDialogPessoaAutorizada(StaticObjects.getNfceAberta().getUnidadeFatCliente());
        } else {
            if (this.getPedidoAberto() == null) {
                Alerts.showAlertInfo("Primeiro, abra um Pedido selecionando um Cliente!", this.getStage());
                return;
            }
            if (this.getPedidoAberto().getUnidadeFatCliente() == null) {
                Alerts.showAlertInfo("Primeiro, informe um cliente para o Pedido!", this.getStage());
                return;
            }
            this.showDialogPessoaAutorizada(this.getPedidoAberto().getUnidadeFatCliente());
        }
    }

    private void cadastrarPessoa() {
        if (!this.lastControllerIsPreVenda) {
            if (StaticObjects.getNfceAberta() != null && StaticObjects.getNfceAberta().getUnidadeFatCliente() != null) {
                Alerts.showAlertError("J\u00e1 existe um cliente informado para a nota fiscal que est\u00e1 aberta. Remova o mesmo antes de cadastrar um novo!", this.getStage());
                return;
            }
        } else if (this.getPedidoAberto() != null && this.getPedidoAberto().getUnidadeFatCliente() != null) {
            Alerts.showAlertError("J\u00e1 existe um cliente informado para o Pedido que est\u00e1 aberto. Remova o mesmo antes de cadastrar um novo!", this.getStage());
            return;
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                PesquisaPessoaController.this.closeDialog();
            }
        });
        Main.get().showDialog(Controllers.CADASTRO_PESSOAS);
    }

    private void criaPedido(UnidadeFatCliente u, NaturezaOperacao nat) throws Exception {
        if (StaticObjects.getPedidoAberto() == null) {
            StaticObjects.setPedidoAberto(UtilPedido.getNewPedido(u, nat));
            Main.get().getFooterController().atualizaStatusPedido();
        } else {
            if (!ToolMethods.isEquals((Object)nat, (Object)StaticObjects.getPedidoAberto().getNaturezaOperacao())) {
                String str = "N\u00e3o \u00e9 permitido alterar a natureza de opera\u00e7\u00e3o de uma venda. Cancele a opera\u00e7\u00e3o e comece novamente.";
                throw new Exception(str);
            }
            if (StaticObjects.getPedidoAberto().getItemPedido().isEmpty()) {
                StaticObjects.getPedidoAberto().setUnidadeFatCliente(u);
            } else if (!StaticObjects.getPedidoAberto().getItemPedido().isEmpty() && ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getAlterarClientePreVenda(), (Object)1)) {
                UnidadeFatCliente unidadeOld = StaticObjects.getPedidoAberto().getUnidadeFatCliente();
                if (!ToolMethods.isEquals((Object)unidadeOld, (Object)u)) {
                    this.regerarItensPedido(u);
                    StaticObjects.getPedidoAberto().setUnidadeFatCliente(u);
                }
            } else {
                String str = "N\u00e3o \u00e9 permitido alterar um cliente quando j\u00e1 foi adicionado itens a venda. Cancele a opera\u00e7\u00e3o e comece novamente.";
                throw new Exception(str);
            }
        }
    }

    private CondicoesPagamento getCondicaoPagamentoInicioVenda(UnidadeFatCliente u) {
        if (!ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getValidarLimiteInicioVenda(), (Object)1)) {
            return null;
        }
        List<CondicoesPagamento> condicoes = UtilClienteCondicoesPagamento.getCondicaoPagamento(u);
        if (!condicoes.isEmpty()) {
            return UtilShowDialogTable.getCondicaoPagamento(condicoes);
        }
        return null;
    }

    private void startCreateNFCe(UnidadeFatCliente u, CondicoesPagamento condicao, Pessoa autorizado, Short tipoFaturamento) throws Exception {
        NaturezaOperacao nat = UtilShowDialogTable.getNaturezaOperacao(tipoFaturamento);
        if (nat == null) {
            throw new RuntimeException("Nenhuma Natureza de Opera\u00e7\u00e3o foi encontrada!");
        }
        this.criarNFCe(nat, u);
        StaticObjects.getNfceAberta().setCondicoesPagamento(condicao);
        StaticObjects.getNfceAberta().setPessoaAutorizada(autorizado);
        if (ToolMethods.isEquals((Object)tipoFaturamento, (Object)3)) {
            StaticObjects.getNfceAberta().setNfeTransferencia((short)1);
        }
        Platform.runLater(() -> StaticObjects.refreshNFCe());
    }

    private void startCreatePedido(UnidadeFatCliente u, CondicoesPagamento condicao, Pessoa autorizado, Short tipoFaturamento) throws Exception {
        NaturezaOperacao nat = UtilShowDialogTable.getNaturezaOperacao(tipoFaturamento);
        this.criaPedido(u, nat);
        if (StaticObjects.getPedidoAberto().getSituacaoPedidos() == null) {
            StaticObjects.getPedidoAberto().setSituacaoPedidos(UtilShowDialogTable.getSituacaoPedido());
        }
        StaticObjects.getPedidoAberto().setUnidadeFatCliente(u);
        StaticObjects.getPedidoAberto().setCondicoesPagamento(condicao);
        if (condicao != null) {
            StaticObjects.getPedidoAberto().setMeioPagamento(condicao.getMeioPagamento());
        }
        StaticObjects.getPedidoAberto().setPessoaAutorizada(autorizado);
        StaticObjects.refreshPedido();
    }

    private void regerarItensPedido(UnidadeFatCliente u) throws Exception {
        Pedido pedido = StaticObjects.getPedidoAberto();
        for (ItemPedido it : pedido.getItemPedido()) {
            ModeloFiscal modeloFiscalOld = it.getModeloFiscal();
            ModeloFiscal modeloFiscal = new AuxModeloFiscal().getModeloFiscalPedido(it.getProduto(), u, pedido.getEnderecoEntrega(), pedido.getNaturezaOperacao(), pedido.getEmpresa(), true);
            if (modeloFiscal == null) {
                throw new Exception("Nenhum modelo fiscal encontrado ap\u00f3s recalcular os itens do pedido devido a altera\u00e7\u00e3o de cliente. \nProduto: " + it.getProduto().getIdentificador() + "-" + it.getProduto().getNome());
            }
            if (ToolMethods.isEquals((Object)modeloFiscalOld, (Object)modeloFiscal)) continue;
            it.setModeloFiscal(modeloFiscal);
        }
    }
}

