/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.splash.impl;

import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.ToastText;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.splash.SplashMain;
import com.touchcomp.touchnfce.model.ControleEntregaNotaPropria;
import com.touchcomp.touchnfce.service.impl.ServiceControleEntregaNotaPropria;
import com.touchcomp.touchnfce.sinc.send.SincEnvFactory;
import javafx.concurrent.WorkerStateEvent;
import javafx.fxml.Initializable;

public class SplashEnvioControleEntrega
extends SplashMain<ControleEntregaNotaPropria>
implements Initializable {
    private ControleEntregaNotaPropria controleEntregaNotaPropria;
    ServiceControleEntregaNotaPropria serviceControleEntrega = Main.getBean(ServiceControleEntregaNotaPropria.class);

    public SplashEnvioControleEntrega(ControleEntregaNotaPropria controleEntregaNotaPropria) {
        this.setControleEntregaNotaPropria(controleEntregaNotaPropria);
    }

    @Override
    protected void successTask() {
        ToastText.makeText(Main.get().getPrimaryStage(), "Conrole de Entrega sincronizado com Sucesso", 2000, 100, 100);
        StaticObjects.clearPedido();
        this.setControleEntregaNotaPropria(null);
        Main.get().mudaTela(Controllers.PRE_VENDA);
    }

    @Override
    protected void errorTask(WorkerStateEvent workerStateEvent) {
        Alerts.showAlertError("Erro ao Sincronizar o Controle de Entrega:\n\n" + workerStateEvent.getSource().getException().getMessage());
    }

    @Override
    protected ControleEntregaNotaPropria call() throws Exception {
        try {
            this.serviceControleEntrega.save(this.getControleEntregaNotaPropria());
            this.sincronizaControleEntrega();
            return null;
        }
        catch (Exception ex) {
            TLogger.get(((Object)((Object)this)).getClass()).error((Throwable)ex);
            throw ex;
        }
    }

    private void sincronizaControleEntrega() throws ExceptionIO, ExceptionReflection, ExceptionWebService, ExceptionDecodeHexString64, InterruptedException, Exception {
        SincEnvFactory.getInstance().startSincControleEntrega(this.controleEntregaNotaPropria);
        Thread.sleep(1000L);
    }

    public ControleEntregaNotaPropria getControleEntregaNotaPropria() {
        return this.controleEntregaNotaPropria;
    }

    public void setControleEntregaNotaPropria(ControleEntregaNotaPropria controleEntregaNotaPropria) {
        this.controleEntregaNotaPropria = controleEntregaNotaPropria;
    }
}

