/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.splash.impl;

import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.login.LoginController;
import com.touchcomp.touchnfce.properties.PropertiesLoader;
import com.touchcomp.touchnfce.utils.Style;
import com.touchcomp.touchnfce.utils.UtilImageSvg;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Preloader;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.apache.batik.transcoder.TranscoderException;

public class SplashIniciaSistema
extends Preloader {
    ProgressBar bar;
    Stage stage;
    boolean noLoadingProgress = true;

    private Scene createPreloaderScene() {
        ImageView logo = new ImageView();
        try {
            UtilImageSvg.generateImageFromSvg("logo_splash");
            Image imageTouch = new Image(((Object)((Object)this)).getClass().getResourceAsStream("/images/logo_splash.png"));
            logo.setImage(imageTouch);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(LoginController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
        catch (IOException | TranscoderException ex) {
            Logger.getLogger(LoginController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
        this.bar = new ProgressBar(0.0);
        BorderPane p = new BorderPane();
        this.bar.setPrefWidth(900.0);
        this.bar.setPrefHeight(25.0);
        p.setBottom((Node)this.bar);
        p.setRight(null);
        p.setLeft(null);
        p.setTop(null);
        p.setCenter((Node)logo);
        p.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        PropertiesLoader props = PropertiesLoader.get();
        Style style = new Style();
        p.setStyle(style.getCorBody(props.getCorBackground_1(), props.getCorBackground_2(), props.getCorBackground_3(), props.getCorBackground_4(), props.getCorBackground_5()));
        return new Scene((Parent)p, 900.0, 350.0);
    }

    public void start(Stage stage) throws Exception {
        this.stage = stage;
        stage.setScene(this.createPreloaderScene());
        stage.initStyle(StageStyle.UNDECORATED);
        stage.setIconified(true);
        stage.getIcons().add((Object)new Image(Main.class.getResourceAsStream("/images/icone.png")));
        stage.show();
    }

    public void handleProgressNotification(Preloader.ProgressNotification pn) {
        if (pn.getProgress() != 1.0 || !this.noLoadingProgress) {
            this.bar.setProgress(pn.getProgress() / 2.0);
            if (pn.getProgress() > 0.0) {
                this.noLoadingProgress = false;
            }
        }
    }

    public void handleStateChangeNotification(Preloader.StateChangeNotification evt) {
    }

    public void handleApplicationNotification(Preloader.PreloaderNotification pn) {
        if (pn instanceof Preloader.ProgressNotification) {
            double v = ((Preloader.ProgressNotification)pn).getProgress();
            if (!this.noLoadingProgress) {
                v = 0.5 + v / 2.0;
            }
            this.bar.setProgress(v);
        } else if (pn instanceof Preloader.StateChangeNotification) {
            this.stage.hide();
        }
    }
}

