/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.splash.impl;

import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.splash.SplashMain;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCePagamento;
import com.touchcomp.touchnfce.modeltemp.ControllerPath;
import com.touchcomp.touchnfce.properties.ConfPropertiesLoader;
import com.touchcomp.touchnfce.utils.UtilSincronizacao;
import com.touchcomp.touchnfce.utils.sitef.UtilSitef;
import com.touchcomp.touchnfce.utils.sitef.UtilSitefPagamento;
import java.util.Objects;
import javafx.application.Platform;
import javafx.concurrent.WorkerStateEvent;
import javafx.fxml.Initializable;

public class SplashLogin
extends SplashMain<Boolean>
implements Initializable {
    public SplashLogin() {
        Platform.runLater(() -> this.updateStatus("Iniciando o sistema!"));
    }

    @Override
    protected void successTask() {
        this.abrirTela();
    }

    @Override
    protected void errorTask(WorkerStateEvent workerStateEvent) {
        Alerts.showAlertError("Erro ao iniciar o sistema: \n\n" + workerStateEvent.getSource().getException().getMessage());
    }

    @Override
    protected Boolean call() throws Exception {
        return true;
    }

    private void abrirTela() {
        new UtilSincronizacao().initSincs();
        UtilSitef.configurarSiTef();
        this.verificarTransacoesTEFPendentes();
        if (Objects.equals(StaticObjects.getOpcoes().getPossuiBalanca(), (short)1)) {
            StaticObjects.createPesoBalancaLib();
        }
        boolean full = ConfPropertiesLoader.get().getIsFullScreen();
        ControllerPath controllers = Controllers.MENU_PRINCIPAL;
        Main.get().mudaTelaUndecorated(controllers);
        if (full) {
            Main.get().getPrimaryStage().setMaximized(true);
            Main.get().getPrimaryStage().setFullScreen(full);
        } else {
            Main.get().getPrimaryStage().setResizable(true);
            Main.get().maximized();
            if (StaticObjects.getOpcoes().getEmpresa().getEmpresaDados().getTipoEmpresa().getCodigo() == 6) {
                Main.get().getPrimaryStage().setX(ConfPropertiesLoader.get().getXMenuScreen().doubleValue());
                Main.get().getPrimaryStage().setY(ConfPropertiesLoader.get().getYMenuScreen().doubleValue());
                Main.get().getPrimaryStage().setHeight(ConfPropertiesLoader.get().getHeigthMenuScreen().doubleValue());
                Main.get().getPrimaryStage().setWidth(ConfPropertiesLoader.get().getWidthMenuScreen().doubleValue());
            }
        }
    }

    private void verificarTransacoesTEFPendentes() {
        NFCe nfce = StaticObjects.getNfceAberta();
        Boolean achou = false;
        if (nfce != null) {
            for (NFCePagamento pag : nfce.getPagamentos()) {
                if (!pag.getStatus().equals((short)1) || pag.getNfcePagamentoCDC() == null || !pag.getNfcePagamentoCDC().getStatus().equals((short)0)) continue;
                achou = true;
                int retorno = new UtilSitefPagamento().finalizarTransacaoSiTef(0, pag.getSerialForSinc(), nfce.getDataEmissao(), nfce.getDataEmissao());
                if (retorno != 0) continue;
                pag.getNfcePagamentoCDC().setStatus((short)2);
                pag.setStatus((short)0);
            }
        }
        if (achou.booleanValue()) {
            StaticObjects.refreshNFCe();
        }
    }
}

