/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.titulo;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoPagNFe;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchDoubleField;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.dialogs.DialogDateField;
import com.touchcomp.touchnfce.model.ItemParamCreditoLoja;
import com.touchcomp.touchnfce.model.NFCePagamento;
import com.touchcomp.touchnfce.model.NFCeTitulo;
import com.touchcomp.touchnfce.service.impl.ServiceParamCreditoLoja;
import com.touchcomp.touchnfce.utils.MaskField;
import com.touchcomp.touchnfce.utils.UtilNFCeSerial;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.stage.WindowEvent;
import javafx.util.Callback;

public class TituloController
extends BaseDialog {
    public static final String VLR_TOT_TITULOS = "vlrTitulos";
    public static final String NMR_PARCELAS = "nmrParcelas";
    public static final String NFCE_PAGAMENTO = "nfcePagamento";
    public static final String NR_DIAS_VENCIMENTO = "nrDiasVencimento";
    @FXML
    private Label lblNmrParcelas;
    @FXML
    private Label lblData;
    @FXML
    private Label lblVlrParcela;
    @FXML
    private Label lblVlrTotal;
    @FXML
    private Label lblTabelaParc;
    @FXML
    private Label lblAtaVlrParcela;
    @FXML
    private AnchorPane body;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnCancelar;
    @FXML
    private Button btnRecalcVencimentos;
    @FXML
    private Button btnCupomDesconto;
    @FXML
    private TouchTextField tfData;
    @FXML
    private TouchTextField tfNmrParcela;
    @FXML
    private TouchDoubleField tfVlrParcela;
    @FXML
    private TouchDoubleField tfVlrTotal;
    @FXML
    private TableView<NFCeTitulo> tableTitulos;
    @FXML
    private TableColumn<NFCeTitulo, String> columnDataVenc;
    @FXML
    private TableColumn<NFCeTitulo, String> columnValor;
    @FXML
    private GridPane gridTitulos;
    @FXML
    private GridPane gridCarteiraCobranca;
    private Double vlrTotal = 0.0;
    private Short nmrParcelas = 2;
    private Integer nrDiasVencimento = 30;
    private NFCePagamento nfcePagamento;
    private List<NFCeTitulo> titulos = new LinkedList<NFCeTitulo>();
    int aux = 0;

    @Override
    public void initializeController(ResourceBundle rb) {
        this.tableTitulos.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.tableTitulos.setEditable(true);
        this.tableTitulos.setOnKeyReleased(evt -> {
            if (evt.getCode() != null) {
                switch (evt.getCode()) {
                    case ENTER: {
                        this.tfVlrParcela.requestFocus();
                        this.setDadosTextFields();
                        break;
                    }
                    case UP: {
                        this.setDadosTextFields();
                        break;
                    }
                    case F7: {
                        this.recalcularDatasConformeFirstParcela();
                        break;
                    }
                    case DOWN: {
                        this.setDadosTextFields();
                        break;
                    }
                }
            }
        });
        this.btnConfirmar.setOnKeyPressed(evt -> {
            if (evt.getCode() != null) {
                switch (evt.getCode()) {
                    case ENTER: {
                        this.confirma();
                        break;
                    }
                }
            }
        });
        this.btnConfirmar.setOnAction(evt -> this.confirma());
        this.btnRecalcVencimentos.setOnAction(evt -> this.recalcularDatasConformeFirstParcela());
        this.btnCupomDesconto.setOnAction(evt -> this.abrirCuponsDesconto());
        this.btnCancelar.setOnAction(evt -> {
            if (this.isValidTitulosSalvos()) {
                this.closeDialog();
            } else {
                Optional<ButtonType> resp = Alerts.showQuestion("Alguns titulos n\u00e3o foram salvos, se sair do recurso os mesmos seram removidos. Deseja continuar?");
                if (resp.isPresent() && resp.get() == ButtonType.OK) {
                    this.removeTitulosNaoSalvos();
                    this.closeDialog();
                }
            }
        });
        this.configureTable();
        this.setPropertiesTextFields();
    }

    private void abrirCuponsDesconto() {
        HashMap<String, NFCePagamento> h = new HashMap<String, NFCePagamento>();
        h.put("nfce_pagamento", this.nfcePagamento);
        Main.get().showDialog(Controllers.CUPOM_DESCONTO, h);
    }

    private void recalcularDatasConformeFirstParcela() {
        if (!ToolMethods.isWithData((Collection)this.tableTitulos.getItems())) {
            Alerts.showAlertError("A tabela n\u00e3o possui nenhum titulo!");
            return;
        }
        HashMap<String, String> h = new HashMap<String, String>();
        h.put("label", "Informe a Data do primeiro vencimento");
        h.put("formatDate", "dd/MM/yyyy");
        DialogDateField d = (DialogDateField)Main.get().showDialog(Controllers.DIALOG_DATE_FIELD, h);
        if (d.getDataInformada() == null) {
            return;
        }
        this.tfData.setText(ToolDate.dateToStr((Date)d.getDataInformada(), (String)"dd/MM/yyyy"));
        Date firstVencimento = d.getDataInformada();
        int i = 0;
        for (NFCeTitulo t : this.tableTitulos.getItems()) {
            if (ToolMethods.isEquals((Object)i, (Object)0)) {
                t.setDataVencimento(firstVencimento);
            } else {
                t.setDataVencimento(ToolDate.addMonthToDate((Date)firstVencimento, (Integer)i));
            }
            ++i;
        }
        this.tableTitulos.refresh();
    }

    private void setPropertiesTextFields() {
        this.tfVlrParcela.setOnKeyReleased(evt -> {
            if (evt.getCode() != null) {
                if (evt.getCode() == KeyCode.ENTER && this.tableTitulos.getSelectionModel().getSelectedItem() != null) {
                    this.titulos.get(this.tableTitulos.getSelectionModel().getSelectedIndex()).setValor(this.tfVlrParcela.getDouble());
                    this.titulos.get(this.tableTitulos.getSelectionModel().getSelectedIndex()).setDataVencimento(ToolDate.strToDate((String)this.tfData.getText()));
                    this.setTitulosTable();
                    this.tableTitulos.refresh();
                    this.requestFocusTable();
                } else if (evt.getCode() == KeyCode.F4) {
                    this.tfData.requestFocus();
                    this.setDadosTextFields();
                } else if (evt.getCode() == KeyCode.F2) {
                    this.tableTitulos.requestFocus();
                }
            }
        });
        this.tfData.setOnKeyReleased(evt -> {
            if (evt.getCode() != null) {
                if (evt.getCode() == KeyCode.ENTER && this.tableTitulos.getSelectionModel().getSelectedItem() != null) {
                    this.titulos.get(this.tableTitulos.getSelectionModel().getSelectedIndex()).setValor(this.tfVlrParcela.getDouble());
                    this.titulos.get(this.tableTitulos.getSelectionModel().getSelectedIndex()).setDataVencimento(ToolDate.strToDate((String)this.tfData.getText()));
                    this.setTitulosTable();
                    this.tableTitulos.refresh();
                    this.requestFocusTable();
                } else if (evt.getCode() == KeyCode.F3) {
                    this.tfData.requestFocus();
                    this.setDadosTextFields();
                } else if (evt.getCode() == KeyCode.F2) {
                    this.tableTitulos.requestFocus();
                }
            }
        });
        this.tfData.setLabel(this.lblData);
        this.tfNmrParcela.setLabel(this.lblNmrParcelas);
        this.tfVlrParcela.setLabel(this.lblVlrParcela);
        this.tfVlrTotal.setLabel(this.lblVlrTotal);
    }

    private void setTitulosTable() {
        this.columnDataVenc.setCellValueFactory(cellData -> new SimpleStringProperty(ToolDate.dateToStr((Date)((NFCeTitulo)cellData.getValue()).getDataVencimento(), (String)"dd/MM/yyyy")));
        this.columnValor.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCeTitulo, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCeTitulo, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((NFCeTitulo)param.getValue()).getValor()));
            }
        });
        if (!ToolMethods.isWithData(this.titulos)) {
            return;
        }
        Collections.sort(this.titulos, new Comparator(this){

            public int compare(Object o1, Object o2) {
                Short p1 = ((NFCeTitulo)o1).getNumeroParcela() == null ? (short)0 : ((NFCeTitulo)o1).getNumeroParcela();
                Short p2 = ((NFCeTitulo)o2).getNumeroParcela() == null ? (short)0 : ((NFCeTitulo)o2).getNumeroParcela();
                return p1.compareTo(p2);
            }
        });
        this.tableTitulos.setItems(FXCollections.observableArrayList(this.titulos));
        if (ToolMethods.isWithData((Collection)this.tableTitulos.getItems())) {
            this.tableTitulos.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        }
    }

    @Override
    public void requestFocusOnOpen() {
        this.requestFocusTable();
    }

    @Override
    public void posInitialize() {
        this.vlrTotal = (Double)this.getParams().get(VLR_TOT_TITULOS);
        this.nmrParcelas = (Short)this.getParams().get(NMR_PARCELAS);
        this.nfcePagamento = (NFCePagamento)this.getParams().get(NFCE_PAGAMENTO);
        this.nrDiasVencimento = (Integer)this.getParams().get(NR_DIAS_VENCIMENTO);
        this.iniciaCampos();
    }

    private void configureTable() {
        this.columnValor.setMinWidth(100.0);
        this.columnValor.setStyle("-fx-alignment: BOTTOM_RIGHT;");
    }

    private void iniciaCampos() {
        this.initFields();
        this.createTitulos();
        this.setTitulosTable();
        this.setEventoFecharDialog();
    }

    private void setEventoFecharDialog() {
        this.getStage().setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent t) {
                if (TituloController.this.isValidTitulosSalvos()) {
                    TituloController.this.closeDialog();
                } else {
                    Optional<ButtonType> resp = Alerts.showQuestion("Alguns titulos n\u00e3o foram salvos, se sair do recurso os mesmos seram removidos. Deseja continuar?");
                    if (resp.isPresent() && resp.get() == ButtonType.OK) {
                        TituloController.this.removeTitulosNaoSalvos();
                        TituloController.this.closeDialog();
                    }
                }
            }
        });
    }

    private void initFields() {
        this.tableTitulos.requestFocus();
        this.tfData.setText(ToolDate.dateToStr((Date)new Date(), (String)"dd/MM/yyyy"));
        this.tfData.setEditable(false);
        MaskField.dateField(this.tfData);
        this.tfVlrParcela.setEditable(false);
        this.tfVlrTotal.setEditable(false);
        this.tfVlrTotal.setDouble(this.vlrTotal);
        this.tfNmrParcela.setText(this.nmrParcelas.toString());
        this.tfNmrParcela.setEditable(false);
    }

    private void createTitulos() {
        Double vlrParcela = ToolFormatter.arrredondarNumero((Double)(this.vlrTotal / (double)this.nmrParcelas.shortValue()), (int)2);
        this.tfVlrParcela.setDouble(vlrParcela);
        short nrParcelasAux = this.nmrParcelas;
        Double totalAux = 0.0;
        Date dataVencimento = new Date();
        for (int i = 1; i <= this.nmrParcelas; ++i) {
            if (nrParcelasAux == i) {
                vlrParcela = ToolFormatter.arrredondarNumero((Double)(this.vlrTotal - totalAux), (int)2);
            } else {
                totalAux = totalAux + vlrParcela;
            }
            NFCeTitulo titulo = new NFCeTitulo();
            titulo.setDataCadastro(new Date());
            if (i == 1) {
                dataVencimento = ToolDate.nextDays((Date)dataVencimento, (int)this.nrDiasVencimento);
                titulo.setDataVencimento(dataVencimento);
            } else {
                titulo.setDataVencimento(ToolDate.nextMonth((Date)dataVencimento, (int)(i - 1)));
            }
            titulo.setNumeroParcela((short)i);
            titulo.setValor(vlrParcela);
            titulo.setSerialForSinc(UtilNFCeSerial.getSerial(titulo));
            this.titulos.add(titulo);
        }
        this.setDataVencimentoParamCreditoLoja();
    }

    private void setDataVencimentoParamCreditoLoja() {
        if (!this.isPagamentoCreditoLoja()) {
            return;
        }
        ServiceParamCreditoLoja service = Main.getBean(ServiceParamCreditoLoja.class);
        ItemParamCreditoLoja itemParamCredLoja = service.getItemParametrizacaoCreditoLoja(StaticObjects.getNfceAberta().getUnidadeFatCliente().getCliente().getClassificacaoClientes(), StaticObjects.getNfceAberta().getEmpresa(), StaticObjects.getNfceAberta().getDataEmissao());
        if (ToolMethods.isEquals((Object)itemParamCredLoja, null)) {
            return;
        }
        int i = 0;
        Date dateVencParametrizacao = itemParamCredLoja.getDataVencimento();
        for (NFCeTitulo t : this.titulos) {
            if (i == 0) {
                t.setDataVencimento(dateVencParametrizacao);
            } else {
                t.setDataVencimento(ToolDate.addMonthToDate((Date)dateVencParametrizacao, (Integer)i));
            }
            ++i;
        }
    }

    private boolean isPagamentoCreditoLoja() {
        return !ToolMethods.isEquals((Object)this.nfcePagamento, null) && ToolMethods.isEquals((Object)this.nfcePagamento.getTipoPagamentoNFe().getCodigo(), (Object)EnumConstNFeTipoPagNFe.CREDITO_LOJA.getCodigo());
    }

    private boolean isValidTitulosSalvos() {
        ObservableList listTitulos = this.tableTitulos.getItems();
        if (listTitulos == null || listTitulos.isEmpty()) {
            return true;
        }
        for (NFCeTitulo c : listTitulos) {
            if (c.getIdentificador() != null && c.getIdentificador() != 0L) continue;
            return false;
        }
        return true;
    }

    private void removeTitulosNaoSalvos() {
        ObservableList listTitulos = this.tableTitulos.getItems();
        ArrayList<NFCeTitulo> titulosNaoSalvos = new ArrayList<NFCeTitulo>();
        for (NFCeTitulo c : listTitulos) {
            if (c.getIdentificador() != null && c.getIdentificador() != 0L) continue;
            titulosNaoSalvos.add(c);
        }
        if (!titulosNaoSalvos.isEmpty()) {
            this.titulos.removeAll(titulosNaoSalvos);
            this.tableTitulos.getItems().removeAll(titulosNaoSalvos);
            this.tableTitulos.refresh();
        }
    }

    private void setDadosTextFields() {
        NFCeTitulo tit = (NFCeTitulo)this.tableTitulos.getSelectionModel().getSelectedItem();
        if (tit != null) {
            this.tfData.setText(ToolDate.dateToStr((Date)tit.getDataVencimento(), (String)"dd/MM/yyyy"));
            this.tfNmrParcela.setText(String.valueOf(tit.getNumeroParcela()));
            this.tfVlrParcela.setDouble(tit.getValor());
            if (this.tfVlrParcela.isFocused()) {
                this.tfVlrParcela.setEditable(true);
                this.tfVlrParcela.selectAll();
            } else if (this.tfData.isFocused()) {
                this.tfData.selectAll();
                this.tfData.setEditable(true);
            }
        }
    }

    private void requestFocusTable() {
        this.tableTitulos.requestFocus();
        this.tableTitulos.getSelectionModel().selectFirst();
    }

    private void confirma() {
        Double tot = 0.0;
        for (NFCeTitulo titulo : this.titulos) {
            tot = tot + titulo.getValor();
            if (!titulo.getDataVencimento().before(ToolDate.dataSemHora((Date)new Date()))) continue;
            Alerts.showAlertError("Data de vencimento deve ser maior ou igual a data atual.");
            return;
        }
        if (!ToolFormatter.arrredondarNumero((Double)tot, (int)2).equals(ToolFormatter.arrredondarNumero((Double)this.vlrTotal, (int)2))) {
            Alerts.showAlertError("Valor somado das parcelas deve ser igual ao valor total");
            return;
        }
        this.closeDialog();
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt != null) {
            switch (evt.getCode()) {
                case F12: {
                    this.confirma();
                    break;
                }
                case F3: {
                    this.tfVlrParcela.requestFocus();
                    this.setDadosTextFields();
                    break;
                }
                case F4: {
                    this.tfData.requestFocus();
                    this.setDadosTextFields();
                    break;
                }
                case F8: {
                    this.abrirCuponsDesconto();
                    break;
                }
                case ESCAPE: {
                    this.closeDialog();
                }
            }
        }
    }

    public List<NFCeTitulo> getTitulos() {
        return this.titulos;
    }

    @Override
    public void eventAltControl(KeyEvent event) {
    }
}

