/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.titulo.pedido;

import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.components.TouchDoubleField;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.model.PedidoTitulo;
import com.touchcomp.touchnfce.utils.MaskField;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.WindowEvent;
import javafx.util.Callback;

public class TituloPedido
extends BaseDialog {
    public static final String VLR_TOT_TITULOS = "vlrTitulos";
    public static final String NMR_PARCELAS = "nmrParcelas";
    @FXML
    private Label lblNmrParcelas;
    @FXML
    private Label lblData;
    @FXML
    private Label lblVlrParcela;
    @FXML
    private Label lblVlrTotal;
    @FXML
    private Label lblTabelaParc;
    @FXML
    private Label lblAtaVlrParcela;
    @FXML
    private AnchorPane body;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnCancelar;
    @FXML
    private TouchTextField tfData;
    @FXML
    private TouchTextField tfNmrParcela;
    @FXML
    private TouchDoubleField tfVlrParcela;
    @FXML
    private TouchDoubleField tfVlrTotal;
    @FXML
    private TableView<PedidoTitulo> tableTitulos;
    @FXML
    private TableColumn<PedidoTitulo, String> columnDataVenc;
    @FXML
    private TableColumn<PedidoTitulo, Double> columnValor;
    private Double vlrTotal = 0.0;
    private short nmrParcelas = (short)2;
    private List<PedidoTitulo> titulos = new LinkedList<PedidoTitulo>();
    int aux = 0;

    @Override
    public void initializeController(ResourceBundle rb) {
        this.tableTitulos.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.tableTitulos.setEditable(true);
        this.tableTitulos.setOnKeyReleased(evt -> {
            if (evt.getCode() != null) {
                switch (evt.getCode()) {
                    case ENTER: {
                        this.tfVlrParcela.requestFocus();
                        this.setDadosTextFields();
                        break;
                    }
                    case UP: {
                        this.setDadosTextFields();
                        break;
                    }
                    case DOWN: {
                        this.setDadosTextFields();
                        break;
                    }
                }
            }
        });
        this.btnConfirmar.setOnAction(evt -> this.confirma());
        this.btnCancelar.setOnAction(evt -> {
            if (this.isValidTitulosSalvos()) {
                this.closeDialog();
            } else {
                Optional<ButtonType> resp = Alerts.showQuestion("Alguns titulos n\u00e3o foram salvos, se sair do recurso os mesmos seram removidos. Deseja continuar?");
                if (resp.isPresent() && resp.get() == ButtonType.OK) {
                    this.removeTitulosNaoSalvos();
                    this.closeDialog();
                }
            }
        });
        this.configureTable();
        this.setPropertiesTextFields();
    }

    private void setPropertiesTextFields() {
        this.tfVlrParcela.setOnKeyReleased(evt -> {
            if (evt.getCode() != null) {
                if (evt.getCode() == KeyCode.ENTER && this.tableTitulos.getSelectionModel().getSelectedItem() != null) {
                    this.titulos.get(this.tableTitulos.getSelectionModel().getSelectedIndex()).setValor(this.tfVlrParcela.getDouble());
                    this.titulos.get(this.tableTitulos.getSelectionModel().getSelectedIndex()).setDataVencimento(ToolDate.strToDate((String)this.tfData.getText()));
                    this.setTitulosTable();
                    this.tableTitulos.refresh();
                    this.requestFocusTable();
                } else if (evt.getCode() == KeyCode.F4) {
                    this.tfData.requestFocus();
                    this.setDadosTextFields();
                } else if (evt.getCode() == KeyCode.F2) {
                    this.tableTitulos.requestFocus();
                }
            }
        });
        this.tfData.setOnKeyReleased(evt -> {
            if (evt.getCode() != null) {
                if (evt.getCode() == KeyCode.ENTER && this.tableTitulos.getSelectionModel().getSelectedItem() != null) {
                    this.titulos.get(this.tableTitulos.getSelectionModel().getSelectedIndex()).setValor(this.tfVlrParcela.getDouble());
                    this.titulos.get(this.tableTitulos.getSelectionModel().getSelectedIndex()).setDataVencimento(ToolDate.strToDate((String)this.tfData.getText()));
                    this.setTitulosTable();
                    this.tableTitulos.refresh();
                    this.requestFocusTable();
                } else if (evt.getCode() == KeyCode.F3) {
                    this.tfData.requestFocus();
                    this.setDadosTextFields();
                } else if (evt.getCode() == KeyCode.F2) {
                    this.tableTitulos.requestFocus();
                }
            }
        });
        this.tfData.setLabel(this.lblData);
        this.tfNmrParcela.setLabel(this.lblNmrParcelas);
        this.tfVlrParcela.setLabel(this.lblVlrParcela);
        this.tfVlrTotal.setLabel(this.lblVlrTotal);
    }

    private void setTitulosTable() {
        this.columnDataVenc.setCellValueFactory(cellData -> new SimpleStringProperty(ToolDate.dateToStr((Date)((PedidoTitulo)cellData.getValue()).getDataVencimento(), (String)"dd/MM/yyyy")));
        this.columnValor.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<PedidoTitulo, Double>, ObservableValue<Double>>(this){

            public ObservableValue<Double> call(TableColumn.CellDataFeatures<PedidoTitulo, Double> param) {
                return new SimpleObjectProperty((Object)((PedidoTitulo)param.getValue()).getValor());
            }
        });
        this.tableTitulos.setItems(FXCollections.observableArrayList(this.titulos));
    }

    @Override
    public void requestFocusOnOpen() {
        this.requestFocusTable();
    }

    @Override
    public void posInitialize() {
        this.vlrTotal = (Double)this.getParams().get(VLR_TOT_TITULOS);
        this.nmrParcelas = (Short)this.getParams().get(NMR_PARCELAS);
        this.iniciaCampos();
    }

    private void configureTable() {
        this.columnValor.setMinWidth(100.0);
        this.columnValor.setStyle("-fx-alignment: BOTTOM_RIGHT;");
    }

    private void iniciaCampos() {
        if (this.nmrParcelas == 0) {
            this.nmrParcelas = 1;
        }
        this.tableTitulos.requestFocus();
        this.tfData.setText(ToolDate.dateToStr((Date)new Date(), (String)"dd/MM/yyyy"));
        this.tfData.setEditable(false);
        MaskField.dateField(this.tfData);
        this.tfVlrParcela.setEditable(false);
        this.tfVlrTotal.setEditable(false);
        this.tfVlrTotal.setDouble(this.vlrTotal);
        this.tfNmrParcela.setEditable(false);
        Double vlrParcela = ToolFormatter.arrredondarNumero((Double)(this.vlrTotal / (double)this.nmrParcelas), (int)2);
        Date data = new Date();
        short nrParcelasAux = this.nmrParcelas;
        Double totalAux = 0.0;
        for (int i = 1; i <= this.nmrParcelas; ++i) {
            if (nrParcelasAux == i) {
                vlrParcela = ToolFormatter.arrredondarNumero((Double)(this.vlrTotal - totalAux), (int)2);
            } else {
                totalAux = totalAux + vlrParcela;
            }
            PedidoTitulo titulo = new PedidoTitulo();
            titulo.setDataCadastro(new Date());
            titulo.setDataVencimento(ToolDate.nextMonth((Date)data, (int)i));
            titulo.setNumeroParcela((short)i);
            titulo.setValor(vlrParcela);
            this.titulos.add(titulo);
        }
        this.setTitulosTable();
        this.tfVlrParcela.setDouble(vlrParcela);
        this.getStage().setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent t) {
                if (TituloPedido.this.isValidTitulosSalvos()) {
                    TituloPedido.this.closeDialog();
                } else {
                    Optional<ButtonType> resp = Alerts.showQuestion("Alguns titulos n\u00e3o foram salvos, se sair do recurso os mesmos seram removidos. Deseja continuar?");
                    if (resp.isPresent() && resp.get() == ButtonType.OK) {
                        TituloPedido.this.removeTitulosNaoSalvos();
                        TituloPedido.this.closeDialog();
                    }
                }
            }
        });
    }

    private void setDadosTextFields() {
        PedidoTitulo tit = (PedidoTitulo)this.tableTitulos.getSelectionModel().getSelectedItem();
        if (tit != null) {
            this.tfData.setText(ToolDate.dateToStr((Date)tit.getDataVencimento(), (String)"dd/MM/yyyy"));
            this.tfNmrParcela.setText(String.valueOf(tit.getNumeroParcela()));
            this.tfVlrParcela.setDouble(tit.getValor());
            if (this.tfVlrParcela.isFocused()) {
                this.tfVlrParcela.setEditable(true);
                this.tfVlrParcela.selectAll();
            } else if (this.tfData.isFocused()) {
                this.tfData.selectAll();
                this.tfData.setEditable(true);
            }
        }
    }

    private void requestFocusTable() {
        this.tableTitulos.requestFocus();
        this.tableTitulos.getSelectionModel().selectFirst();
    }

    private void confirma() {
        Double tot = 0.0;
        for (PedidoTitulo titulo : this.titulos) {
            tot = tot + titulo.getValor();
        }
        if (ToolFormatter.arrredondarNumero((Double)tot, (int)2).equals(this.vlrTotal)) {
            this.closeDialog();
        } else {
            Alerts.showAlertError("Valor somado das parcelas deve ser igual ao valor total");
        }
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt != null) {
            switch (evt.getCode()) {
                case F12: {
                    this.confirma();
                    break;
                }
                case F3: {
                    this.tfVlrParcela.requestFocus();
                    this.setDadosTextFields();
                    break;
                }
                case F4: {
                    this.tfData.requestFocus();
                    this.setDadosTextFields();
                    break;
                }
                case ESCAPE: {
                    this.closeDialog();
                }
            }
        }
    }

    public List<PedidoTitulo> getTitulos() {
        return this.titulos;
    }

    @Override
    public void eventAltControl(KeyEvent event) {
    }

    private boolean isValidTitulosSalvos() {
        ObservableList listTitulos = this.tableTitulos.getItems();
        if (listTitulos == null || listTitulos.isEmpty()) {
            return true;
        }
        for (PedidoTitulo c : listTitulos) {
            if (c.getIdentificador() != null && c.getIdentificador() != 0L) continue;
            return false;
        }
        return true;
    }

    private void removeTitulosNaoSalvos() {
        ObservableList listTitulos = this.tableTitulos.getItems();
        ArrayList<PedidoTitulo> titulosNaoSalvos = new ArrayList<PedidoTitulo>();
        for (PedidoTitulo c : listTitulos) {
            if (c.getIdentificador() != null && c.getIdentificador() != 0L) continue;
            titulosNaoSalvos.add(c);
        }
        if (!titulosNaoSalvos.isEmpty()) {
            this.titulos.removeAll(titulosNaoSalvos);
            this.tableTitulos.getItems().removeAll(titulosNaoSalvos);
            this.tableTitulos.refresh();
        }
    }
}

