/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.helpers.impostos.cbs.calculo;

import com.touchcomp.basementor.constants.enums.number.EnumConstTipoArredondamento;
import com.touchcomp.basementorrules.constants.EnumConstSimNaoImp;
import com.touchcomp.basementorrules.constants.EnumConstTipoCalcImp;
import com.touchcomp.touchnfce.helpers.impostos.cbs.calculo.adapter.CBSInterfaceCalculo;
import com.touchcomp.touchnfce.model.ClassificacaoTributariaCbsIbs;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeItemCbs;

public class NFCeItemCBSCalcAdapter
implements CBSInterfaceCalculo {
    final NFCeItem item;
    final NFCeItemCbs itemCbs;

    public NFCeItemCBSCalcAdapter(NFCeItem item) {
        this.item = item;
        this.itemCbs = item.getCbs();
    }

    @Override
    public void setAliquotaCBS(double aliquotaCBS) {
        this.itemCbs.setAliquotaCBS(aliquotaCBS);
    }

    @Override
    public void setAliquotaEfetivaCBS(double aliquotaCBS) {
        this.itemCbs.setAliquotaEfetivaCBS(aliquotaCBS);
    }

    @Override
    public void setBaseCalculoCBS(double baseCalculo) {
        this.itemCbs.setBaseCalculoCBS(baseCalculo);
    }

    @Override
    public void setValorCBS(double valorCBS) {
        this.itemCbs.setValorCBS(valorCBS);
    }

    @Override
    public Double getAliquotaCBS() {
        return this.itemCbs.getAliquotaCBS();
    }

    @Override
    public Double getPercRedAliquotaCBS() {
        return this.itemCbs.getPercRedAliquotaCBS();
    }

    @Override
    public Double getPercRedBC() {
        return 0.0;
    }

    @Override
    public Double getQuantidade() {
        return this.item.getQuantidadeComercial();
    }

    @Override
    public Double getValorDesconto() {
        return this.item.getValorDesconto();
    }

    @Override
    public Double getValorDespAcess() {
        return this.item.getValorDespesasAcessorias();
    }

    @Override
    public Double getValorFrete() {
        return this.item.getValorFrete();
    }

    @Override
    public Double getValorSeguro() {
        return this.item.getValorSeguro();
    }

    @Override
    public Double getValorProdutosServicos() {
        return this.item.getValorTotal();
    }

    @Override
    public EnumConstSimNaoImp getIncluirFreteBC() {
        if (this.item.getModeloFiscal().getModeloFiscalCbsIbs() != null) {
            return EnumConstSimNaoImp.get((Object)this.item.getModeloFiscal().getModeloFiscalCbsIbs().getIncluiFreteBC());
        }
        return EnumConstSimNaoImp.SIM;
    }

    @Override
    public EnumConstSimNaoImp getIncluirSeguroBC() {
        if (this.item.getModeloFiscal().getModeloFiscalCbsIbs() != null) {
            return EnumConstSimNaoImp.get((Object)this.item.getModeloFiscal().getModeloFiscalCbsIbs().getIncluiSeguroBC());
        }
        return EnumConstSimNaoImp.SIM;
    }

    @Override
    public EnumConstSimNaoImp getIncluirDescontoBC() {
        if (this.item.getModeloFiscal().getModeloFiscalCbsIbs() != null) {
            return EnumConstSimNaoImp.get((Object)this.item.getModeloFiscal().getModeloFiscalCbsIbs().getIncluiDescontoBC());
        }
        return EnumConstSimNaoImp.SIM;
    }

    @Override
    public EnumConstSimNaoImp getIncluirDespAcessBC() {
        if (this.item.getModeloFiscal().getModeloFiscalCbsIbs() != null) {
            return EnumConstSimNaoImp.get((Object)this.item.getModeloFiscal().getModeloFiscalCbsIbs().getIncluiDespAcessBC());
        }
        return EnumConstSimNaoImp.SIM;
    }

    @Override
    public EnumConstTipoCalcImp getTipoCalculo() {
        return EnumConstTipoCalcImp.CALCULAR_NORMAL;
    }

    @Override
    public EnumConstTipoArredondamento getModoArredondamento() {
        return EnumConstTipoArredondamento.ROUND_HALF_UP;
    }

    @Override
    public ClassificacaoTributariaCbsIbs getClassificacaoTributariaCbsIbs() {
        return this.item.getCbs() != null ? this.item.getCbs().getIncidenciaTributariaClass() : null;
    }
}

