/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.helpers.impostos.cbs.calculo;

import com.touchcomp.basementorrules.exceptions.ExceptionImpostoCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.CompImpostoCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.constants.EnumConstNFeIncidenciaCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.model.CbsIbsCalculado;
import com.touchcomp.basementorrules.impostos.cbsibs.model.CbsIbsParams;
import com.touchcomp.touchnfce.helpers.impostos.cbs.calculo.NFCeItemCBSCalcAdapter;
import com.touchcomp.touchnfce.helpers.impostos.cbs.calculo.adapter.CBSInterfaceCalculo;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeItemCbs;

public class SCompCBScalculo {
    CompImpostoCbsIbs compCalculo = CompImpostoCbsIbs.get();

    public void calcular(NFCeItem item) throws ExceptionImpostoCbsIbs {
        if (item.getCbs() == null) {
            item.setCbs(new NFCeItemCbs());
        }
        this.calcularInternal(new NFCeItemCBSCalcAdapter(item));
    }

    private void calcularInternal(CBSInterfaceCalculo item) throws ExceptionImpostoCbsIbs {
        if (item.getClassificacaoTributariaCbsIbs() == null) {
            return;
        }
        CbsIbsParams params = new CbsIbsParams();
        params.setAliquota(item.getAliquotaCBS());
        params.setPercRedAliquota(item.getPercRedAliquotaCBS());
        params.setIncluirFreteBC(item.getIncluirFreteBC());
        params.setIncluirSeguroBC(item.getIncluirSeguroBC());
        params.setIncluirValorDescontoBC(item.getIncluirDescontoBC());
        params.setIncluirValorDespAcessBC(item.getIncluirDespAcessBC());
        params.setModoArredondamento(item.getModoArredondamento());
        params.setPercRedAliquota(item.getPercRedAliquotaCBS());
        params.setPercRedBC(item.getPercRedBC());
        params.setQuantidade(item.getQuantidade());
        params.setTipoCalculo(item.getTipoCalculo());
        params.setValorDesconto(item.getValorDesconto());
        params.setValorDespAcess(item.getValorDespAcess());
        params.setValorFrete(item.getValorFrete());
        params.setValorSeguro(item.getValorSeguro());
        params.setVrProdServ(item.getValorProdutosServicos());
        params.setIncidenciaCbsIbs(EnumConstNFeIncidenciaCbsIbs.valueOfCodigo((String)item.getClassificacaoTributariaCbsIbs().getIncidenciaCbsIbs().getCodigo()));
        params.setCalcularCbsIbs(item.getClassificacaoTributariaCbsIbs().getCalcularCbsIbs());
        CbsIbsCalculado calc = this.compCalculo.calcular(params.build());
        item.setAliquotaCBS(calc.getAliquota());
        item.setBaseCalculoCBS(calc.getBaseCalculo());
        item.setAliquotaEfetivaCBS(calc.getAliquotaEfetiva());
        item.setValorCBS(calc.getValor());
    }
}

