/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.helpers.impostos.cbs.params;

import com.touchcomp.basementor.constants.enums.impostos.EnumConstantsTipoImp;
import com.touchcomp.basementor.constants.enums.impostos.cbsibs.EnumConstantsTipoAliqCBSIBS;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.helpers.impostos.AuxSetParamsCbsIbs;
import com.touchcomp.touchnfce.helpers.impostos.cbs.params.CBSInterfaceSetParams;
import com.touchcomp.touchnfce.helpers.impostos.cbs.params.adapter.NFCeItemCBSAdapter;
import com.touchcomp.touchnfce.model.ClassificacaoTributariaCbsIbs;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.ModeloDocFiscal;
import com.touchcomp.touchnfce.model.ModeloFiscalCbsIbs;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeItemCbs;
import java.util.Date;
import org.springframework.stereotype.Service;

@Service
public class SCompCBSParams {
    public void setParams(NFCeItem item, Empresa empresa, Date dataEmissao, ModeloDocFiscal modeloDocFiscal) throws ExceptionInvalidData {
        if (item.getCbs() == null) {
            item.setCbs(new NFCeItemCbs());
        }
        this.setParamsInternal(new NFCeItemCBSAdapter(item, empresa, dataEmissao, modeloDocFiscal));
    }

    void setParamsInternal(CBSInterfaceSetParams item) throws ExceptionInvalidData {
        if (item.getModeloFiscalCBSIBS() == null) {
            return;
        }
        ModeloFiscalCbsIbs modelo = item.getModeloFiscalCBSIBS();
        if (modelo == null) {
            return;
        }
        if (item.getNcm() == null) {
            return;
        }
        if (item.getEmpresa() == null) {
            return;
        }
        Date dataEmissao = item.getDataEmissao();
        if (item.getDataEmissao() == null) {
            dataEmissao = new Date();
        }
        AuxSetParamsCbsIbs auxSet = new AuxSetParamsCbsIbs();
        item.setIncidenciaCBS(modelo.getIncidenciaTributaria());
        ClassificacaoTributariaCbsIbs incidenciaTributariaClass = auxSet.getCodClassTributaria(dataEmissao, item.getEmpresa(), item.getNcm(), modelo, item.getModeloDocFiscal(), item.getCfop());
        Double percRedAliqCBS = incidenciaTributariaClass.getPercRedAliquotaCBS();
        if (ToolMethods.isEqualsNumber((Number)modelo.getTipoAliquota(), (Number)EnumConstantsTipoAliqCBSIBS.INFORMADA.getValue())) {
            percRedAliqCBS = modelo.getPercRedAliquotaCBS();
        }
        item.setClassificacaoCBS(modelo.getIncidenciaTributariaClass());
        item.setAliquotaCBS(auxSet.getAliquota(dataEmissao, null, modelo, EnumConstantsTipoImp.CBS, modelo.getAliquotaCBS()));
        item.setAliquotaPresumidaCBS(modelo.getAliquotaCBS());
        item.setPercRedAliquotaCBS(percRedAliqCBS);
        item.setPercRedBC(auxSet.getRedBC(incidenciaTributariaClass, modelo));
        item.setClassificacaoCBS(incidenciaTributariaClass);
    }
}

