/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.helpers.impostos.ibs.calculo;

import com.touchcomp.basementorrules.exceptions.ExceptionImpostoCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.CompImpostoCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.constants.EnumConstNFeIncidenciaCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.model.CbsIbsCalculado;
import com.touchcomp.basementorrules.impostos.cbsibs.model.CbsIbsParams;
import com.touchcomp.touchnfce.helpers.impostos.ibs.calculo.IBSInterfaceCalculo;
import com.touchcomp.touchnfce.helpers.impostos.ibs.calculo.adapters.NFCeItemIBSCalcAdapter;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeItemIbs;

public class SCompIBScalculo {
    CompImpostoCbsIbs compCalculo = CompImpostoCbsIbs.get();

    public void calcular(NFCeItem item) throws ExceptionImpostoCbsIbs {
        if (item.getIbs() == null) {
            item.setIbs(new NFCeItemIbs());
        }
        this.calcularValores(new NFCeItemIBSCalcAdapter(item));
    }

    protected void calcularValores(IBSInterfaceCalculo item) throws ExceptionImpostoCbsIbs {
        CbsIbsParams params = new CbsIbsParams();
        if (item.getClassificacaoTributariaCbsIbs() == null) {
            return;
        }
        this.buildCommonParamsIbsMun(item, params);
        CbsIbsCalculado calc = this.compCalculo.calcular(params.build());
        item.setAliquotaIBSMun(calc.getAliquota());
        item.setAliquotaEfetivaIBSMun(calc.getAliquotaEfetiva());
        item.setValorBaseCalcIBS(calc.getBaseCalculo());
        item.setValorIBSMun(calc.getValor());
        this.buildCommonParamsIbsUF(item, params);
        calc = this.compCalculo.calcular(params.build());
        item.setAliquotaIBSUF(calc.getAliquota());
        item.setAliquotaEfetivaIBSUF(calc.getAliquotaEfetiva());
        item.setValorBaseCalcIBS(calc.getBaseCalculo());
        item.setValorIBSUF(calc.getValor());
    }

    void buildCommonParams(IBSInterfaceCalculo item, CbsIbsParams params) {
        params.setIncluirFreteBC(item.getIncluirFreteBC());
        params.setIncluirSeguroBC(item.getIncluirSeguroBC());
        params.setIncluirValorDescontoBC(item.getIncluirDescontoBC());
        params.setIncluirValorDespAcessBC(item.getIncluirDespAcessBC());
        params.setModoArredondamento(item.getModoArredondamento());
        params.setTipoCalculo(item.getTipoCalculo());
        params.setPercRedBC(item.getPercRedBC());
        params.setQuantidade(item.getQuantidade());
        params.setTipoCalculo(item.getTipoCalculo());
        params.setValorDesconto(item.getValorDesconto());
        params.setValorDespAcess(item.getValorDespAcess());
        params.setValorFrete(item.getValorFrete());
        params.setValorSeguro(item.getValorSeguro());
        params.setVrProdServ(item.getValorProdutosServicos());
        params.setIncidenciaCbsIbs(EnumConstNFeIncidenciaCbsIbs.valueOfCodigo((String)item.getClassificacaoTributariaCbsIbs().getIncidenciaCbsIbs().getCodigo()));
        params.setCalcularCbsIbs(item.getClassificacaoTributariaCbsIbs().getCalcularCbsIbs());
    }

    void buildCommonParamsIbsUF(IBSInterfaceCalculo item, CbsIbsParams params) {
        this.buildCommonParams(item, params);
        params.setAliquota(item.getAliquotaIBSUF());
        params.setPercRedAliquota(item.getPercRedAliquotaIBSUF());
    }

    void buildCommonParamsIbsMun(IBSInterfaceCalculo item, CbsIbsParams params) {
        this.buildCommonParams(item, params);
        params.setAliquota(item.getAliquotaIBSMun());
        params.setPercRedAliquota(item.getPercRedAliquotaIBSMun());
    }
}

