/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.helpers.impostos.ibs.calculo.adapters;

import com.touchcomp.basementor.constants.enums.number.EnumConstTipoArredondamento;
import com.touchcomp.basementorrules.constants.EnumConstSimNaoImp;
import com.touchcomp.basementorrules.constants.EnumConstTipoCalcImp;
import com.touchcomp.touchnfce.helpers.impostos.ibs.calculo.IBSInterfaceCalculo;
import com.touchcomp.touchnfce.model.ClassificacaoTributariaCbsIbs;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeItemIbs;

public class NFCeItemIBSCalcAdapter
implements IBSInterfaceCalculo {
    final NFCeItem item;
    final NFCeItemIbs itemIbs;

    public NFCeItemIBSCalcAdapter(NFCeItem item) {
        this.item = item;
        this.itemIbs = item.getIbs();
    }

    @Override
    public Double getPercRedBC() {
        return 0.0;
    }

    @Override
    public Double getQuantidade() {
        return this.item.getQuantidadeComercial();
    }

    @Override
    public Double getValorDesconto() {
        return this.item.getValorDesconto();
    }

    @Override
    public Double getValorDespAcess() {
        return this.item.getValorDespesasAcessorias();
    }

    @Override
    public Double getValorFrete() {
        return this.item.getValorFrete();
    }

    @Override
    public Double getValorSeguro() {
        return this.item.getValorSeguro();
    }

    @Override
    public EnumConstSimNaoImp getIncluirFreteBC() {
        if (this.item.getModeloFiscal().getModeloFiscalCbsIbs() != null) {
            return EnumConstSimNaoImp.get((Object)this.item.getModeloFiscal().getModeloFiscalCbsIbs().getIncluiFreteBC());
        }
        return EnumConstSimNaoImp.SIM;
    }

    @Override
    public EnumConstSimNaoImp getIncluirSeguroBC() {
        if (this.item.getModeloFiscal().getModeloFiscalCbsIbs() != null) {
            return EnumConstSimNaoImp.get((Object)this.item.getModeloFiscal().getModeloFiscalCbsIbs().getIncluiSeguroBC());
        }
        return EnumConstSimNaoImp.SIM;
    }

    @Override
    public EnumConstSimNaoImp getIncluirDescontoBC() {
        if (this.item.getModeloFiscal().getModeloFiscalCbsIbs() != null) {
            return EnumConstSimNaoImp.get((Object)this.item.getModeloFiscal().getModeloFiscalCbsIbs().getIncluiDescontoBC());
        }
        return EnumConstSimNaoImp.SIM;
    }

    @Override
    public EnumConstSimNaoImp getIncluirDespAcessBC() {
        if (this.item.getModeloFiscal().getModeloFiscalCbsIbs() != null) {
            return EnumConstSimNaoImp.get((Object)this.item.getModeloFiscal().getModeloFiscalCbsIbs().getIncluiDespAcessBC());
        }
        return EnumConstSimNaoImp.SIM;
    }

    @Override
    public EnumConstTipoCalcImp getTipoCalculo() {
        return EnumConstTipoCalcImp.CALCULAR_NORMAL;
    }

    @Override
    public EnumConstTipoArredondamento getModoArredondamento() {
        return EnumConstTipoArredondamento.ROUND_HALF_UP;
    }

    @Override
    public void setAliquotaIBSMun(double aliquota) {
        this.itemIbs.setAliquotaIBSMun(aliquota);
    }

    @Override
    public void setAliquotaIBSUF(double aliquota) {
        this.itemIbs.setAliquotaIBSUF(aliquota);
    }

    @Override
    public void setValorBaseCalcIBS(double baseCalculo) {
        this.itemIbs.setValorBaseCalcIBS(baseCalculo);
    }

    @Override
    public void setValorIBSMun(double valor) {
        this.itemIbs.setValorIBSMun(valor);
    }

    @Override
    public void setValorIBSUF(double valor) {
        this.itemIbs.setValorIBSUF(valor);
    }

    @Override
    public Double getAliquotaIBSMun() {
        return this.itemIbs.getAliquotaIBSMun();
    }

    @Override
    public Double getAliquotaIBSUF() {
        return this.itemIbs.getAliquotaIBSUF();
    }

    @Override
    public Double getPercRedAliquotaIBSMun() {
        return this.itemIbs.getPercRedAliquotaIBSMun();
    }

    @Override
    public Double getPercRedAliquotaIBSUF() {
        return this.itemIbs.getPercRedAliquotaIBSUF();
    }

    @Override
    public Double getValorProdutosServicos() {
        return this.item.getValorTotal();
    }

    @Override
    public ClassificacaoTributariaCbsIbs getClassificacaoTributariaCbsIbs() {
        return this.item.getIbs() != null ? this.item.getIbs().getIncidenciaTributariaClass() : null;
    }

    @Override
    public void setAliquotaEfetivaIBSMun(double aliquotaIBSMun) {
        this.itemIbs.setAliquotaEfetivaIBSMun(aliquotaIBSMun);
    }

    @Override
    public void setAliquotaEfetivaIBSUF(double aliquotaIBSUf) {
        this.itemIbs.setAliquotaEfetivaIBSUF(aliquotaIBSUf);
    }
}

