/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.helpers.impostos.ibs.params;

import com.touchcomp.basementor.constants.enums.impostos.EnumConstantsTipoImp;
import com.touchcomp.basementor.constants.enums.impostos.cbsibs.EnumConstantsTipoAliqCBSIBS;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.helpers.impostos.AuxSetParamsCbsIbs;
import com.touchcomp.touchnfce.helpers.impostos.ibs.params.IBSInterfaceSetParams;
import com.touchcomp.touchnfce.helpers.impostos.ibs.params.adapters.NFCeItemIBSAdapter;
import com.touchcomp.touchnfce.model.Cidade;
import com.touchcomp.touchnfce.model.ClassificacaoTributariaCbsIbs;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.ModeloDocFiscal;
import com.touchcomp.touchnfce.model.ModeloFiscalCbsIbs;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeItemIbs;
import java.util.Date;
import org.springframework.stereotype.Service;

@Service
public class SCompIBSParams {
    public void setParams(NFCeItem item, Empresa empresa, Date dataEmissao, ModeloDocFiscal modeloDocFiscal, Cidade cidadeCliente) throws ExceptionInvalidData {
        if (item.getIbs() == null) {
            item.setIbs(new NFCeItemIbs());
        }
        this.setParamsInternal(new NFCeItemIBSAdapter(item, empresa, dataEmissao, modeloDocFiscal, cidadeCliente));
    }

    private void setParamsInternal(IBSInterfaceSetParams item) throws ExceptionInvalidData {
        if (item.getModeloFiscalCbsIbs() == null) {
            return;
        }
        if (item.getNcm() == null) {
            return;
        }
        if (item.getEmpresa() == null) {
            return;
        }
        if (item.getCidadeCliente() == null) {
            return;
        }
        Date dataEmissao = item.getDataEmissao();
        if (item.getDataEmissao() == null) {
            dataEmissao = new Date();
        }
        AuxSetParamsCbsIbs auxSet = new AuxSetParamsCbsIbs();
        ModeloFiscalCbsIbs modelo = item.getModeloFiscalCbsIbs();
        item.setIncidenciaIBS(modelo.getIncidenciaTributaria());
        ClassificacaoTributariaCbsIbs incidenciaTributariaClass = auxSet.getCodClassTributaria(dataEmissao, item.getEmpresa(), item.getNcm(), modelo, item.getModeloDocFiscal(), item.getCfop());
        item.setClassificacaoIBS(incidenciaTributariaClass);
        Double percRedAliqIBSMun = incidenciaTributariaClass.getPercRedAliquotaIBSMun();
        Double percRedAliqIBSUF = incidenciaTributariaClass.getPercRedAliquotaIBSUF();
        if (ToolMethods.isEqualsNumber((Number)modelo.getTipoAliquota(), (Number)EnumConstantsTipoAliqCBSIBS.INFORMADA.getValue())) {
            percRedAliqIBSMun = modelo.getPercRedAliquotaIBSMun();
            percRedAliqIBSUF = modelo.getPercRedAliquotaIBSUF();
        }
        item.setPercRedAliquotaIBSMun(percRedAliqIBSMun);
        item.setPercRedAliquotaIBSUF(percRedAliqIBSUF);
        item.setPercRedBC(auxSet.getRedBC(incidenciaTributariaClass, modelo));
        item.setAliquotaIBSMun(auxSet.getAliquota(dataEmissao, item.getCidadeCliente(), modelo, EnumConstantsTipoImp.IBS_MUN, modelo.getAliquotaIBSMun()));
        item.setAliquotaIBSUF(auxSet.getAliquota(dataEmissao, item.getCidadeCliente(), modelo, EnumConstantsTipoImp.IBS_UF, modelo.getAliquotaIBSUF()));
    }
}

