/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.helpers.impostos.ibs.params.adapters;

import com.touchcomp.basementor.constants.enums.modelodocfiscal.EnumConstModDocFiscal;
import com.touchcomp.touchnfce.helpers.impostos.ibs.params.IBSInterfaceSetParams;
import com.touchcomp.touchnfce.model.Cfop;
import com.touchcomp.touchnfce.model.Cidade;
import com.touchcomp.touchnfce.model.ClassificacaoTributariaCbsIbs;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.IncidenciaCbsIbs;
import com.touchcomp.touchnfce.model.ModeloDocFiscal;
import com.touchcomp.touchnfce.model.ModeloFiscalCbsIbs;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.Ncm;
import java.util.Date;

public class NFCeItemIBSAdapter
implements IBSInterfaceSetParams {
    final NFCeItem item;
    final Empresa empresa;
    final Date dataEmissao;
    final Cidade cidade;
    final ModeloDocFiscal modeloDocFiscal;

    public NFCeItemIBSAdapter(NFCeItem item, Empresa empresa, Date dataEmissao, ModeloDocFiscal modeloDocFiscal, Cidade cidade) {
        this.item = item;
        this.empresa = empresa;
        this.dataEmissao = dataEmissao;
        this.modeloDocFiscal = modeloDocFiscal;
        this.cidade = cidade;
    }

    @Override
    public ModeloFiscalCbsIbs getModeloFiscalCbsIbs() {
        return this.item.getModeloFiscal() != null ? this.item.getModeloFiscal().getModeloFiscalCbsIbs() : null;
    }

    @Override
    public void setIncidenciaIBS(IncidenciaCbsIbs incidencia) {
        this.item.getIbs().setIncidenciaTributaria(incidencia);
    }

    @Override
    public void setClassificacaoIBS(ClassificacaoTributariaCbsIbs classificacao) {
        this.item.getIbs().setIncidenciaTributariaClass(classificacao);
    }

    @Override
    public void setAliquotaIBSUF(Double aliquota) {
        this.item.getIbs().setAliquotaIBSUF(aliquota);
    }

    @Override
    public void setAliquotaIBSMun(Double aliquota) {
        this.item.getIbs().setAliquotaIBSMun(aliquota);
    }

    @Override
    public void setPercRedAliquotaIBSUF(Double aliquota) {
        this.item.getIbs().setPercRedAliquotaIBSUF(aliquota);
    }

    @Override
    public void setPercRedAliquotaIBSMun(Double aliquota) {
        this.item.getIbs().setPercRedAliquotaIBSMun(aliquota);
    }

    @Override
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Override
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    @Override
    public Ncm getNcm() {
        return this.item.getProduto() != null ? this.item.getProduto().getNcm() : null;
    }

    @Override
    public EnumConstModDocFiscal getModeloDocFiscal() {
        return EnumConstModDocFiscal.get((Object)this.modeloDocFiscal.getCodigo());
    }

    @Override
    public void setPercRedBC(Double percRedBC) {
        this.item.getIbs().setPercRedBC(percRedBC);
    }

    @Override
    public Cidade getCidadeCliente() {
        return this.cidade;
    }

    @Override
    public Cfop getCfop() {
        return this.item.getCfop();
    }
}

