/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.helpers.nfcesefaz;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoEmissao;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.helpers.nfcesefaz.HelperNFCeSefaz;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeLoteNotas;
import com.touchcomp.touchnfce.model.TipoEmissaoNFe;
import com.touchcomp.touchnfce.tasks.utils.UtilConsultaStatusNFCe;
import com.touchcomp.touchnfce.tasks.utils.UtilRetransmiteNFCeWebService;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class HelperNFCeSefazEnvioInconsistencia {
    private static HelperNFCeSefazEnvioInconsistencia uniqueInstance;
    private boolean isFinish = true;

    HelperNFCeSefazEnvioInconsistencia() {
    }

    public static synchronized HelperNFCeSefazEnvioInconsistencia getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new HelperNFCeSefazEnvioInconsistencia();
        }
        return uniqueInstance;
    }

    public boolean enviarNotasComProblema(List<NFCe> nfces) throws Exception {
        try {
            if (!this.isFinish) {
                System.out.println("Notas estao sendo enviadas em segundo plano!");
                boolean bl = false;
                return bl;
            }
            this.isFinish = false;
            nfces = this.ordenarListaEmissaoPorPeriodo(nfces);
            nfces = this.enviarOuCancelarNFCe(nfces);
            return (boolean)nfces;
        }
        catch (Exception ex) {
            this.isFinish = true;
            throw new Exception(ex.getMessage());
        }
        finally {
            this.isFinish = true;
            return true;
        }
    }

    private List<NFCe> ordenarListaEmissaoPorPeriodo(List<NFCe> lista) {
        if (lista != null) {
            Collections.sort(lista, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    NFCe nfce1 = (NFCe)o1;
                    NFCe nfce2 = (NFCe)o2;
                    Short cod1 = nfce1.getPeriodoEmissaoNFCe() != null ? nfce1.getPeriodoEmissaoNFCe().getTipoEmissaoNfe().getCodigo() : nfce1.getPeriodoEmissaoNFe().getTipoEmissaoNfe().getCodigo();
                    Short cod2 = nfce2.getPeriodoEmissaoNFCe() != null ? nfce2.getPeriodoEmissaoNFCe().getTipoEmissaoNfe().getCodigo() : nfce2.getPeriodoEmissaoNFe().getTipoEmissaoNfe().getCodigo();
                    return cod2.compareTo(cod1);
                }
            });
            return lista;
        }
        return new ArrayList<NFCe>();
    }

    private List<NFCe> enviarOuCancelarNFCe(List<NFCe> nfces) throws Exception {
        ArrayList<NFCe> novaLista = new ArrayList<NFCe>();
        for (NFCe nfce : nfces) {
            try {
                if (nfce.getNfCeCancelamento() != null && nfce.getNfCeCancelamento().getNfcePosterior() != null) {
                    for (NFCe n : novaLista) {
                        if (!ToolMethods.isEquals((Object)n.getIdentificador(), (Object)nfce.getNfCeCancelamento().getNfcePosterior().getIdentificador())) continue;
                        nfce.getNfCeCancelamento().setNfcePosterior(n);
                        break;
                    }
                }
                nfce = this.trata(nfce);
                UtilRetransmiteNFCeWebService.posEnvio(nfce);
                novaLista.add(nfce);
            }
            catch (Exception ex) {
                TLogger.get(this.getClass()).error((Throwable)ex);
                throw ex;
            }
        }
        return novaLista;
    }

    private NFCe trata(NFCe nfce) throws Exception {
        if (EnumConstNFeStatus.isStatusAutorizada((Integer)(nfce = this.consultaNFCe(nfce)).getStatus())) {
            if (nfce.getNfCeCancelamento() != null && nfce.getNfCeCancelamento().getNfcePosterior() != null && EnumConstNFeStatus.isStatusAutorizada((Integer)nfce.getNfCeCancelamento().getNfcePosterior().getStatus())) {
                nfce = this.cancelarNFeSubstituicao(nfce);
                return nfce;
            }
            return nfce;
        }
        nfce = nfce.getStatus().equals(EnumConstNFeStatus.REJ_NFE_NAO_CONSTA_BASE_DADOS_SEFAZ.getValue()) ? (nfce.getNfCeCancelamento() != null ? this.inutilizarExcluirNFCe(nfce) : this.enviaNFCe(nfce)) : (nfce.getNfCeCancelamento() != null ? this.cancelarNFe(nfce) : this.enviaNFCe(nfce));
        return nfce;
    }

    private NFCe consultaNFCe(NFCe nfCe) throws Exception {
        nfCe = UtilConsultaStatusNFCe.execute(StaticObjects.getOpcoes(), nfCe);
        return nfCe;
    }

    private NFCe enviaNFCe(NFCe nfCe) throws Exception {
        nfCe = this.criaLoteNotasNFCe(nfCe);
        nfCe = UtilRetransmiteNFCeWebService.execute(nfCe);
        return nfCe;
    }

    private NFCe criaLoteNotasNFCe(NFCe nfce) {
        TipoEmissaoNFe tipoEmissao;
        TipoEmissaoNFe tipoEmissaoNFe = tipoEmissao = nfce.getPeriodoEmissaoNFCe() != null ? nfce.getPeriodoEmissaoNFCe().getTipoEmissaoNfe() : nfce.getPeriodoEmissaoNFe().getTipoEmissaoNfe();
        if (ToolMethods.isEquals((Object)tipoEmissao.getCodigo(), (Object)EnumConstNFeTipoEmissao.CONTIGENCIA_OFFLINE.getValue()) || ToolMethods.isEquals((Object)tipoEmissao.getCodigo(), (Object)EnumConstNFeTipoEmissao.CONTIGENCIA_EPEC_EVENTO_EPEC.getValue()) || ToolMethods.isEquals((Object)tipoEmissao.getCodigo(), (Object)EnumConstNFeTipoEmissao.CONTIGENCIA_EMISSAO_FS.getValue()) || ToolMethods.isEquals((Object)tipoEmissao.getCodigo(), (Object)EnumConstNFeTipoEmissao.CONTIGENCIA_FSDA.getValue())) {
            // empty if block
        }
        if (nfce.getLoteNotas() == null) {
            NFCeLoteNotas lote = new NFCeLoteNotas();
            lote.getNotas().add(nfce);
            lote.setVersaoNFe(StaticObjects.getOpcoes().getVersaoNFe());
            lote.setTipoAmbiente(StaticObjects.getOpcoes().getTipoAmbiente());
            nfce.setLoteNotas(lote);
        }
        nfce = UtilNFCe.save(nfce);
        return nfce;
    }

    private NFCe inutilizarExcluirNFCe(NFCe nfce) throws Exception {
        String justificativa = "Foi emitida uma NFCe substituta em contingencia.";
        return new HelperNFCeSefaz().cancelar(nfce, justificativa, StaticObjects.getUsuario());
    }

    private NFCe cancelarNFe(NFCe nfce) throws Exception {
        String justificativa = "Foi emitida uma NFCe substituta em contingencia.";
        return new HelperNFCeSefaz().cancelar(nfce, justificativa, StaticObjects.getUsuario());
    }

    private NFCe cancelarNFeSubstituicao(NFCe nfce) throws Exception {
        String justificativa = "Foi emitida uma NFCe substituta em contingencia.";
        return new HelperNFCeSefaz().cancelarPorSubstituicao(nfce, justificativa, StaticObjects.getUsuario());
    }
}

