/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.helpers.preco.tabdinamica;

import com.touchcomp.basementor.constants.enums.tabelaprecosdinamica.EnumTabelaPrecosDinamicaTipo;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementortools.constants.EnumConstantsSimNao;
import com.touchcomp.basementortools.tools.avaliadorexpressoes.ToolAvaliadorExpressoes;
import com.touchcomp.basementortools.tools.avaliadorexpressoes.constants.EnumConstReflection;
import com.touchcomp.basementortools.tools.avaliadorexpressoes.constants.EnumConstTipoAvaliador;
import com.touchcomp.basementortools.tools.avaliadorexpressoes.model.DTOAvaliadorExpressoes;
import com.touchcomp.basementortools.tools.avaliadorexpressoes.model.DTOResultCalcExpressoes;
import com.touchcomp.basementortools.tools.calculos.ToolCalculos;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.exceptions.ExceptionTabelaPrecosDinamica;
import com.touchcomp.touchnfce.model.AvaliadorExpressoes;
import com.touchcomp.touchnfce.model.CondicoesPagamento;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.GradeCor;
import com.touchcomp.touchnfce.model.Grupo;
import com.touchcomp.touchnfce.model.NFCeOpcoes;
import com.touchcomp.touchnfce.model.NaturezaOperacao;
import com.touchcomp.touchnfce.model.Produto;
import com.touchcomp.touchnfce.model.Representante;
import com.touchcomp.touchnfce.model.TabelaPrecoBaseProduto;
import com.touchcomp.touchnfce.model.TabelaPrecosDinamica;
import com.touchcomp.touchnfce.model.TabelaPrecosDinamicaCond;
import com.touchcomp.touchnfce.model.TipoFrete;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.model.Usuario;
import com.touchcomp.touchnfce.modeltemp.TempPesquisaProduto;
import com.touchcomp.touchnfce.service.impl.ServiceGradeCor;
import com.touchcomp.touchnfce.service.impl.ServiceTabelaPrecoBaseProduto;
import com.touchcomp.touchnfce.service.impl.ServiceTabelaPrecosDinamica;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AuxTabelaPrecosDinamica {
    public List<TempPesquisaProduto> getPrecosProdutos(Empresa empresa, List<Produto> produtos, UnidadeFatCliente unid, Representante rep, Usuario usuario, Grupo grupo, TipoFrete tipoFrete, NaturezaOperacao natOP, CondicoesPagamento condicoesPagamento, NFCeOpcoes opcoes) throws ExceptionTabelaPrecosDinamica, ExceptionAvaliadorExpressoes {
        LinkedList<TempPesquisaProduto> aux = new LinkedList<TempPesquisaProduto>();
        boolean geraExcecao = produtos.size() == 1;
        for (Produto prod : produtos) {
            TempPesquisaProduto temp = this.getPrecosProdutos(empresa, prod, unid, rep, usuario, grupo, tipoFrete, natOP, condicoesPagamento, opcoes.getFormatoPesquisaTabDinamica(), opcoes.getTabelaPrecosDinamica(), geraExcecao);
            if (temp == null) continue;
            aux.add(temp);
        }
        return aux;
    }

    TempPesquisaProduto getPrecosProdutos(Empresa empresa, Produto produto, UnidadeFatCliente unid, Representante rep, Usuario usuario, Grupo grupo, TipoFrete tipoFrete, NaturezaOperacao natOP, CondicoesPagamento condicoesPagamento, String formatoPesqTabDinamica, TabelaPrecosDinamica tabDin, Boolean geraExcecao) throws ExceptionTabelaPrecosDinamica, ExceptionAvaliadorExpressoes {
        int nrDiasMedios = this.calculaCond(condicoesPagamento);
        TabelaPrecosDinamicaCond aval = this.getCondicao(unid, empresa, rep, produto, formatoPesqTabDinamica, tabDin);
        TabelaPrecoBaseProduto tbp = this.getTabelaPrecoBaseProd(aval, produto, geraExcecao);
        if (tbp == null) {
            return null;
        }
        Map values = this.buildMap(unid, rep, produto, condicoesPagamento, tbp, tipoFrete, empresa, natOP, usuario, grupo);
        values.put("pre_valor_minimo_calc_ped", tbp.getValorMinimo());
        values.put("pre_valor_maximo_calc_ped", tbp.getValorMaximo());
        values.put("pre_nr_dias_medios_cond_pag", nrDiasMedios);
        values.put("pre_perc_desconto_inf", 0.0);
        values.put("pre_valor_unitario_inf", 0.0);
        values.put(tbp.getClass().getCanonicalName(), tbp);
        values.put("valorVenda", tbp.getValorMaximo());
        DTOResultCalcExpressoes resultVlrMaximo = ToolAvaliadorExpressoes.processAndValidateValue((DTOAvaliadorExpressoes)this.toDTO(aval.getAvaliadorExpressoes()), (Map)values);
        values.put("valorVenda", tbp.getValorMinimo());
        DTOResultCalcExpressoes resultVlrMinimo = ToolAvaliadorExpressoes.processAndValidateValue((DTOAvaliadorExpressoes)this.toDTO(aval.getAvaliadorExpressoes()), (Map)values);
        values.put("valorVenda", tbp.getValorVenda());
        DTOResultCalcExpressoes resultVlrSugerido = ToolAvaliadorExpressoes.processAndValidateValue((DTOAvaliadorExpressoes)this.toDTO(aval.getAvaliadorExpressoes()), (Map)values);
        Double valorMin = resultVlrMinimo != null ? resultVlrMinimo.getResultado() : 0.0;
        Double valorMax = resultVlrMaximo != null ? resultVlrMaximo.getResultado() : 0.0;
        Double valorSug = resultVlrSugerido != null ? resultVlrSugerido.getResultado() : 0.0;
        TempPesquisaProduto val = this.avaliaComissao(unid, rep, produto, new Date(), condicoesPagamento, tipoFrete, empresa, valorSug, valorMin, valorMax, tbp.getPercComissaoPadrao(), 0.0, nrDiasMedios, natOP, usuario, grupo, formatoPesqTabDinamica, tabDin);
        val.setValorMaximo(valorMax);
        val.setValorMinimo(valorMin);
        val.setValorUnitario(valorSug);
        val.setValorUnitarioTabPreco(valorSug);
        val.setPrecoCusto(tbp.getValorCusto());
        if (resultVlrSugerido != null) {
            val.setAvaliadorExpressoes(aval.getAvaliadorExpressoes());
        }
        val.setIdProduto(tbp.getProduto().getIdentificador());
        val.setCodAuxiliar(tbp.getProduto().getCodigoAuxiliar());
        val.setNomeProduto(tbp.getProduto().getNome());
        val.setUnidadeMedida(tbp.getProduto().getUnidadeMedida().getSigla());
        val.setPercDescontoTrib(tbp.getPercentualDescTrib());
        val.setQtdNaoFracionada(tbp.getProduto().getQtdeNaoFracionada());
        this.setFirstGradeCor(tbp.getProduto(), val, geraExcecao);
        if (val.getIdGradeCor() != null) {
            return val;
        }
        return null;
    }

    private TabelaPrecosDinamicaCond getCondicao(UnidadeFatCliente unidadeFatCliente, Empresa empresa, Representante representante, Produto produto, String formatoPesquisa, TabelaPrecosDinamica tabDin) throws ExceptionTabelaPrecosDinamica {
        if (!ToolMethods.isStrWithData((String)formatoPesquisa)) {
            throw new ExceptionTabelaPrecosDinamica("Formato de pesquisa Tabela de pre\u00e7os dinamica n\u00e3o informado em op\u00e7\u00f5es.");
        }
        ServiceTabelaPrecosDinamica serviceTabelaPrecosDinamica = Main.getBean(ServiceTabelaPrecosDinamica.class);
        TabelaPrecosDinamicaCond aval = null;
        String[] partes = ToolString.splitString((String)formatoPesquisa, (char[])new char[]{','});
        HashMap<EnumTabelaPrecosDinamicaTipo, Object> data = new HashMap<EnumTabelaPrecosDinamicaTipo, Object>();
        if (unidadeFatCliente != null) {
            data.put(EnumTabelaPrecosDinamicaTipo.PESSOA_CLIENTE_1, unidadeFatCliente.getCliente().getPessoa());
            data.put(EnumTabelaPrecosDinamicaTipo.GRUPO_PESSOAS_CLIENTE_2, unidadeFatCliente.getCliente().getPessoa().getGrupoPessoas());
            data.put(EnumTabelaPrecosDinamicaTipo.CLASSIFICACAO_CLIENTE_5, unidadeFatCliente.getCliente().getClassificacaoClientes());
            data.put(EnumTabelaPrecosDinamicaTipo.CATEGORIA_CLIENTE_6, unidadeFatCliente.getCliente().getFaturamento().getCategoriaPessoa());
            data.put(EnumTabelaPrecosDinamicaTipo.REGIAO_TAB_PRECO_CLIENTE_7, unidadeFatCliente.getCliente().getFaturamento().getRegiaoTabPrecoDinamica());
        }
        if (representante != null) {
            data.put(EnumTabelaPrecosDinamicaTipo.PESSOA_REPRESENTANTE_3, representante.getPessoa());
            data.put(EnumTabelaPrecosDinamicaTipo.GRUPO_PESSOAS_REPRESENTANTE_4, representante.getPessoa().getGrupoPessoas());
        }
        data.put(EnumTabelaPrecosDinamicaTipo.PRODUTO_8, produto);
        for (String parte : partes) {
            aval = serviceTabelaPrecosDinamica.getTabela(data, empresa, parte, tabDin);
            if (aval == null) continue;
            return aval;
        }
        throw new ExceptionTabelaPrecosDinamica("Nenhuma tabela dinamica encontrada para cliente: " + String.valueOf(unidadeFatCliente) + "\n Representante: " + String.valueOf(representante) + "\n Produto: " + produto.getNome() + "\n empresa: " + empresa.getPessoa().getNome());
    }

    private TabelaPrecoBaseProduto getTabelaPrecoBaseProd(TabelaPrecosDinamicaCond aval, Produto produto, Boolean geraExcecao) throws ExceptionTabelaPrecosDinamica {
        try {
            ServiceTabelaPrecoBaseProduto service = Main.getBean(ServiceTabelaPrecoBaseProduto.class);
            TabelaPrecoBaseProduto t = service.getTabelaPrecoBaseProd(aval.getTabelaPrecoBase(), produto);
            if (t == null && geraExcecao.booleanValue()) {
                throw new ExceptionTabelaPrecosDinamica("Produto n\u00e3o est\u00e1 definido na tabela de precos base :" + aval.getTabelaPrecoBase().getDescricao() + " / " + produto.getNome());
            }
            if (t == null && !geraExcecao.booleanValue()) {
                return null;
            }
            return t;
        }
        catch (Exception ex) {
            Logger.getLogger(AuxTabelaPrecosDinamica.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionTabelaPrecosDinamica(ex.getMessage(), ex);
        }
    }

    TempPesquisaProduto avaliaComissao(UnidadeFatCliente unid, Representante rep, Produto produto, Date dataEmissao, CondicoesPagamento condicoesPagamento, TipoFrete tipoFrete, Empresa empresa, Double valorUnitario, Double valorMin, Double valorMax, Double percComissao, Double percDesconto, Integer nrDiasMedios, NaturezaOperacao natOP, Usuario usuario, Grupo grupo, String formatoPesqTabDin, TabelaPrecosDinamica tabelaPrecosDinamica) throws ExceptionAvaliadorExpressoes, ExceptionTabelaPrecosDinamica {
        TabelaPrecosDinamicaCond aval = this.getCondicao(unid, empresa, rep, produto, formatoPesqTabDin, tabelaPrecosDinamica);
        if (aval.getAvaliadorExpressoesComissao() != null) {
            TabelaPrecoBaseProduto tbp = this.getTabelaPrecoBaseProd(aval, produto, false);
            Map values = this.buildMap(unid, rep, produto, condicoesPagamento, tbp, tipoFrete, empresa, natOP, usuario, grupo);
            values.put(tbp.getClass().getCanonicalName(), tbp);
            values.put("pre_valor_minimo_calc_ped", valorMin);
            values.put("pre_valor_maximo_calc_ped", valorMax);
            values.put("pre_valor_unitario_inf", valorUnitario);
            values.put("pre_perc_desconto_inf", percDesconto);
            values.put("pre_nr_dias_medios_cond_pag", nrDiasMedios);
            DTOResultCalcExpressoes res = ToolAvaliadorExpressoes.processAndValidateValue((DTOAvaliadorExpressoes)this.toDTO(aval.getAvaliadorExpressoesComissao()), (Map)values);
            if (res != null) {
                TempPesquisaProduto c = new TempPesquisaProduto();
                c.setAvaliadorExpressoesComissao(aval.getAvaliadorExpressoes());
                c.setPercComissao(res.getResultado());
                c.setPercComissaoMax(tbp.getPercMaximo());
                c.setPercComissaoMin(tbp.getPercMinimo());
                return c;
            }
        }
        return new TempPesquisaProduto();
    }

    private Map buildMap(UnidadeFatCliente unidadeFatCliente, Representante representante, Produto produto, CondicoesPagamento condicoesPagamento, TabelaPrecoBaseProduto tabPrecoBaseProduto, TipoFrete tipoFrete, Empresa empresa, NaturezaOperacao naturezaOperacao, Usuario usuario, Grupo grupo) {
        HashMap<String, Serializable> m = new HashMap<String, Serializable>();
        if (naturezaOperacao != null) {
            m.put(NaturezaOperacao.class.getCanonicalName(), naturezaOperacao);
        }
        if (unidadeFatCliente != null) {
            m.put(UnidadeFatCliente.class.getCanonicalName(), unidadeFatCliente);
        }
        if (representante != null) {
            m.put(Representante.class.getCanonicalName(), representante);
        }
        if (produto != null) {
            m.put(Produto.class.getCanonicalName(), produto);
        }
        if (condicoesPagamento != null) {
            m.put(CondicoesPagamento.class.getCanonicalName(), condicoesPagamento);
        }
        if (tipoFrete != null) {
            m.put(TipoFrete.class.getCanonicalName(), tipoFrete);
        }
        if (empresa != null) {
            m.put(Empresa.class.getCanonicalName(), empresa);
        }
        if (tabPrecoBaseProduto != null) {
            m.put(TabelaPrecoBaseProduto.class.getCanonicalName(), tabPrecoBaseProduto);
        }
        if (usuario != null) {
            m.put(Usuario.class.getCanonicalName(), usuario);
        }
        if (usuario != null) {
            m.put(Grupo.class.getCanonicalName(), grupo);
        }
        return m;
    }

    private DTOAvaliadorExpressoes toDTO(AvaliadorExpressoes avaliadorExpressoes) {
        DTOAvaliadorExpressoes dto = new DTOAvaliadorExpressoes();
        dto.setDescricao(avaliadorExpressoes.getDescricao());
        dto.setIdentificador(avaliadorExpressoes.getIdentificador());
        avaliadorExpressoes.getConstVariaveis().forEach(i -> {
            DTOAvaliadorExpressoes.DTOExpressoesConstants constante = new DTOAvaliadorExpressoes.DTOExpressoesConstants();
            constante.setClazz(i.getClazz());
            constante.setDescClazz(i.getDescClazz());
            constante.setDescField(i.getDescField());
            constante.setField(i.getField());
            constante.setNome(i.getNome());
            constante.setTipo(EnumConstTipoAvaliador.get((Object)i.getTipo()));
            constante.setValor(i.getValor());
            dto.getConstVariaveis().add(constante);
        });
        avaliadorExpressoes.getFormulas().forEach(i -> {
            DTOAvaliadorExpressoes.DTOFormula f = new DTOAvaliadorExpressoes.DTOFormula();
            f.setCondicao(i.getCondAplicacao());
            f.setIdentificador(i.getIdentificador());
            f.setFormula(i.getFormula());
            f.setAtivo(i.getAtivo());
            dto.getFormulas().add(f);
        });
        avaliadorExpressoes.getPreFormulas().forEach(i -> {
            DTOAvaliadorExpressoes.DTOPreFormula p = new DTOAvaliadorExpressoes.DTOPreFormula();
            p.setChave(i.getChave());
            p.setFormula(i.getFormula());
            p.setObservacao(i.getObservacao());
            dto.getPreFormulas().add(p);
        });
        if (avaliadorExpressoes.getAvaliadorExpTabExp() != null) {
            avaliadorExpressoes.getAvaliadorExpTabExp().getValores().forEach(i -> {
                DTOAvaliadorExpressoes.DTOTabelaVariaveis d = new DTOAvaliadorExpressoes.DTOTabelaVariaveis();
                d.setToken(i.getToken());
                d.setChave(i.getChaveNFCe());
                d.setClazz(i.getClazzNFCe());
                d.setUsarReflection(EnumConstReflection.get((Object)i.getUsarReflection()));
                dto.getTabelaVariaveis().add(d);
            });
        }
        return dto;
    }

    private Integer calculaCond(CondicoesPagamento cond) {
        if (cond == null) {
            return 0;
        }
        return ToolCalculos.calcularNrDiasMediosCondPag((EnumConstantsSimNao)EnumConstantsSimNao.get((Object)cond.getEntrada()), (int)cond.getNumeroParcelas(), (int)cond.getNumeroDiasVencimento());
    }

    private void setFirstGradeCor(Produto produto, TempPesquisaProduto val, Boolean geraExcecao) throws ExceptionTabelaPrecosDinamica {
        ServiceGradeCor service = Main.getBean(ServiceGradeCor.class);
        GradeCor gc = service.getFirstAtiva(produto);
        if (gc == null && geraExcecao.booleanValue()) {
            throw new ExceptionTabelaPrecosDinamica("Produto sem grades. Id Produto: " + produto.getIdentificador());
        }
        if (gc == null && !geraExcecao.booleanValue()) {
            return;
        }
        val.setIdGradeCor(gc.getIdentificador());
    }

    public TempPesquisaProduto getComissaoProdutos(Empresa empresa, Produto produto, UnidadeFatCliente unid, Representante rep, Usuario usuario, Grupo grupo, TipoFrete tipoFrete, NaturezaOperacao natOP, CondicoesPagamento condicoesPagamento, NFCeOpcoes opcoes) throws ExceptionTabelaPrecosDinamica, ExceptionAvaliadorExpressoes {
        boolean geraExcecao = false;
        TabelaPrecosDinamicaCond aval = this.getCondicao(unid, empresa, rep, produto, opcoes.getFormatoPesquisaTabDinamica(), opcoes.getTabelaPrecosDinamica());
        TabelaPrecoBaseProduto tbp = this.getTabelaPrecoBaseProd(aval, produto, geraExcecao);
        TempPesquisaProduto val = this.avaliaComissao(unid, rep, produto, new Date(), condicoesPagamento, tipoFrete, empresa, 0.0, 0.0, 0.0, tbp.getPercComissaoPadrao(), 0.0, 0, natOP, usuario, grupo, opcoes.getFormatoPesquisaTabDinamica(), opcoes.getTabelaPrecosDinamica());
        return val;
    }
}

