/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.model;

import com.touchcomp.basementor.constants.enums.EnumConstAbertoFechado;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import com.touchcomp.touchnfce.model.NFCeCaixa;
import com.touchcomp.touchnfce.model.NFCeControleCaixaRes;
import com.touchcomp.touchnfce.model.NFCeMovimentoCaixa;
import com.touchcomp.touchnfce.model.Usuario;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import lombok.Generated;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

@Entity
@Table(name="nfce_controle_caixa", uniqueConstraints={@UniqueConstraint(name="UK_NFCE_CONT_C_SERIAL_FOR_SINC", columnNames={"serial_for_sinc"})})
public class NFCeControleCaixa
implements Serializable {
    @Id
    @Column(name="ID_nfce_controle_caixa")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(sequenceName="GEN_NFCE_CONTROLE_CAIXA", name="sequence")
    private Long identificador;
    @ManyToOne
    @JoinColumn(name="id_nfce_caixa", updatable=false, foreignKey=@ForeignKey(name="FK_NFCE_CONT_CX_NFCE_CX"))
    private NFCeCaixa nFCeCaixa;
    @ManyToOne(cascade={CascadeType.MERGE})
    @JoinColumn(name="id_usuario", updatable=false, foreignKey=@ForeignKey(name="FK_NFCE_CONT_CX_USUARIO"))
    private Usuario usuario;
    @Column(name="status", nullable=false)
    private Short status;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ABERTURA", nullable=false)
    private Date dataAbertura = new Date();
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_FECHAMENTO")
    private Date dataFechamento;
    @Column(name="VALOR_TOTAL_SISTEMA", nullable=false)
    private Double valorTotalSistema;
    @Column(name="VALOR_TOTAL_SISTEMA_DINH", nullable=false)
    private Double valorTotalSistemaDinh;
    @Column(name="VALOR_TOTAL_INFORMADO_DINH", nullable=false)
    private Double valorTotalInformadoDinh;
    @Column(name="VALOR_TOTAL_INFORMADO_DIF_DINH", nullable=false)
    private Double valorTotalInformadoDifDinh;
    @Column(name="VALOR_REMASCENTE_CAIXA_DINH", nullable=false)
    private Double valorRemanescenteCaixaDinh;
    @Column(name="VALOR_SAIDA_CAIXA_FECHAMENTO", nullable=false)
    private Double valorSaidaCaixaFechamento;
    @Column(name="VALOR_REMASCENTE_CAIXA_ANT", nullable=false)
    private Double valorRemanescenteCaixaAnterior;
    @Column(name="VALOR_TOTAL_ENTRADAS_MOV", nullable=false)
    private Double valorTotalEntradasMov;
    @Column(name="VALOR_TOTAL_SAIDAS_MOV", nullable=false)
    private Double valorTotalSaidasMov;
    @Column(name="REALIZADO", nullable=false)
    private Short realizado;
    @OneToMany(mappedBy="nfCeControleCaixa", cascade={CascadeType.ALL}, orphanRemoval=true)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private List<NFCeControleCaixaRes> resumoRecebimentos;
    @Column(name="serial_for_sinc", nullable=false, length=100)
    private String serialForSinc;
    @Version
    @Column(name="data_atualizacao")
    private Timestamp dataAtualizacao;
    @Column(name="identificador_erp")
    private Long identificadorERP;
    @Column(name="status_sinc_erp")
    private Short statusSincERP;
    @OneToOne(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="ID_NFCE_MOV_CAIXA_ABERTURA", foreignKey=@ForeignKey(name="FK_NFCE_CONT_CX_MOV_CX_ABERTURA"))
    private NFCeMovimentoCaixa nFCeMovCaixaAbertura;

    public NFCeControleCaixa() {
        this.status = EnumConstAbertoFechado.ABERTO.value;
        this.valorSaidaCaixaFechamento = 0.0;
        this.valorTotalSistema = 0.0;
        this.valorTotalSistemaDinh = 0.0;
        this.valorTotalInformadoDinh = 0.0;
        this.valorTotalInformadoDifDinh = 0.0;
        this.valorRemanescenteCaixaDinh = 0.0;
        this.valorRemanescenteCaixaAnterior = 0.0;
        this.valorTotalEntradasMov = 0.0;
        this.valorTotalSistema = 0.0;
        this.valorTotalSaidasMov = 0.0;
        this.realizado = 0;
        this.statusSincERP = 0;
        this.resumoRecebimentos = new LinkedList<NFCeControleCaixaRes>();
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} / {1}: {2}", (Object[])new Object[]{ToolDate.dateToStr((Date)this.getDataAbertura(), (String)"dd/MM/yyyy hh:mm"), this.getDataFechamento() != null ? ToolDate.dateToStr((Date)this.getDataFechamento(), (String)"dd/MM/yyyy hh:mm") : "Aberto", this.getUsuario()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public NFCeCaixa getNFCeCaixa() {
        return this.nFCeCaixa;
    }

    @Generated
    public Usuario getUsuario() {
        return this.usuario;
    }

    @Generated
    public Short getStatus() {
        return this.status;
    }

    @Generated
    public Date getDataAbertura() {
        return this.dataAbertura;
    }

    @Generated
    public Date getDataFechamento() {
        return this.dataFechamento;
    }

    @Generated
    public Double getValorTotalSistema() {
        return this.valorTotalSistema;
    }

    @Generated
    public Double getValorTotalSistemaDinh() {
        return this.valorTotalSistemaDinh;
    }

    @Generated
    public Double getValorTotalInformadoDinh() {
        return this.valorTotalInformadoDinh;
    }

    @Generated
    public Double getValorTotalInformadoDifDinh() {
        return this.valorTotalInformadoDifDinh;
    }

    @Generated
    public Double getValorRemanescenteCaixaDinh() {
        return this.valorRemanescenteCaixaDinh;
    }

    @Generated
    public Double getValorSaidaCaixaFechamento() {
        return this.valorSaidaCaixaFechamento;
    }

    @Generated
    public Double getValorRemanescenteCaixaAnterior() {
        return this.valorRemanescenteCaixaAnterior;
    }

    @Generated
    public Double getValorTotalEntradasMov() {
        return this.valorTotalEntradasMov;
    }

    @Generated
    public Double getValorTotalSaidasMov() {
        return this.valorTotalSaidasMov;
    }

    @Generated
    public Short getRealizado() {
        return this.realizado;
    }

    @Generated
    public List<NFCeControleCaixaRes> getResumoRecebimentos() {
        return this.resumoRecebimentos;
    }

    @Generated
    public String getSerialForSinc() {
        return this.serialForSinc;
    }

    @Generated
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public Long getIdentificadorERP() {
        return this.identificadorERP;
    }

    @Generated
    public Short getStatusSincERP() {
        return this.statusSincERP;
    }

    @Generated
    public NFCeMovimentoCaixa getNFCeMovCaixaAbertura() {
        return this.nFCeMovCaixaAbertura;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setNFCeCaixa(NFCeCaixa nFCeCaixa) {
        this.nFCeCaixa = nFCeCaixa;
    }

    @Generated
    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setStatus(Short status) {
        this.status = status;
    }

    @Generated
    public void setDataAbertura(Date dataAbertura) {
        this.dataAbertura = dataAbertura;
    }

    @Generated
    public void setDataFechamento(Date dataFechamento) {
        this.dataFechamento = dataFechamento;
    }

    @Generated
    public void setValorTotalSistema(Double valorTotalSistema) {
        this.valorTotalSistema = valorTotalSistema;
    }

    @Generated
    public void setValorTotalSistemaDinh(Double valorTotalSistemaDinh) {
        this.valorTotalSistemaDinh = valorTotalSistemaDinh;
    }

    @Generated
    public void setValorTotalInformadoDinh(Double valorTotalInformadoDinh) {
        this.valorTotalInformadoDinh = valorTotalInformadoDinh;
    }

    @Generated
    public void setValorTotalInformadoDifDinh(Double valorTotalInformadoDifDinh) {
        this.valorTotalInformadoDifDinh = valorTotalInformadoDifDinh;
    }

    @Generated
    public void setValorRemanescenteCaixaDinh(Double valorRemanescenteCaixaDinh) {
        this.valorRemanescenteCaixaDinh = valorRemanescenteCaixaDinh;
    }

    @Generated
    public void setValorSaidaCaixaFechamento(Double valorSaidaCaixaFechamento) {
        this.valorSaidaCaixaFechamento = valorSaidaCaixaFechamento;
    }

    @Generated
    public void setValorRemanescenteCaixaAnterior(Double valorRemanescenteCaixaAnterior) {
        this.valorRemanescenteCaixaAnterior = valorRemanescenteCaixaAnterior;
    }

    @Generated
    public void setValorTotalEntradasMov(Double valorTotalEntradasMov) {
        this.valorTotalEntradasMov = valorTotalEntradasMov;
    }

    @Generated
    public void setValorTotalSaidasMov(Double valorTotalSaidasMov) {
        this.valorTotalSaidasMov = valorTotalSaidasMov;
    }

    @Generated
    public void setRealizado(Short realizado) {
        this.realizado = realizado;
    }

    @Generated
    public void setResumoRecebimentos(List<NFCeControleCaixaRes> resumoRecebimentos) {
        this.resumoRecebimentos = resumoRecebimentos;
    }

    @Generated
    public void setSerialForSinc(String serialForSinc) {
        this.serialForSinc = serialForSinc;
    }

    @Generated
    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setIdentificadorERP(Long identificadorERP) {
        this.identificadorERP = identificadorERP;
    }

    @Generated
    public void setStatusSincERP(Short statusSincERP) {
        this.statusSincERP = statusSincERP;
    }

    @Generated
    public void setNFCeMovCaixaAbertura(NFCeMovimentoCaixa nFCeMovCaixaAbertura) {
        this.nFCeMovCaixaAbertura = nFCeMovCaixaAbertura;
    }
}

