/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.scheduler;

import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorexceptions.exceptions.impl.zip.ExceptionZip;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.properties.PropertiesBD;
import com.touchcomp.touchnfce.sinc.receive.SincFactory;
import com.touchcomp.touchnfce.sinc.receive.SincParams;
import java.awt.TrayIcon;
import java.io.FileNotFoundException;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

@DisallowConcurrentExecution
public class SincRecTask
implements StatefulJob {
    public static String TASK_NAME = "task_receive_data";

    public synchronized void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        String sincData = PropertiesBD.get().getSincData();
        if (ToolMethods.isStrWithData((String)sincData) && !ToolMethods.isAffirmative((Number)Short.valueOf(sincData))) {
            return;
        }
        if (StaticObjects.getDadosSincronizacao().getAppConfigurado() == 1 && StaticObjects.getDadosSincronizacao().getSincronizadoCompeletamente() == 1) {
            SincParams params = new SincParams(StaticObjects.getDadosSincronizacao());
            try {
                SincFactory.getInstance().startSincRecebimento(params);
            }
            catch (ExceptionDecodeHexString64 | ExceptionIO | ExceptionReflection | ExceptionWebService | ExceptionZip exceptionIO) {
                exceptionIO.printStackTrace();
                Main.get().showMessage("Erro", "Ocorreu um erro ao buscar as informa\u00e7\u00f5es no servidor", TrayIcon.MessageType.ERROR);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                Main.get().showMessage("Erro", "Ocorreu um erro ao buscar as informa\u00e7\u00f5es no servidor", TrayIcon.MessageType.ERROR);
            }
            catch (ExceptionCertificado exceptionCertificado) {
                exceptionCertificado.printStackTrace();
                Main.get().showMessage("Erro", "Ocorreu um erro ao buscar as informa\u00e7\u00f5es no servidor", TrayIcon.MessageType.ERROR);
            }
            catch (Throwable exceptionCertificado) {
                exceptionCertificado.printStackTrace();
                Main.get().showMessage("Erro", "Ocorreu um erro ao buscar as informa\u00e7\u00f5es no servidor", TrayIcon.MessageType.ERROR);
            }
        }
    }
}

