/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.service.impl;

import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.model.BicoBombaCombustivel;
import com.touchcomp.touchnfce.model.NFCeControleCaixa;
import com.touchcomp.touchnfce.model.NFCeEncerranteAbastecimento;
import com.touchcomp.touchnfce.repo.RepoBaseJPA;
import com.touchcomp.touchnfce.repo.impl.RepoNFCeEncerranteAbastecimento;
import com.touchcomp.touchnfce.service.ServiceSincEntityAPI;
import com.touchcomp.touchvomodel.webservices.PackObjectsSinc;
import java.util.Date;
import java.util.List;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ServiceNFCeEncerranteAbastecimento
extends ServiceSincEntityAPI<NFCeEncerranteAbastecimento, Long> {
    public ServiceNFCeEncerranteAbastecimento(RepoBaseJPA<NFCeEncerranteAbastecimento, Long> repository) {
        super(repository);
    }

    @Override
    public RepoNFCeEncerranteAbastecimento getRepository() {
        return (RepoNFCeEncerranteAbastecimento)super.getRepository();
    }

    @Override
    public Long getCountForSinc(Date dataUltSinc) {
        return this.getRepository().getCountForSinc(dataUltSinc);
    }

    @Override
    public void saveSinc(List<NFCeEncerranteAbastecimento> data, List<PackObjectsSinc> res) {
        for (PackObjectsSinc p : res) {
            this.getRepository().updateSinc(p.getIdObjectMentor(), p.getStatus(), p.getSerialObjetoOrigem());
        }
    }

    @Override
    public List<NFCeEncerranteAbastecimento> getAllForSincZip(Date lastSinc, int atualPage, int regPerTime) {
        return this.getRepository().getForSinc(lastSinc, (Pageable)PageRequest.of((int)atualPage, (int)regPerTime));
    }

    public List<NFCeEncerranteAbastecimento> getEncerrantesAbastecimentoByControleCaixa(NFCeControleCaixa controleCaixa, short status) {
        return this.getRepository().getEncerrantesAbastecimentoByControleCaixa(controleCaixa, status);
    }

    public NFCeEncerranteAbastecimento getUltimoEncerrante(BicoBombaCombustivel bico) {
        List<NFCeEncerranteAbastecimento> ret = this.getRepository().getUltimoEncerrante(bico, (Pageable)PageRequest.of((int)0, (int)1));
        if (ToolMethods.isWithData(ret)) {
            return ret.get(0);
        }
        return null;
    }
}

