/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.service.impl;

import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.model.Pedido;
import com.touchcomp.touchnfce.repo.impl.pedido.RepoPedido;
import com.touchcomp.touchnfce.service.ServiceSincEntityAPI;
import com.touchcomp.touchvomodel.webservices.PackObjectsSinc;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ServicePedidoEnv
extends ServiceSincEntityAPI<Pedido, Long> {
    public ServicePedidoEnv(RepoPedido repository) {
        super(repository);
    }

    @Override
    public RepoPedido getRepository() {
        return (RepoPedido)super.getRepository();
    }

    @Override
    public Long getCountForSinc(Date dataUltSinc) {
        return this.getRepository().getCountForSinc(dataUltSinc);
    }

    @Override
    public void saveSinc(List<Pedido> data, List<PackObjectsSinc> res) {
        for (PackObjectsSinc p : res) {
            Optional<Pedido> found = data.stream().filter(i -> ToolMethods.isEquals((Object)i.getSerialForSync(), (Object)p.getSerialObjetoOrigem())).findFirst();
            if (found.isPresent()) {
                found.get().setIdentificadorERP(p.getIdObjectMentor());
            }
            this.getRepository().updateSinc(p.getIdObjectMentor(), p.getStatus(), p.getSerialObjetoOrigem());
        }
    }

    @Override
    public List<Pedido> getAllForSincZip(Date lastSinc, int atualPage, int regPerTime) {
        return this.getRepository().getForSinc(lastSinc, (Pageable)PageRequest.of((int)atualPage, (int)regPerTime));
    }

    @Override
    public void delete(Pedido entity) {
    }

    @Override
    public void deleteAll(Iterable<Pedido> entities) {
    }

    @Override
    public void deleteById(Long id) {
    }

    public Pedido getPedidoAbertoNaoSincronizado() {
        List<Pedido> listPedidos = this.getRepository().getPedidoNaoSincronizado((short)0);
        if (listPedidos == null || listPedidos.isEmpty()) {
            return null;
        }
        return listPedidos.get(0);
    }

    public void updatePedidoEnv(Long identificadorERP, String serialObjetoOrigem) {
        this.getRepository().updateSinc(identificadorERP, serialObjetoOrigem);
    }
}

