/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.tasks.utils;

import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvio;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoEmissao;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoPagNFe;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultanota.ConsultaNFeRet;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultanota.NFeConsultaNota;
import com.touchcomp.basementorclientwebservices.nfe.model.env.lotefat.NFeLoteFaturamento;
import com.touchcomp.basementorclientwebservices.nfe.model.ret.NFeEnviaEventoRet;
import com.touchcomp.basementorclientwebservices.nfe.model.ret.lotefat.NFeLoteDadosRet;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementorexceptions.exceptions.impl.print.ExceptionPrint;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.constants.ConstantsNFCe;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeEventoEpec;
import com.touchcomp.touchnfce.model.NFCeLoteNotas;
import com.touchcomp.touchnfce.model.NFCeOpcoes;
import com.touchcomp.touchnfce.model.NFCePagamento;
import com.touchcomp.touchnfce.model.TipoEmissaoNFe;
import com.touchcomp.touchnfce.nfe.AuxEnviaNota;
import com.touchcomp.touchnfce.nfe.impl.versoes.ConfigCertificate;
import com.touchcomp.touchnfce.nfe.impl.versoes.ConstNFeVersoes;
import com.touchcomp.touchnfce.nfe.impl.versoes.UtilNfeSendWebServices;
import com.touchcomp.touchnfce.print.impl.PrintComprovantePIX;
import com.touchcomp.touchnfce.print.impl.PrintComprovanteTEF;
import com.touchcomp.touchnfce.print.impl.PrintDanfce;
import com.touchcomp.touchnfce.print.impl.PrintDanfe;
import com.touchcomp.touchnfce.print.impl.PrintDuplicataDuasVias;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeEventoEpec;
import com.touchcomp.touchnfce.service.impl.ServiceTipoEmissaoNFe;
import com.touchcomp.touchnfce.tasks.utils.UtilConsultaStatusNFCe;
import com.touchcomp.touchnfce.tasks.utils.UtilEmail;
import com.touchcomp.touchnfce.tasks.utils.UtilXMLFile;
import com.touchcomp.touchnfce.utils.UtilCronoanalise;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import java.sql.Date;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;

public class UtilEnviaNFCeWebService {
    private static String DIR_AUTORIZACAO = "autorizadas";
    private static String DIR_EVENTO_EPEC = "evento_epec";

    public static NFCe execute(NFCe nfce) throws Exception {
        UtilCronoanalise.addTask("Envio normal NFCe");
        if (nfce.getInutilizacaoNFe() != null) {
            throw new Exception("NFCe nao pode ser enviada, pois ja possui uma inutilizacao vinculada " + String.valueOf(nfce));
        }
        if (nfce.getNfCeCancelamento() != null) {
            throw new Exception("NFCe nao pode ser enviada, pois ja possui um cancelamento vinculado " + String.valueOf(nfce));
        }
        nfce.setStatus(EnumConstNFeStatus.NFCE_CRIADA_ENVIADA_SEM_RET.getValue());
        nfce.setMotivo(EnumConstNFeStatus.NFCE_CRIADA_ENVIADA_SEM_RET.getDescricao());
        try {
            TipoEmissaoNFe tipoEmissao;
            TipoEmissaoNFe tipoEmissaoNFe = tipoEmissao = nfce.getPeriodoEmissaoNFCe() != null ? nfce.getPeriodoEmissaoNFCe().getTipoEmissaoNfe() : nfce.getPeriodoEmissaoNFe().getTipoEmissaoNfe();
            if (ToolMethods.isEquals((Object)tipoEmissao.getCodigo(), (Object)EnumConstNFeTipoEmissao.CONTIGENCIA_OFFLINE.getValue())) {
                UtilEnviaNFCeWebService.emissaoContigenciaNFCe(nfce);
            } else if (ToolMethods.isEquals((Object)tipoEmissao.getCodigo(), (Object)EnumConstNFeTipoEmissao.CONTIGENCIA_SVCAN.getValue()) || ToolMethods.isEquals((Object)tipoEmissao.getCodigo(), (Object)EnumConstNFeTipoEmissao.CONTIGENCIA_SVCRS.getValue()) || ToolMethods.isEquals((Object)tipoEmissao.getCodigo(), (Object)EnumConstNFeTipoEmissao.CONTIGENCIA_SCAN.getValue())) {
                UtilEnviaNFCeWebService.emissaoNormal(nfce);
            } else if (ToolMethods.isEquals((Object)tipoEmissao.getCodigo(), (Object)EnumConstNFeTipoEmissao.CONTIGENCIA_EPEC_EVENTO_EPEC.getValue())) {
                UtilEnviaNFCeWebService.emissaoContigenciaEPEC(nfce);
            } else {
                UtilEnviaNFCeWebService.emissaoNormal(nfce);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        UtilCronoanalise.addTask("Salva NFCe p\u00f3s envio");
        return UtilNFCe.save(nfce);
    }

    private static void emissaoContigenciaNFCe(NFCe nfce) throws Exception {
        NFCeOpcoes opcoes = StaticObjects.getOpcoes();
        Empresa empresa = nfce.getEmpresa();
        ConfigCertificate config = new ConfigCertificate(empresa.getPessoa().getEndereco().getCidade().getUf(), opcoes, UtilNFCe.getTipoEmissaoNFe(nfce));
        NFeLoteFaturamento lt = new AuxEnviaNota(StaticObjects.getOpcoes()).criarNotaEnvio(nfce.getLoteNotas());
        nfce.setStatus(EnumConstNFeStatus.NFCE_CRIADA_CONTIGENCIA_SEM_ENVIO.getValue());
        nfce.setMotivo(EnumConstNFeStatus.NFCE_CRIADA_CONTIGENCIA_SEM_ENVIO.getDescricao());
        NFLoteEnvio loteEnvio = UtilNfeSendWebServices.getLoteAssinado(config, ConstNFeVersoes.VERSAO_20180005_1_20, lt);
        UtilEnviaNFCeWebService.setXMLNFCe(loteEnvio.getNotas(), nfce);
    }

    private static void emissaoNormal(NFCe nfce) throws Exception {
        NFeLoteFaturamento lt;
        NFCeOpcoes opcoes = StaticObjects.getOpcoes();
        Empresa empresa = nfce.getEmpresa();
        ConfigCertificate config = new ConfigCertificate(empresa.getPessoa().getEndereco().getCidade().getUf(), opcoes, UtilNFCe.getTipoEmissaoNFe(nfce));
        NFeLoteDadosRet stat = UtilNfeSendWebServices.enviarNota(config, ConstNFeVersoes.VERSAO_20180005_1_20, lt = new AuxEnviaNota(opcoes).criarNotaEnvio(nfce.getLoteNotas()));
        if (stat.getRetorno() != null) {
            nfce.getLoteNotas().setNumeroProtocolo(stat.getRetorno().getProtocoloRecebimentoSincrono());
            nfce.getLoteNotas().setStatus(new Short(stat.getRetorno().getStatus()));
            nfce.getLoteNotas().setRetorno(stat.getRetorno().getMotivo());
            if (stat.getRetorno().getProtocoloInfo() != null) {
                nfce.setStatus(Integer.valueOf(stat.getRetorno().getProtocoloInfo().getStatus()));
                nfce.setMotivo(stat.getRetorno().getProtocoloInfo().getMotivo());
                nfce.setTipoAmbiente(Integer.valueOf(stat.getRetorno().getProtocoloInfo().getAmbiente().getCodigo()));
                nfce.setNrProtocolo(stat.getRetorno().getProtocoloInfo().getNumeroProtocolo());
                LocalDateTime dataRec = stat.getRetorno().getProtocoloInfo().getDataRecebimento();
                nfce.setDataAutorizacao(Date.from(dataRec.atZone(ZoneId.systemDefault()).toInstant()));
                if (stat.getRetorno() != null && stat.getRetorno().getProtocoloInfo() != null && stat.getRetorno().getProtocoloInfo().getXmlAutorizacao() != null) {
                    nfce.setXmlAutorizacao(stat.getRetorno().getProtocoloInfo().getXmlAutorizacao().getBytes());
                }
            }
        }
        List notas = stat.getLoteAssinado().getNotas();
        UtilEnviaNFCeWebService.setXMLNFCe(notas, nfce);
        UtilEnviaNFCeWebService.setXMLAutorizacao(stat.getRetorno(), nfce);
        UtilEnviaNFCeWebService.enviarPorEmail(nfce);
    }

    private static void enviarPorEmail(final NFCe nfce) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    UtilEmail.enviaNFePorEmail(nfce, StaticObjects.getOpcoes(), false);
                }
                catch (Exception e) {
                    TLogger.get(UtilEnviaNFCeWebService.class).error((Throwable)e);
                }
            }
        });
    }

    private static void setXMLAutorizacao(NFeLoteDadosRet.NFeLoteEnvioRetorno retorno, NFCe nfce) {
        if (retorno == null || retorno.getProtocoloInfo() == null || retorno.getProtocoloInfo().getXmlAutorizacao() == null) {
            return;
        }
        nfce.setXmlAutorizacao(retorno.getProtocoloInfo().getXmlAutorizacao().getBytes(ConstantsNFCe.CHARSET_ISO_8889));
    }

    private static void emissaoContigenciaEPEC(NFCe nfce) throws Exception {
        NFCeOpcoes opcoes = StaticObjects.getOpcoes();
        Empresa empresa = nfce.getEmpresa();
        ConfigCertificate config = new ConfigCertificate(empresa.getPessoa().getEndereco().getCidade().getUf(), opcoes, UtilNFCe.getTipoEmissaoNFe(nfce));
        NFeLoteFaturamento lt = new AuxEnviaNota(opcoes).criarNotaEnvio(nfce.getLoteNotas());
        NFeEnviaEventoRet ret = UtilNfeSendWebServices.enviarNotaEPEC(config, ConstNFeVersoes.VERSAO_20180005_1_20, lt);
        NFLoteEnvio loteEnvio = UtilNfeSendWebServices.getLoteAssinado(config, ConstNFeVersoes.VERSAO_20180005_1_20, lt);
        UtilEnviaNFCeWebService.setXMLEpecNFe(ret.getDetEventos(), nfce);
        UtilEnviaNFCeWebService.setXMLNFCe(loteEnvio.getNotas(), nfce);
    }

    private static void setXMLNFCe(List<NFNota> notas, NFCe nf) throws Exception {
        NFNota found = null;
        for (NFNota n : notas) {
            if (!n.getInfo().getIdentificador().equals("NFe" + nf.getChaveNFCe())) continue;
            found = n;
        }
        if (found != null) {
            NFNota nfNota = found;
            String data = nfNota.toString();
            UtilXMLFile.saveOnFile(data, DIR_AUTORIZACAO, nf.getChaveNFCe() + ".xml");
            nf.setXml(nfNota.toString().getBytes(ConstantsNFCe.CHARSET_ISO_8889));
            nf.setDigestValue(nfNota.getAssinatura().getSignedInfo().getReference().getDigestValue());
            if (nfNota.getInfoSuplementar() != null) {
                nf.setUrlQrCode(nfNota.getInfoSuplementar().getQrCode());
                nf.setUrlConsulta(nfNota.getInfoSuplementar().getUrlConsultaChaveAcesso());
            }
        } else {
            throw new ExceptionErroProgramacao("Ocorreu um erro ao comparar as notas enviadas com o retorno. Verifique a NF id " + nf.getIdentificador() + " Este problema pode gerar uma rejei\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo, reconstrua a nota.");
        }
    }

    public static NFCe criaLoteNotas(NFCe nfce) {
        NFCeLoteNotas lote = nfce.getLoteNotas();
        if (lote == null) {
            lote = new NFCeLoteNotas();
            lote.getNotas().add(StaticObjects.getNfceAberta());
            lote.setVersaoNFe(StaticObjects.getOpcoes().getVersaoNFe());
            lote.setTipoAmbiente(StaticObjects.getOpcoes().getTipoAmbiente());
            nfce.setLoteNotas(lote);
        }
        return nfce;
    }

    public static NFCe posEnvio(NFCe nfce) {
        if (!EnumConstNFeStatus.isStatusAutorizadaOuContigencia((Integer)nfce.getStatus()) || UtilEnviaNFCeWebService.isRejeicaoContingenciaEPEC(nfce)) {
            Alerts.showAlertInfo("Erro", "Ocorreu um problema ao enviar a NFCe:\n\n" + nfce.getStatus() + " - " + nfce.getMotivo(), "");
        } else {
            TipoEmissaoNFe tipoEmissao;
            TipoEmissaoNFe tipoEmissaoNFe = tipoEmissao = nfce.getPeriodoEmissaoNFCe() != null ? nfce.getPeriodoEmissaoNFCe().getTipoEmissaoNfe() : nfce.getPeriodoEmissaoNFe().getTipoEmissaoNfe();
            if (ToolMethods.isEquals((Object)tipoEmissao.getCodigo(), (Object)EnumConstNFeTipoEmissao.CONTIGENCIA_OFFLINE.getValue())) {
                UtilEnviaNFCeWebService.printDanfce(nfce, (short)0);
                UtilEnviaNFCeWebService.printDanfce(nfce, (short)1);
            } else if (ToolMethods.isEquals((Object)tipoEmissao.getCodigo(), (Object)EnumConstNFeTipoEmissao.CONTIGENCIA_EPEC_EVENTO_EPEC.getValue())) {
                UtilEnviaNFCeWebService.printDanfce(nfce, null);
            } else {
                UtilEnviaNFCeWebService.printDanfce(nfce, null);
            }
            UtilEnviaNFCeWebService.printComprovanteTEF(nfce);
            UtilEnviaNFCeWebService.printDuplicataDuasVias(nfce);
            UtilEnviaNFCeWebService.printComprovantePIX(nfce);
        }
        return nfce;
    }

    private static Short getTipoImpressao() {
        if (StaticObjects.getOpcoes().getTipoImpressaoDuplicata() == null) {
            return (short)0;
        }
        return StaticObjects.getOpcoes().getTipoImpressaoDuplicata();
    }

    private static void printDanfce(NFCe nfce, Short tipoVia) {
        try {
            if (ToolMethods.isEquals((Object)nfce.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
                new PrintDanfe().printDanfce(nfce, StaticObjects.getOpcoes().getNrImpressoesNFe());
            } else {
                new PrintDanfce().printDanfce(nfce, tipoVia, StaticObjects.getOpcoes().getNrImpressoesNFCe());
            }
        }
        catch (ExceptionJasperReports exceptionJasperReports) {
            Alerts.showAlertError("Erro", "Erro ao imprimir a NFCe:\n\n" + exceptionJasperReports.getMessage());
            exceptionJasperReports.printStackTrace();
        }
        catch (ExceptionPrint exceptionPrint) {
            Alerts.showAlertError("Erro", "Erro ao imprimir a NFCe:\n\n" + exceptionPrint.getMessage());
            exceptionPrint.printStackTrace();
        }
    }

    private static void printComprovanteTEF(NFCe nfce) {
        PrintComprovanteTEF p = new PrintComprovanteTEF();
        try {
            p.printTEF(nfce);
        }
        catch (ExceptionJasperReports exceptionJasperReports) {
            Alerts.showAlertError("Erro", "Erro ao imprimir o comprovante do Debito/Credito:\n\n" + exceptionJasperReports.getMessage());
            exceptionJasperReports.printStackTrace();
        }
        catch (ExceptionPrint exceptionPrint) {
            Alerts.showAlertError("Erro", "Erro ao imprimir o comprovante do Debito/Credito:\n\n" + exceptionPrint.getMessage());
            exceptionPrint.printStackTrace();
        }
    }

    private static void printDuplicataDuasVias(NFCe nfce) {
        if (nfce.getPagamentos() != null && !nfce.getPagamentos().isEmpty()) {
            ArrayList<NFCePagamento> listPagamentos = new ArrayList<NFCePagamento>();
            for (NFCePagamento p : nfce.getPagamentos()) {
                if (!p.getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.CREDITO_LOJA.getCodigo()) || !p.getStatus().equals((short)1)) continue;
                listPagamentos.add(p);
            }
            if (!listPagamentos.isEmpty()) {
                UtilEnviaNFCeWebService.imprimirDuplicataDuasVias(listPagamentos);
            }
        }
    }

    private static void imprimirDuplicataDuasVias(List<NFCePagamento> listPagamento) {
        try {
            new PrintDuplicataDuasVias().printDuplicataDuasVias(listPagamento, UtilEnviaNFCeWebService.getTipoImpressao());
        }
        catch (ExceptionJasperReports | ExceptionPrint ex) {
            ex.printStackTrace();
            Alerts.showAlertError("Erro", "Erro ao abrir a Duplicada:\n\n" + ex.getMessage());
        }
    }

    private static void setXMLEpecNFe(List<NFeEnviaEventoRet.NFEEnviaEventoRetDet> eventos, NFCe nfce) throws Exception {
        NFCeEventoEpec nfceEventoEpec = new NFCeEventoEpec();
        nfceEventoEpec.setNfce(nfce);
        nfce.setStatus(EnumConstNFeStatus.NFCE_CRIADA_CONTIGENCIA_SEM_ENVIO.getValue());
        nfce.setMotivo(EnumConstNFeStatus.NFCE_CRIADA_CONTIGENCIA_SEM_ENVIO.getDescricao());
        for (NFeEnviaEventoRet.NFEEnviaEventoRetDet nf : eventos) {
            Optional<NFeEnviaEventoRet.NFEEnviaEventoRetDet> found = eventos.stream().filter(i -> Objects.equals(nfceEventoEpec.getNfce().getChaveNFCe(), nf.getChave())).findFirst();
            if (found.isPresent()) {
                String data = found.get().toString();
                UtilXMLFile.saveOnFile(data, DIR_EVENTO_EPEC, nf.getChave() + ".xml");
                nfceEventoEpec.setXmlEpec(data.getBytes());
                nfceEventoEpec.setMotivo(nf.getMotivo());
                nfceEventoEpec.setStatus(nf.getCodigoStatus().shortValue());
                nfceEventoEpec.setNrProtocolo(nf.getNumeroProtocolo());
                nfceEventoEpec.setChave(nf.getChave());
                nfceEventoEpec.setDataHoraProt(nf.getDataHoraRegistro());
                ServiceNFCeEventoEpec seviceEpec = Main.getBean(ServiceNFCeEventoEpec.class);
                seviceEpec.save(nfceEventoEpec);
                continue;
            }
            throw new ExceptionErroProgramacao("Ocorreu um erro ao comparar as notas enviadas com o retorno. Verifique a NF id " + nfceEventoEpec.getNfce().getNumero());
        }
        nfce.setNfceEventoEpec(nfceEventoEpec);
    }

    private static boolean isRejeicaoContingenciaEPEC(NFCe nfce) {
        if (nfce.getNfceEventoEpec() != null && !ToolMethods.isEquals((Object)nfce.getNfceEventoEpec().getStatus().intValue(), (Object)EnumConstNFeStatus.EVENTO_REG_NAO_VINC_NFE.getValue())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void recuperarXmlNFCe(NFCe nfce) throws Exception {
        NFCeOpcoes opcoes = StaticObjects.getOpcoes();
        Empresa empresa = nfce.getEmpresa();
        ConfigCertificate config = new ConfigCertificate(empresa.getPessoa().getEndereco().getCidade().getUf(), opcoes, UtilNFCe.getTipoEmissaoNFe(nfce));
        NFeLoteFaturamento lt = new AuxEnviaNota(StaticObjects.getOpcoes()).criarNotaEnvio(nfce.getLoteNotas());
        NFLoteEnvio loteEnvio = UtilNfeSendWebServices.getLoteAssinado(config, ConstNFeVersoes.VERSAO_20180005_1_20, lt);
        UtilEnviaNFCeWebService.setXMLNFCe(loteEnvio.getNotas(), nfce);
    }

    public static void recuperarXmlNFCeAutorizacao(NFCe nfce) throws Exception {
        try {
            NFCeOpcoes opcoes = StaticObjects.getOpcoes();
            TipoEmissaoNFe tipoEmissaoNFe = Main.getBean(ServiceTipoEmissaoNFe.class).getTipoEmissaoNormal();
            Empresa empresa = nfce.getEmpresa();
            ConfigCertificate config = new ConfigCertificate(empresa.getPessoa().getEndereco().getCidade().getUf(), opcoes, tipoEmissaoNFe);
            NFeConsultaNota consultaNota = new NFeConsultaNota();
            consultaNota.setChaveNFe(nfce.getChaveNFCe());
            ConsultaNFeRet stat = UtilNfeSendWebServices.consultarNota(config, ConstNFeVersoes.VERSAO_20180005_1_20, consultaNota);
            if (stat.getProtocolo() != null) {
                nfce.setNrProtocolo(stat.getProtocolo().getNumeroProtocolo());
                LocalDateTime dataRec = stat.getProtocolo().getDataRecebimento();
                nfce.setDataAutorizacao(Date.from(dataRec.atZone(ZoneId.systemDefault()).toInstant()));
                if (stat.getProtocolo().getXml() != null && nfce.getXmlAutorizacao() == null && EnumConstNFeStatus.isStatusAutorizada((Integer)nfce.getStatus())) {
                    nfce.setXmlAutorizacao(stat.getProtocolo().getXml().getBytes());
                }
            }
        }
        catch (Throwable ex) {
            TLogger.get(UtilConsultaStatusNFCe.class).error(ex);
            throw ex;
        }
    }

    private static void printComprovantePIX(NFCe nfce) {
        PrintComprovantePIX p = new PrintComprovantePIX();
        try {
            p.printPIX(nfce);
        }
        catch (ExceptionJasperReports | ExceptionPrint exceptionJasperReports) {
            Alerts.showAlertError("Erro", "Erro ao imprimir o comprovante do Debito/Credito:\n\n" + exceptionJasperReports.getMessage());
            exceptionJasperReports.printStackTrace();
        }
    }
}

