/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.utils;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeFinalidadeEmissao;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorPresConsumidor;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoImpressao;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoPagNFe;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeVersao;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoipi.ExceptionImpostoIPI;
import com.touchcomp.basementorexceptions.exceptions.impl.impostopiscofins.ExceptionImpostoPisCofins;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorrules.exceptions.ExceptionImpostoCbsIbs;
import com.touchcomp.basementorrules.nfe.CompNFe;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.constants.EnumTipoPesqProduto;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.venda.auxmodelofiscal.AuxModeloFiscal;
import com.touchcomp.touchnfce.exceptions.ExceptionTabelaPrecosDinamica;
import com.touchcomp.touchnfce.helpers.impostos.cbs.params.SCompCBSParams;
import com.touchcomp.touchnfce.helpers.impostos.ibs.params.SCompIBSParams;
import com.touchcomp.touchnfce.helpers.preco.HelperPrecos;
import com.touchcomp.touchnfce.helpers.preco.tabpromocao.HelperPrecosTabPromocao;
import com.touchcomp.touchnfce.model.CentroEstoque;
import com.touchcomp.touchnfce.model.Cfop;
import com.touchcomp.touchnfce.model.Cidade;
import com.touchcomp.touchnfce.model.CodigoBarras;
import com.touchcomp.touchnfce.model.CondicoesPagamento;
import com.touchcomp.touchnfce.model.DadosGradeTransfCentroEstoque;
import com.touchcomp.touchnfce.model.DadosItemTransfCentroEstoque;
import com.touchcomp.touchnfce.model.DadosRecAgrNFCe;
import com.touchcomp.touchnfce.model.DadosRecAgrPedido;
import com.touchcomp.touchnfce.model.DadosTransfCentroEstoque;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.GradeCor;
import com.touchcomp.touchnfce.model.ICMSSTRetidoAntInfo;
import com.touchcomp.touchnfce.model.ModeloFiscal;
import com.touchcomp.touchnfce.model.ModeloFiscalIcms;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeCaixa;
import com.touchcomp.touchnfce.model.NFCeCancelamento;
import com.touchcomp.touchnfce.model.NFCeEnderecoEntrega;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeItemCbs;
import com.touchcomp.touchnfce.model.NFCeItemCofins;
import com.touchcomp.touchnfce.model.NFCeItemICMS;
import com.touchcomp.touchnfce.model.NFCeItemIbs;
import com.touchcomp.touchnfce.model.NFCeItemIpi;
import com.touchcomp.touchnfce.model.NFCeItemLote;
import com.touchcomp.touchnfce.model.NFCeItemPis;
import com.touchcomp.touchnfce.model.NFCeLoteNotas;
import com.touchcomp.touchnfce.model.NFCeOpcoes;
import com.touchcomp.touchnfce.model.NFCeOpcoesTipoPagNFe;
import com.touchcomp.touchnfce.model.NFCePagamento;
import com.touchcomp.touchnfce.model.NFCePeriodoEmissao;
import com.touchcomp.touchnfce.model.NFCePessoa;
import com.touchcomp.touchnfce.model.NFCeTotalizadores;
import com.touchcomp.touchnfce.model.NFCeTransp;
import com.touchcomp.touchnfce.model.NaturezaOperacao;
import com.touchcomp.touchnfce.model.Pedido;
import com.touchcomp.touchnfce.model.PrevImpostosNCM;
import com.touchcomp.touchnfce.model.Produto;
import com.touchcomp.touchnfce.model.Representante;
import com.touchcomp.touchnfce.model.SituacaoDocumento;
import com.touchcomp.touchnfce.model.TipoEmissaoNFe;
import com.touchcomp.touchnfce.model.TipoPagamentoNFe;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.model.UnidadeFederativa;
import com.touchcomp.touchnfce.model.Usuario;
import com.touchcomp.touchnfce.modeltemp.TempPesquisaProduto;
import com.touchcomp.touchnfce.properties.ConfPropertiesLoader;
import com.touchcomp.touchnfce.service.impl.ServiceICMSSTRetidoAntInfo;
import com.touchcomp.touchnfce.service.impl.ServiceNFCe;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeLoteNotas;
import com.touchcomp.touchnfce.service.impl.ServiceNaturezaOperacao;
import com.touchcomp.touchnfce.service.impl.ServicePrevImpostosNcm;
import com.touchcomp.touchnfce.service.impl.ServiceRepresentante;
import com.touchcomp.touchnfce.service.impl.ServiceSituacaoDocumento;
import com.touchcomp.touchnfce.service.impl.ServiceTabelaPrecoBaseProduto;
import com.touchcomp.touchnfce.utils.UtilClone;
import com.touchcomp.touchnfce.utils.UtilNFCeCalculos;
import com.touchcomp.touchnfce.utils.UtilNFCeSerial;
import com.touchcomp.touchnfce.utils.UtilPeriodoEmissao;
import com.touchcomp.touchnfce.utils.abastecimentocompanytec.UtilCentralAbastecimento;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class UtilNFCe {
    private static final ServiceNFCe serviceNFCe = Main.getBean(ServiceNFCe.class);
    private static final ServiceNFCeLoteNotas serviceNFCeLoteNotas = Main.getBean(ServiceNFCeLoteNotas.class);
    private static final ServiceSituacaoDocumento serviceSituacaoDocumento = Main.getBean(ServiceSituacaoDocumento.class);
    private static final ServiceRepresentante serviceRepresentante = Main.getBean(ServiceRepresentante.class);
    private static final ServicePrevImpostosNcm servicePrevImpostosNcm = Main.getBean(ServicePrevImpostosNcm.class);
    private static final ServiceNaturezaOperacao serviceNaturezaOperacao = Main.getBean(ServiceNaturezaOperacao.class);
    private static final ServiceTabelaPrecoBaseProduto serviceTabelaPrecoBaseProduto = Main.getBean(ServiceTabelaPrecoBaseProduto.class);

    public static NFCe createNFCeModelo65(UnidadeFatCliente u) {
        return UtilNFCe.getNewNFCe(UtilNFCe.getNaturezaOperacao(EnumConstantsModeloDocFiscal.NFCE_65.getCodigo()), u);
    }

    public static NFCe createNFCeModelo65(NaturezaOperacao nat, UnidadeFatCliente u) {
        return UtilNFCe.getNewNFCe(nat, u);
    }

    public static NFCe createNFCeModelo55(UnidadeFatCliente u) {
        return UtilNFCe.getNewNFCe(UtilNFCe.getNaturezaOperacao(EnumConstantsModeloDocFiscal.NFE_55.getCodigo()), u);
    }

    public static NFCe createNFCeModelo55(NFCePessoa u) {
        return UtilNFCe.getNewNFCe(UtilNFCe.getNaturezaOperacao(EnumConstantsModeloDocFiscal.NFE_55.getCodigo()), u);
    }

    public static NFCe getNewNFCe(NaturezaOperacao nat, UnidadeFatCliente u) {
        NFCe vo = UtilNFCe.criarNFCe();
        UtilNFCe.setUnidadeFatCliente(u, vo);
        return UtilNFCe.setOtherProps(vo, nat);
    }

    public static NFCe getNewNFCe(NaturezaOperacao nat, NFCePessoa u) {
        NFCe vo = UtilNFCe.criarNFCe();
        vo.setNfcePessoa(u);
        return UtilNFCe.setOtherProps(vo, nat);
    }

    public static NFCe setOtherProps(NFCe vo, NaturezaOperacao nat) {
        vo.setRepresentante(UtilNFCe.getRepresentanteToUser());
        if (vo.getObjObsGeralContrib() != null) {
            vo.setObsGeralContrib(vo.getObjObsGeralContrib().getObservacao());
        }
        if (vo.getObjObsGeralFisco() != null) {
            vo.setObsGeralFisco(vo.getObjObsGeralFisco().getObservacao());
        }
        NFCeTransp t = new NFCeTransp();
        t.setTipoFrete(StaticObjects.getOpcoes().getTipoFrete());
        vo.setDadosTransporte(t);
        NFCeTotalizadores totalizadores = new NFCeTotalizadores();
        totalizadores.setNFCe(vo);
        UtilNFCe.setAndUpdateNaturezaOperacaoNFCe(vo, nat);
        vo.setTotalizadores(totalizadores);
        UtilNFCe.defineEndEntregaPosto(vo);
        System.err.println(vo.getDataEmissao());
        return vo;
    }

    private static NFCe criarNFCe() {
        StaticObjects.checaExcluiNFCeTemp();
        NFCe nfce = new NFCe();
        nfce.setSituacaoDocumento(UtilNFCe.findSituacaoDocumentoRegular());
        nfce.setEmpresa(StaticObjects.getEmpresa());
        nfce.setDataEmissao(new Date());
        nfce.setIdentificadorCSCContribuinte(StaticObjects.getOpcoes().getIdentificadorCSCContrib());
        nfce.setCodigoCSCContribuinte(StaticObjects.getOpcoes().getCodigoCSCContrib());
        nfce.setIndicadorConsumidorFinal(EnumConstantsMentorSimNao.SIM.value);
        nfce.setIndicadorPresencaConsumidor(EnumConstNFeIndicadorPresConsumidor.OPERACAO_PRESENCIAL.getValue());
        nfce.setNfCeControleCaixa(StaticObjects.getControleCaixa());
        nfce.setNumeroRandomico(CompNFe.getCodNumericoAleatorio((EnumConstNFeVersao)EnumConstNFeVersao.VERSAO_4_00));
        nfce.setVersaoAplicativo(ConfPropertiesLoader.get().getVersaoApp());
        nfce.setVersaoNfe(StaticObjects.getOpcoes().getVersaoNFe());
        nfce.setSerialForSinc(UtilNFCeSerial.getSerial(StaticObjects.getNFCeCaixa()));
        nfce.setNfCeCaixa(StaticObjects.getNFCeCaixa());
        nfce.setObjObsGeralContrib(StaticObjects.getOpcoes().getObsContribuinte());
        nfce.setObjObsGeralFisco(StaticObjects.getOpcoes().getObsFisco());
        if (nfce.getObjObsGeralContrib() != null) {
            nfce.setObsGeralContrib(nfce.getObjObsGeralContrib().getObservacao());
        }
        if (nfce.getObjObsGeralFisco() != null) {
            nfce.setObsGeralFisco(nfce.getObjObsGeralFisco().getObservacao());
        }
        nfce.setVersaoPdv("202510-06");
        nfce.setInformarDadosReformaTributaria(StaticObjects.getOpcoes().getInformarDadosReformaTributaria());
        return nfce;
    }

    public static void setUnidadeFatCliente(UnidadeFatCliente un, NFCe nf) {
        if (nf == null) {
            return;
        }
        nf.setUnidadeFatCliente(un);
        nf.setIndicadorConsumidorFinal(EnumConstantsMentorSimNao.SIM.value);
        if (un != null && un.getCliente() != null && ToolMethods.isStrWithData((String)un.getCliente().getFaturamento().getObservacaoFaturamento())) {
            nf.setInfAdicManualNFCe(un.getCliente().getFaturamento().getObservacaoFaturamento());
        }
    }

    public static NFCe getNewNFCeByPedido(Pedido vo) {
        NFCe nfce = UtilNFCe.criarNFCe();
        nfce.setSerialForSincPedido(vo.getSerialForSync());
        nfce.setNfCeConsumidor(vo.getNfCeConsumidor());
        UtilNFCe.setUnidadeFatCliente(UtilNFCe.getUnidadeFatCliente(vo.getUnidadeFatCliente()), nfce);
        nfce.setRepresentante(UtilNFCe.getRepresentante(vo));
        if (vo.getEnderecoEntrega() != null && vo.getEnderecoEntrega().getCidade() != null) {
            NFCeEnderecoEntrega endNota = new NFCeEnderecoEntrega();
            endNota.setBairro(vo.getEnderecoEntrega().getBairro());
            endNota.setCep(vo.getEnderecoEntrega().getCep());
            endNota.setCidade(vo.getEnderecoEntrega().getCidade());
            endNota.setComplemento(vo.getEnderecoEntrega().getComplemento());
            endNota.setCpfCnpj(vo.getEnderecoEntrega().getCpfCnpj());
            endNota.setLogradouro(vo.getEnderecoEntrega().getLogradouro());
            endNota.setNomePessoaResp(vo.getEnderecoEntrega().getNomePessoaResp());
            endNota.setNumero(vo.getEnderecoEntrega().getNumero());
            endNota.setObservacao(vo.getEnderecoEntrega().getObservacao());
            endNota.setReferencia(vo.getEnderecoEntrega().getReferencia());
            nfce.setEnderecoEntrega(endNota);
        }
        nfce.setPedido(vo);
        nfce.setSincronizacaoManual((short)1);
        NFCeTransp t = new NFCeTransp();
        t.setTipoFrete(vo.getTipoFrete());
        t.setTransportador(vo.getTransportador());
        nfce.setDadosTransporte(t);
        nfce.setPessoaAutorizada(vo.getPessoaAutorizada());
        NFCeTotalizadores totalizadores = new NFCeTotalizadores();
        totalizadores.setNFCe(nfce);
        UtilNFCe.setAndUpdateNaturezaOperacaoNFCe(nfce, vo.getNaturezaOperacao());
        nfce.setTotalizadores(totalizadores);
        nfce.setCondicoesPagamento(vo.getCondicoesPagamento());
        for (DadosRecAgrPedido r : vo.getReceitasAgronomicas()) {
            DadosRecAgrNFCe d = new DadosRecAgrNFCe();
            d.setNrReceitaAgro(r.getNrReceitaAgro());
            d.setCpfTecnicoReceita(r.getCpfTecnicoReceita());
            d.setNfce(nfce);
            nfce.getReceitasAgronomicas().add(d);
        }
        return nfce;
    }

    public static NFCe setAndUpdateNaturezaOperacaoNFCe(NFCe nfce, NaturezaOperacao nat) {
        nfce.setNaturezaOperacao(nat);
        nfce.setModeloDocFiscal(nat.getModeloDocFiscal());
        if (ToolMethods.isEquals((Object)nat.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
            nfce.setSerie(ToolString.completaZeros((String)StaticObjects.getNFCeCaixa().getSerieCaixaNFCe().toString(), (int)3, (boolean)true));
            nfce.setPeriodoEmissaoNFCe(StaticObjects.getNFCePeriodoEmissao());
            nfce.setPeriodoEmissaoNFe(null);
        } else {
            nfce.setSerie(ToolString.completaZeros((String)StaticObjects.getNFCeCaixa().getSerieCaixaNFe().toString(), (int)3, (boolean)true));
            nfce.setPeriodoEmissaoNFe(StaticObjects.getNFePeriodoEmissao());
            nfce.setPeriodoEmissaoNFCe(null);
        }
        nfce.setNumero(UtilNFCe.getProximoNumero(nfce));
        nfce.setChaveNFCe(UtilNFCe.getChave(nfce));
        nfce.setAmbiente(StaticObjects.getOpcoes().getTipoAmbiente());
        nfce.setFinalidadeEmissao(EnumConstNFeFinalidadeEmissao.NORMAL.getValue());
        nfce.setFormatoImpressao(UtilNFCe.getFormatoImpressaoDanfe(nfce));
        if (ToolMethods.isAffirmative((Number)StaticObjects.getOpcoes().getRespeitarTipoConsumidorCliente()) && nfce.getModeloDocFiscal() != null && ToolMethods.isEquals((Object)nfce.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo()) && nfce.getUnidadeFatCliente() != null) {
            nfce.setIndicadorConsumidorFinal(nfce.getUnidadeFatCliente().getCliente().getFaturamento().getTipoConsumidor());
        }
        if (nfce.getIndicadorConsumidorFinal() == null) {
            nfce.setIndicadorConsumidorFinal(EnumConstantsMentorSimNao.SIM.value);
        }
        return nfce;
    }

    private static String getChave(NFCe nfce) {
        TipoEmissaoNFe tipoEmissao = nfce.getPeriodoEmissaoNFCe() != null ? nfce.getPeriodoEmissaoNFCe().getTipoEmissaoNfe() : nfce.getPeriodoEmissaoNFe().getTipoEmissaoNfe();
        return CompNFe.getChaveNFe((String)nfce.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getCodIbge(), (Date)Date.from(nfce.getDataEmissao().toInstant()), (String)nfce.getEmpresa().getPessoa().getComplemento().getCnpj(), (String)nfce.getModeloDocFiscal().getCodigo(), (String)nfce.getSerie(), (Long)nfce.getNumero(), (String)tipoEmissao.getCodigo().toString(), (String)nfce.getNumeroRandomico().toString());
    }

    private static Long getProximoNumero(NFCe nfce) {
        return serviceNFCe.getProximoNumero(nfce.getNfCeCaixa(), nfce.getModeloDocFiscal());
    }

    public static NFCe getCurrent(NFCeCaixa nfCeCaixa) {
        NFCe current = serviceNFCe.getNFCeAberta(nfCeCaixa);
        return current;
    }

    public static NFCeItem getNewNFCeItemRec(NFCeItem it, NFCe nfCe, GradeCor gradeCor, ModeloFiscal modFiscalItem, Double quantidade, Double percComissao, Double valorUnit, CentroEstoque centroEstoque, String codigoBarrasDigitado) {
        if (codigoBarrasDigitado == null || codigoBarrasDigitado.isEmpty()) {
            it.setCodigoBarras(UtilNFCe.getCodigoBarras(gradeCor.getProdutoGrade().getProduto()));
            it.setCodigoBarrasTributavel(UtilNFCe.getCodigoBarrasTributavel(gradeCor.getProdutoGrade().getProduto()));
        } else {
            it.setCodigoBarras(codigoBarrasDigitado);
            it.setCodigoBarrasTributavel(codigoBarrasDigitado);
        }
        it.setCompoeTotal((short)1);
        it.setCfop(UtilNFCe.getCfop(nfCe, modFiscalItem));
        it.setInfAdicionalProd(gradeCor.getProdutoGrade().getProduto().getNomeAuxiliar());
        it.setModeloFiscal(modFiscalItem);
        it.setGradeCor(gradeCor);
        it.setProduto(gradeCor.getProdutoGrade().getProduto());
        it.setCentroEstoque(centroEstoque);
        it.setNfce(nfCe);
        it.setRepresentante(nfCe.getRepresentante());
        it.setQuantidadeComercial(ToolFormatter.arrredondarNumero((Double)quantidade, (int)3));
        ModeloFiscalIcms icms = it.getModeloFiscal().getModeloFiscalIcms();
        if (icms.getTipoAliquotaIcms() != null && icms.getTipoAliquotaIcms() == 2) {
            it.getIcms().setAliquotaIcms(icms.getAliquotaIcms());
        } else {
            it.getIcms().setAliquotaIcms(it.getProduto().getAliquotaIcms());
        }
        UtilNFCe.setInfoIcmsStRetAnt(it);
        it.getIcms().setIncidenciaIcms(it.getModeloFiscal().getModeloFiscalIcms().getIncidenciaIcms());
        it.getIcms().setModalidadeIcms(it.getModeloFiscal().getModeloFiscalIcms().getModalidadeIcms());
        it.getIcms().setMotivoDesoneracaoIcms(it.getModeloFiscal().getModeloFiscalIcms().getMotivoDesoneracaoIcms());
        it.setPis(new NFCeItemPis());
        it.getPis().setAliquota(it.getProduto().getAliquotaPis());
        it.getPis().setIncidenciaPisCofins(it.getModeloFiscal().getModeloFiscalPisCofins().getIncidenciaPisCofins());
        it.getPis().setQuantidadeVendida(it.getQuantidadeComercial());
        it.setCofins(new NFCeItemCofins());
        it.getCofins().setAliquota(it.getProduto().getAliquotaPis());
        it.getCofins().setIncidenciaPisCofins(it.getModeloFiscal().getModeloFiscalPisCofins().getIncidenciaPisCofins());
        it.getCofins().setQuantidadeVendida(it.getQuantidadeComercial());
        it.setIpi(new NFCeItemIpi());
        it.getIpi().setAliquota(it.getProduto().getAliquotaIpi());
        it.getIpi().setIncidenciaIpi(it.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi());
        it.getIpi().setQuantidadeVendida(it.getQuantidadeComercial());
        if (it.getModeloFiscal().getModeloFiscalIpi().getClasseEnquadramentoIpi() != null) {
            it.getIpi().setClasseEnqIpi(it.getModeloFiscal().getModeloFiscalIpi().getClasseEnquadramentoIpi());
        } else {
            it.getIpi().setClasseEnqIpi(it.getGradeCor().getProdutoGrade().getProduto().getClasseEnqIpi());
        }
        it.setPercentualComissao(percComissao);
        it.setValorUnitarioComercial(valorUnit);
        UtilNFCe.getPrevImpostos(nfCe, it);
        it.setCbs(new NFCeItemCbs());
        it.setIbs(new NFCeItemIbs());
        try {
            SCompCBSParams cbsParams = new SCompCBSParams();
            cbsParams.setParams(it, nfCe.getEmpresa(), nfCe.getDataEmissao(), nfCe.getNaturezaOperacao().getModeloDocFiscal());
            SCompIBSParams ibsParams = new SCompIBSParams();
            Cidade cidade = nfCe.getUnidadeFatCliente() != null ? nfCe.getUnidadeFatCliente().getPessoa().getEndereco().getCidade() : nfCe.getEmpresa().getPessoa().getEndereco().getCidade();
            ibsParams.setParams(it, nfCe.getEmpresa(), nfCe.getDataEmissao(), nfCe.getNaturezaOperacao().getModeloDocFiscal(), cidade);
        }
        catch (ExceptionInvalidData ex) {
            System.getLogger(UtilNFCe.class.getName()).log(System.Logger.Level.ERROR, (String)null, (Throwable)ex);
        }
        return it;
    }

    public static NFCeItem getNewNFCeItem(NFCeItem it, NFCe nfCe, GradeCor gradeCor, ModeloFiscal modFiscalItem, Double quantidade, Double percComissao, Double valorUnit, Double valorTotal, Double valorCusto, CentroEstoque centroEstoque, String codigoBarrasDigitado, boolean codigoPesavel) {
        if (codigoBarrasDigitado == null || codigoBarrasDigitado.isEmpty() || codigoPesavel) {
            String codigoBarras = UtilNFCe.getCodigoBarras(gradeCor.getProdutoGrade().getProduto());
            String codigoBarrasTrib = UtilNFCe.getCodigoBarrasTributavel(gradeCor.getProdutoGrade().getProduto());
            if (ToolMethods.isStrWithData((String)codigoBarras) && ToolMethods.isStrWithData((String)codigoBarrasTrib)) {
                it.setCodigoBarras(codigoBarras);
                it.setCodigoBarrasTributavel(codigoBarrasTrib);
            }
        } else {
            it.setCodigoBarras(codigoBarrasDigitado);
            it.setCodigoBarrasTributavel(codigoBarrasDigitado);
        }
        if (codigoPesavel) {
            it.setCodigoBarrasPesavel((short)1);
        }
        it.setSerialForSinc(UtilNFCeSerial.getSerial(it));
        it.setCompoeTotal((short)1);
        it.setCfop(UtilNFCe.getCfop(nfCe, modFiscalItem));
        it.setInfAdicionalProd(gradeCor.getProdutoGrade().getProduto().getNomeAuxiliar());
        it.setModeloFiscal(modFiscalItem);
        it.setGradeCor(gradeCor);
        it.setProduto(gradeCor.getProdutoGrade().getProduto());
        it.setCentroEstoque(centroEstoque);
        it.setNfce(nfCe);
        it.setRepresentante(nfCe.getRepresentante());
        it.setStatus((short)1);
        it.setStatusOriginal((short)1);
        it.setNumeroItem(UtilNFCe.getMaxContador(nfCe) + 1);
        it.setQuantidadeComercial(ToolFormatter.arrredondarNumero((Double)quantidade, (int)3));
        it.setValorTotal(valorTotal);
        it.setValorTotalBruto(valorTotal);
        it.setIcms(new NFCeItemICMS());
        ModeloFiscalIcms icms = it.getModeloFiscal().getModeloFiscalIcms();
        if (icms.getTipoAliquotaIcms() != null && icms.getTipoAliquotaIcms() == 2) {
            it.getIcms().setAliquotaIcms(icms.getAliquotaIcms());
        } else {
            it.getIcms().setAliquotaIcms(it.getProduto().getAliquotaIcms());
        }
        UtilNFCe.setInfoIcmsStRetAnt(it);
        it.getIcms().setIncidenciaIcms(it.getModeloFiscal().getModeloFiscalIcms().getIncidenciaIcms());
        it.getIcms().setModalidadeIcms(it.getModeloFiscal().getModeloFiscalIcms().getModalidadeIcms());
        it.getIcms().setMotivoDesoneracaoIcms(it.getModeloFiscal().getModeloFiscalIcms().getMotivoDesoneracaoIcms());
        it.setPis(new NFCeItemPis());
        it.getPis().setAliquota(it.getProduto().getAliquotaPis());
        it.getPis().setIncidenciaPisCofins(it.getModeloFiscal().getModeloFiscalPisCofins().getIncidenciaPisCofins());
        it.getPis().setQuantidadeVendida(it.getQuantidadeComercial());
        it.setCofins(new NFCeItemCofins());
        it.getCofins().setAliquota(it.getProduto().getAliquotaPis());
        it.getCofins().setIncidenciaPisCofins(it.getModeloFiscal().getModeloFiscalPisCofins().getIncidenciaPisCofins());
        it.getCofins().setQuantidadeVendida(it.getQuantidadeComercial());
        it.setIpi(new NFCeItemIpi());
        it.getIpi().setAliquota(it.getProduto().getAliquotaIpi());
        it.getIpi().setIncidenciaIpi(it.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi());
        it.getIpi().setQuantidadeVendida(it.getQuantidadeComercial());
        if (it.getModeloFiscal().getModeloFiscalIpi().getClasseEnquadramentoIpi() != null) {
            it.getIpi().setClasseEnqIpi(it.getModeloFiscal().getModeloFiscalIpi().getClasseEnquadramentoIpi());
        } else {
            it.getIpi().setClasseEnqIpi(it.getGradeCor().getProdutoGrade().getProduto().getClasseEnqIpi());
        }
        if (ToolMethods.isEquals((Object)it.getModeloFiscal().getModeloFiscalIpi().getTipoAliquotaIpi(), (Object)0)) {
            it.getIpi().setAliquota(0.0);
        } else if (ToolMethods.isEquals((Object)it.getModeloFiscal().getModeloFiscalIpi().getTipoAliquotaIpi(), (Object)2)) {
            it.getModeloFiscal().getModeloFiscalIpi().getAliquotaIpi();
        } else {
            it.getIpi().setAliquota(it.getProduto().getAliquotaIpi());
        }
        it.setPercentualComissao(percComissao);
        it.setValorUnitarioComercial(valorUnit);
        it.setValorCusto(valorCusto);
        UtilNFCe.getPrevImpostos(nfCe, it);
        it.setCbs(new NFCeItemCbs());
        it.setIbs(new NFCeItemIbs());
        try {
            SCompCBSParams cbsParams = new SCompCBSParams();
            cbsParams.setParams(it, nfCe.getEmpresa(), nfCe.getDataEmissao(), nfCe.getNaturezaOperacao().getModeloDocFiscal());
            SCompIBSParams ibsParams = new SCompIBSParams();
            Cidade cidade = nfCe.getUnidadeFatCliente() != null ? nfCe.getUnidadeFatCliente().getPessoa().getEndereco().getCidade() : nfCe.getEmpresa().getPessoa().getEndereco().getCidade();
            ibsParams.setParams(it, nfCe.getEmpresa(), nfCe.getDataEmissao(), nfCe.getNaturezaOperacao().getModeloDocFiscal(), cidade);
        }
        catch (ExceptionInvalidData ex) {
            System.getLogger(UtilNFCe.class.getName()).log(System.Logger.Level.ERROR, (String)null, (Throwable)ex);
        }
        return it;
    }

    public static void aplicarDescontoPromocionalPedido(NFCeItem toAdd, NFCe nfce) {
        Double quantidadeTotal = nfce.getItens().stream().filter(i -> ToolMethods.isEquals((Object)toAdd.getProduto(), (Object)i.getProduto()) && ToolMethods.isEquals((Object)i.getStatus(), (Object)1)).mapToDouble(i -> i.getQuantidadeComercial()).sum();
        TempPesquisaProduto itemPromocional = new HelperPrecosTabPromocao().getPesqTabPromocao(toAdd.getProduto().getIdentificador(), nfce.getEmpresa(), nfce.getDataEmissao(), quantidadeTotal);
        if (itemPromocional != null) {
            for (NFCeItem it : nfce.getItens()) {
                if (!ToolMethods.isEquals((Object)it.getProduto(), (Object)toAdd.getProduto()) || !ToolMethods.isEquals((Object)it.getStatus(), (Object)1)) continue;
                if (it.getValorDesconto() != null && it.getValorDescontoPromocional() != null && it.getValorDesconto() - it.getValorDescontoPromocional() >= 0.0) {
                    it.setValorDesconto(it.getValorDesconto() - it.getValorDescontoPromocional());
                }
                it.setValorDescontoPromocional((it.getValorUnitarioComercial() - itemPromocional.getValorUnitario()) * it.getQuantidadeComercial());
                it.setValorDesconto(it.getValorDesconto() + it.getValorDescontoPromocional());
                Double vrBruto = it.getValorUnitarioComercial() * it.getQuantidadeComercial();
                if (vrBruto > 0.0) {
                    it.setPercentualDescontoPromocional(it.getValorDescontoPromocional() / vrBruto * 100.0);
                }
                it.setPercentualComissao(itemPromocional.getPercComissao());
            }
        }
    }

    private static void setInfoIcmsStRetAnt(NFCeItem it) {
        ServiceICMSSTRetidoAntInfo service;
        ICMSSTRetidoAntInfo ret;
        it.getIcms().setValorUnidIcmsSTRetAnt(0.0);
        it.getIcms().setValorUnidBCIcmsSTRetAnt(0.0);
        if (ToolMethods.isEquals((Object)it.getModeloFiscal().getModeloFiscalIcms().getGerarInfoICMSSTRet(), (Object)1) && (ret = (service = Main.getBean(ServiceICMSSTRetidoAntInfo.class)).getIcmsSTRetidoAntInfo(it.getProduto(), it.getEmpresa())) != null) {
            it.getIcms().setValorUnidIcmsSTRetAnt(ret.getValorUnidadeIcmsST());
            it.getIcms().setValorUnidBCIcmsSTRetAnt(ret.getValorUnidadeBCIcmsST());
        }
    }

    private static void getPrevImpostos(NFCe nfCe, NFCeItem nfCeItem) {
        Produto produto = nfCeItem.getProduto();
        Double perTribFed = produto.getAliqImpEstimadaFed();
        Double perTribMun = produto.getAliqImpEstimadaMun();
        Double perTribEst = produto.getAliqImpEstimadaEst();
        PrevImpostosNCM prev = servicePrevImpostosNcm.findByNCMAndUF(nfCeItem.getProduto().getNcm(), nfCe.getEmpresa().getPessoa().getEndereco().getCidade().getUf());
        if (!ToolMethods.isWithData((Number)perTribEst) && prev != null) {
            nfCeItem.setPercTributosPrevistosMun(prev.getAliquotaEstadual());
            perTribEst = prev.getAliquotaEstadual();
        }
        if (!ToolMethods.isWithData((Number)perTribMun) && prev != null) {
            perTribMun = prev.getAliquotaMunicipal();
        }
        if (!ToolMethods.isWithData((Number)perTribFed) && prev != null) {
            String codigoInc = nfCeItem.getIcms().getIncidenciaIcms().getCodigo();
            perTribFed = codigoInc.startsWith("0") || codigoInc.startsWith("8") || codigoInc.startsWith("4") || codigoInc.startsWith("5") || codigoInc.startsWith("3") ? prev.getAliquotaFederalNac() : prev.getAliquotaFederalImp();
        }
        if (perTribEst == null) {
            perTribEst = 0.0;
        }
        if (perTribMun == null) {
            perTribMun = 0.0;
        }
        if (perTribFed == null) {
            perTribFed = 0.0;
        }
        nfCeItem.setPercTributosPrevistos(perTribEst + perTribMun + perTribFed);
        nfCeItem.setPercTributosPrevistosEst(perTribEst);
        nfCeItem.setPercTributosPrevistosMun(perTribMun);
        nfCeItem.setPercTributosPrevistosFed(perTribFed);
    }

    private static Cfop getCfop(NFCe nfCe, ModeloFiscal modFiscalItem) {
        return new AuxModeloFiscal().getCFOP(nfCe, modFiscalItem);
    }

    private static Integer getMaxContador(NFCe nfCe) {
        OptionalInt found = nfCe.getItens().stream().mapToInt(i -> i.getNumeroItem()).max();
        return found.isPresent() ? found.getAsInt() : 0;
    }

    private static String getCodigoBarras(Produto produto) {
        for (CodigoBarras cod : produto.getCodigoBarras()) {
            if (!ToolMethods.isEquals((Object)cod.getAtivo(), (Object)1) || !ToolMethods.isEquals((Object)cod.getUsarComoCodigoPrinc(), (Object)1)) continue;
            return cod.getCodigoBarras();
        }
        return null;
    }

    private static String getCodigoBarrasTributavel(Produto produto) {
        for (CodigoBarras cod : produto.getCodigoBarras()) {
            if (!ToolMethods.isEquals((Object)cod.getAtivo(), (Object)1) || !ToolMethods.isEquals((Object)cod.getUsarComoCodPrincTrib(), (Object)1)) continue;
            return cod.getCodigoBarras();
        }
        return null;
    }

    public static NFCe getNewNFCeContigencia(NFCe nfCeAnterior, Usuario usuario) throws Exception {
        NFCePeriodoEmissao aux = UtilPeriodoEmissao.checarAlterarParaContigencia(nfCeAnterior);
        nfCeAnterior.setLoteNotas(null);
        List<NFCeItem> itens = nfCeAnterior.getItens();
        nfCeAnterior.setItens(new LinkedList<NFCeItem>());
        NFCe nova = (NFCe)new UtilClone().cloneEntity(nfCeAnterior, new LinkedList<String>());
        nova.setPeriodoEmissaoNFCe(aux);
        nova.setNumero(UtilNFCe.getProximoNumero(nova));
        nova.setChaveNFCe(UtilNFCe.getChave(nova));
        nova.setSerialForSinc(UtilNFCeSerial.getSerial(nova.getNfCeCaixa()));
        nova.setNfceCancelamentoAnterior(UtilNFCe.getCancelamento(nfCeAnterior, "Cancelamento devido a problemas tecnicos e mudanca para contigencia.", usuario));
        for (NFCeItem item : itens) {
            NFCeItem temp = (NFCeItem)new UtilClone().cloneEntity(item, new LinkedList<String>());
            temp.setPreAbastecimento(item.getPreAbastecimento());
            item.setPreAbastecimento(null);
            temp.setNfce(nova);
            nova.getItens().add(temp);
        }
        nfCeAnterior.setItens(itens);
        nova = UtilNFCe.save(nova);
        UtilNFCe.atualizaDadosCancNota(nfCeAnterior);
        serviceNFCe.merge(nfCeAnterior);
        return nova;
    }

    public static NFCe save(NFCe nova) {
        if (Objects.equals(nova, StaticObjects.getNfceAberta())) {
            return StaticObjects.setNfceAberta(nova);
        }
        return serviceNFCe.merge(nova);
    }

    public static NFCeLoteNotas save(NFCeLoteNotas nova) {
        return serviceNFCeLoteNotas.merge(nova);
    }

    private static NFCe clonarNovaNFCe(NFCe nfCe) throws Exception {
        NFCe ret = (NFCe)new UtilClone().cloneEntity(nfCe, new LinkedList<String>());
        ret.setSituacaoDocumento(UtilNFCe.findSituacaoDocumentoRegular());
        ret.setLoteNotas(null);
        ret.setInutilizacaoNFe(null);
        ret.setNfceEventoEpec(null);
        ret.setNfCeCancelamento(null);
        ret.setNfceCancelamentoAnterior(null);
        ret.setPedido(null);
        ret.setNrProtocolo(null);
        ret.setXml(null);
        ret.setXmlAutorizacao(null);
        UtilNFCeCalculos.calcularValores(ret);
        return ret;
    }

    public static NFCeCancelamento getCancelamento(NFCe nfce, String justificativa, Usuario usuario) {
        NFCeCancelamento canc = nfce.getNfCeCancelamento();
        if (canc == null) {
            canc = new NFCeCancelamento();
        }
        canc.setDataCancelamento(new Date());
        canc.setNfce(nfce);
        canc.setJustificativa(ToolString.clearSpecialCharacXML((String)justificativa));
        canc.setUsuario(usuario);
        return canc;
    }

    private static SituacaoDocumento findSituacaoDocumentoRegular() {
        return serviceSituacaoDocumento.getFindCodigo("00");
    }

    private static Representante getRepresentante(Pedido vo) {
        Representante r = null;
        ServiceRepresentante serviceRep = Main.getBean(ServiceRepresentante.class);
        if (vo.getRepresentante() != null && vo.getRepresentante().getIdentificador() > 0L) {
            r = (Representante)serviceRep.get(vo.getRepresentante().getIdentificador());
        }
        return r;
    }

    public static void delete(NFCe nova) {
        serviceNFCe.delete(nova);
        StaticObjects.setNfceAberta(null);
        StaticObjects.getNfceAberta();
    }

    private static Representante getRepresentanteToUser() {
        if (StaticObjects.getOpcoes().getInformarVendedorVenda() != null && StaticObjects.getOpcoes().getInformarVendedorVenda().equals((short)1)) {
            return null;
        }
        return serviceRepresentante.getRepresentanteByPessoa(StaticObjects.getUsuario().getPessoa().getIdentificador());
    }

    private static String getFormatoImpressaoDanfe(NFCe nfce) {
        if (ToolMethods.isEquals((Object)nfce.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
            return EnumConstNFeTipoImpressao.DANFE_NFCE.getCodigo();
        }
        if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getTipoImpressaoDanfeNfe(), (Object)1)) {
            return EnumConstNFeTipoImpressao.DANFE_NORMAL_RETRATO.getCodigo();
        }
        if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getTipoImpressaoDanfeNfe(), (Object)2)) {
            return EnumConstNFeTipoImpressao.DANFE_NORMAL_PAISAGEM.getCodigo();
        }
        return EnumConstNFeTipoImpressao.DANFE_SIMPLIFICADO.getCodigo();
    }

    public static NFCe reconstruirNFCe(NFCe nfce, Boolean atualizarValoresProdutos) throws Exception {
        nfce.setIdentificadorCSCContribuinte(StaticObjects.getOpcoes().getIdentificadorCSCContrib());
        nfce.setCodigoCSCContribuinte(StaticObjects.getOpcoes().getCodigoCSCContrib());
        nfce.setAmbiente(StaticObjects.getOpcoes().getTipoAmbiente());
        nfce.setVersaoNfe(StaticObjects.getOpcoes().getVersaoNFe());
        nfce.setPeriodoEmissaoNFCe(nfce.getPeriodoEmissaoNFCe());
        nfce.setPeriodoEmissaoNFe(nfce.getPeriodoEmissaoNFe());
        nfce.setNfCeCaixa(StaticObjects.getNFCeCaixa());
        nfce.setObjObsGeralContrib(StaticObjects.getOpcoes().getObsContribuinte());
        nfce.setObjObsGeralFisco(StaticObjects.getOpcoes().getObsFisco());
        if (nfce.getObjObsGeralContrib() != null) {
            nfce.setObsGeralContrib(nfce.getObjObsGeralContrib().getObservacao());
        }
        if (nfce.getObjObsGeralFisco() != null) {
            nfce.setObsGeralFisco(nfce.getObjObsGeralFisco().getObservacao());
        }
        nfce.getDadosTransporte().setTipoFrete(StaticObjects.getOpcoes().getTipoFrete());
        int sizeItens = nfce.getItens().size();
        for (int indice = 0; indice < sizeItens; ++indice) {
            NFCeItem i = nfce.getItens().get(indice);
            ModeloFiscal modeloFiscal = new AuxModeloFiscal().getModeloFiscalNFCe(i.getProduto(), i.getNfce().getUnidadeFatCliente(), i.getNfce().getNfcePessoa(), i.getNfce().getEnderecoEntrega(), i.getNfce().getNaturezaOperacao(), i.getNfce().getEmpresa(), true);
            if (modeloFiscal == null) {
                throw new Exception("Nenhum modelo fiscal foi encontrado!");
            }
            boolean precoCusto = false;
            if (ToolMethods.isEquals((Object)nfce.getNfeTransferencia(), (Object)1)) {
                precoCusto = true;
            }
            Double valorUnitario = 0.0;
            Double percComissao = 0.0;
            if (atualizarValoresProdutos.booleanValue()) {
                TempPesquisaProduto tempProd = UtilNFCe.findTempProdutoTabPreco(i.getProduto().getIdentificador(), nfce);
                valorUnitario = tempProd.getValorUnitario();
                if (precoCusto) {
                    valorUnitario = tempProd.getPrecoCusto();
                }
                percComissao = tempProd.getPercComissao();
            } else {
                valorUnitario = i.getValorUnitarioComercial();
                if (precoCusto) {
                    valorUnitario = i.getValorCusto();
                }
                percComissao = i.getPercentualComissao();
            }
            UtilNFCe.getNewNFCeItemRec(i, nfce, i.getGradeCor(), modeloFiscal, i.getQuantidadeComercial(), percComissao, valorUnitario, i.getCentroEstoque(), "");
        }
        int cont = 1;
        for (NFCeItem i : nfce.getItens()) {
            if (!ToolMethods.isEquals((Object)i.getStatus(), (Object)1)) continue;
            i.setNumeroItem(cont);
            ++cont;
        }
        nfce.setDataUltModificacao(new Date());
        UtilNFCe.recalcularImpostosItens(nfce);
        nfce.setChaveNFCe(UtilNFCe.getChave(nfce));
        StaticObjects.refreshNFCe(nfce);
        return nfce;
    }

    private static TempPesquisaProduto findTempProdutoTabPreco(Long idProduto, NFCe nfCe) throws ExceptionTabelaPrecosDinamica, ExceptionAvaliadorExpressoes {
        HelperPrecos helper = Main.getBean(HelperPrecos.class);
        List<TempPesquisaProduto> prod = null;
        prod = helper.getProdutos(idProduto.toString(), StaticObjects.getEmpresa(), nfCe.getUnidadeFatCliente(), StaticObjects.getOpcoes(), nfCe.getRepresentante(), StaticObjects.getUsuario(), StaticObjects.getGrupo(), nfCe.getDadosTransporte().getTipoFrete(), nfCe.getNaturezaOperacao(), nfCe.getCondicoesPagamento(), EnumTipoPesqProduto.TIPO_PESQ_ID, null, null);
        return prod.get(0);
    }

    private static void recalcularImpostosItens(NFCe nfce) throws ExceptionImpostoPisCofins, ExceptionImpostoIcms, ExceptionImpostoIPI, ExceptionImpostoCbsIbs {
        UtilNFCeCalculos.calcularValores(nfce);
    }

    private static NaturezaOperacao getNaturezaOperacao(String codModDoc) {
        List<NaturezaOperacao> list = serviceNaturezaOperacao.getNaturezaOperacaoByModDocFiscal(codModDoc, StaticObjects.getEmpresa().getIdentificador());
        if (list == null || list.isEmpty()) {
            throw new RuntimeException("Nenhuma Natureza de Opera\u00e7\u00e3o encontrada com o Modelo Doc. Fiscal: " + codModDoc);
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return Alerts.showQuestion("Selecione uma Natureza de Opera\u00e7\u00e3o", list.toArray(), NaturezaOperacao.class);
    }

    private static UnidadeFatCliente getUnidadeFatCliente(UnidadeFatCliente undPedido) {
        if (undPedido == null || ToolMethods.isEquals((Object)undPedido, (Object)StaticObjects.getOpcoes().getUnidadeFatCliente())) {
            return null;
        }
        return undPedido;
    }

    public static NFCe clonarNFCeNovoDoc(NFCe selected) throws Exception {
        NFCe gerada = UtilNFCe.clonarNovaNFCe(selected);
        gerada.getItens().forEach(i -> i.setPreAbastecimento(null));
        gerada.setDataEmissao(new Date());
        gerada.setDataPrevSaida(gerada.getDataPrevSaida());
        gerada.getPagamentos().clear();
        gerada.setNfCeCaixa(StaticObjects.getNFCeCaixa());
        gerada.setNfCeControleCaixa(StaticObjects.getControleCaixa());
        gerada.setNumero(UtilNFCe.getProximoNumero(gerada));
        gerada.setEnviado((short)0);
        gerada.setStatusSincERP((short)0);
        gerada.setIdentificadorERP(null);
        gerada.setStatus(0);
        gerada.setMotivo("Nota Nao enviada");
        gerada.setSerialForSinc(UtilNFCeSerial.getSerial(gerada.getNfCeCaixa()));
        for (NFCeItem i2 : gerada.getItens()) {
            i2.setStatus(i2.getStatusOriginal());
            if (i2.getStatus() != null) continue;
            i2.setStatus((short)1);
        }
        if (selected.getPeriodoEmissaoNFCe() != null) {
            gerada.setPeriodoEmissaoNFCe(StaticObjects.getNFCePeriodoEmissao());
        } else {
            gerada.setPeriodoEmissaoNFe(StaticObjects.getNFePeriodoEmissao());
        }
        gerada.setChaveNFCe(UtilNFCe.getChave(gerada));
        return gerada;
    }

    public static boolean isCodigoPesavel(String code) {
        return code != null && code.startsWith("2") && code.length() == 13;
    }

    public static NFCe atualizaStatusReenvioERP(NFCe nfce) {
        nfce.setStatusSincERP((short)0);
        nfce.setSincronizacaoManual((short)0);
        return nfce;
    }

    public static NFCe salvaAtualizaStatusReenvioERP(NFCe nfce) {
        NFCe ret = serviceNFCe.merge(UtilNFCe.atualizaStatusReenvioERP(nfce));
        return ret;
    }

    public static void setPlaca(NFCe nfCe, String placa, String km) {
        Long kmL = 0L;
        if (ToolMethods.isStrWithData((String)(km = ToolString.onlyNumbers((String)km)))) {
            kmL = Long.valueOf(km);
        }
        nfCe.setPlacaVeiculo(placa);
        nfCe.setKm(kmL);
        for (NFCeItem i : nfCe.getItens()) {
            if (i.getPreAbastecimento() == null) continue;
            i.getPreAbastecimento().setPlaca(placa);
            i.getPreAbastecimento().setKm(km);
        }
    }

    public static void ajustaDataEmissao(NFCe nf) {
        Date dataAtual;
        Date data1 = nf.getDataEmissao();
        if (ToolDate.difBetweenDatesInMinutes((Date)data1, (Date)(dataAtual = new Date())) < 60L) {
            nf.setDataEmissao(dataAtual);
        }
    }

    public static boolean possuiItensReceita(NFCe nf) {
        Optional<NFCeItem> found = nf.getItens().stream().filter(i -> ToolMethods.isAffirmative((Number)i.getProduto().getEmitirReceitaAgro())).findFirst();
        return found.isPresent();
    }

    public static boolean possuiPagBoleto(NFCe nf) {
        boolean isBoleto = false;
        for (NFCePagamento pag : nf.getPagamentos()) {
            if (!ToolMethods.isAffirmative((Number)pag.getStatus()) || !pag.getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.BOLETO_BANCARIO.getCodigo())) continue;
            isBoleto = true;
            break;
        }
        return isBoleto;
    }

    public static boolean permiteTroco(CondicoesPagamento c, NFCeOpcoes opcoes) {
        return UtilNFCe.permiteTroco(c.getMeioPagamento().getTipoPagamentoNFe(), opcoes);
    }

    public static boolean permiteTroco(TipoPagamentoNFe c, NFCeOpcoes opcoes) {
        Optional<NFCeOpcoesTipoPagNFe> found = opcoes.getTiposPagamentosNFe().stream().filter(i -> ToolMethods.isEquals((Object)i.getTipoPagamentoNFe(), (Object)c)).findFirst();
        if (found.isPresent()) {
            return ToolMethods.isEquals((Object)found.get().getPermitirTroco(), (Object)1);
        }
        return false;
    }

    public static boolean obrigaIdentificacao(TipoPagamentoNFe c, NFCeOpcoes opcoes) {
        Optional<NFCeOpcoesTipoPagNFe> found = opcoes.getTiposPagamentosNFe().stream().filter(i -> ToolMethods.isEquals((Object)i.getTipoPagamentoNFe(), (Object)c)).findFirst();
        if (found.isPresent()) {
            return ToolMethods.isEquals((Object)found.get().getExigirIdentificacao(), (Object)1);
        }
        return false;
    }

    private static void defineEndEntregaPosto(NFCe nfCe) {
        Empresa empresa = nfCe.getEmpresa();
        if (empresa == null) {
            return;
        }
        if (nfCe.getEnderecoEntrega() != null) {
            return;
        }
        if (nfCe.getModeloDocFiscal() == null) {
            return;
        }
        if (!ToolMethods.isEquals((Object)nfCe.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
            return;
        }
        if (empresa.getEmpresaDados().getTipoEmpresa() == null || !ToolMethods.isEquals((Object)String.valueOf(empresa.getEmpresaDados().getTipoEmpresa().getCodigo()), (Object)String.valueOf(6))) {
            return;
        }
        UnidadeFederativa ufCliente = new AuxModeloFiscal().getUFCliente(nfCe.getNfcePessoa(), nfCe.getUnidadeFatCliente());
        if (ToolMethods.isEquals((Object)ufCliente, (Object)empresa.getPessoa().getEndereco().getCidade().getUf())) {
            return;
        }
        NFCeEnderecoEntrega end = new NFCeEnderecoEntrega();
        end.setBairro(empresa.getPessoa().getEndereco().getBairro());
        end.setCidade(empresa.getPessoa().getEndereco().getCidade());
        end.setComplemento(empresa.getPessoa().getEndereco().getComplemento());
        end.setLogradouro(empresa.getPessoa().getEndereco().getLogradouro());
        end.setNumero(empresa.getPessoa().getEndereco().getNumero());
        end.setCep(empresa.getPessoa().getEndereco().getCep());
        if (nfCe.getUnidadeFatCliente() != null) {
            end.setNomePessoaResp(nfCe.getUnidadeFatCliente().getPessoa().getNome());
            end.setCpfCnpj(nfCe.getUnidadeFatCliente().getPessoa().getComplemento().getCnpj());
        } else if (nfCe.getNfcePessoa() != null) {
            end.setNomePessoaResp(nfCe.getNfcePessoa().getNome());
            end.setCpfCnpj(nfCe.getNfcePessoa().getCpfCnpj());
        }
        nfCe.setEnderecoEntrega(end);
    }

    public static boolean isNotaTransferencia(NFCe vo) {
        return vo != null && ToolMethods.isAffirmative((Number)vo.getNfeTransferencia());
    }

    public static TipoEmissaoNFe getTipoEmissaoNFe(NFCe nfCe) {
        TipoEmissaoNFe tipoEmissao = null;
        if (nfCe == null) {
            throw new RuntimeException("Erro de programa\u00e7\u00e3o. Nenhuma nota encontra se aberta para carregar o tipo de emiss\u00e3o!");
        }
        if (ToolMethods.isEquals((Object)nfCe.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
            if (nfCe.getPeriodoEmissaoNFe() == null) {
                throw new RuntimeException("Erro de programa\u00e7\u00e3o. Modelo Doc Fiscal 55 e sem Periodo de Emiss\u00e3o NF-e informado na nota!");
            }
            tipoEmissao = ToolMethods.isEquals((Object)nfCe.getPeriodoEmissaoNFe().getTipoEmissaoNfe(), (Object)StaticObjects.getNFePeriodoEmissao().getTipoEmissaoNfe()) ? nfCe.getPeriodoEmissaoNFe().getTipoEmissaoNfe() : (ToolMethods.isEquals((Object)nfCe.getPeriodoEmissaoNFe().getTipoEmissaoNfe().getCodigo(), (Object)3) || ToolMethods.isEquals((Object)nfCe.getPeriodoEmissaoNFe().getTipoEmissaoNfe().getCodigo(), (Object)6) || ToolMethods.isEquals((Object)nfCe.getPeriodoEmissaoNFe().getTipoEmissaoNfe().getCodigo(), (Object)7) ? nfCe.getPeriodoEmissaoNFe().getTipoEmissaoNfe() : StaticObjects.getNFePeriodoEmissao().getTipoEmissaoNfe());
        } else {
            if (nfCe.getPeriodoEmissaoNFCe() == null) {
                throw new RuntimeException("Erro de programa\u00e7\u00e3o. Modelo Doc Fiscal 65 e sem Periodo de Emiss\u00e3o NFC-e informado na nota!");
            }
            tipoEmissao = ToolMethods.isEquals((Object)nfCe.getPeriodoEmissaoNFCe().getTipoEmissaoNfe(), (Object)StaticObjects.getNFCePeriodoEmissao().getTipoEmissaoNfe()) ? nfCe.getPeriodoEmissaoNFCe().getTipoEmissaoNfe() : StaticObjects.getNFCePeriodoEmissao().getTipoEmissaoNfe();
        }
        if (tipoEmissao == null) {
            throw new RuntimeException("Erro de programa\u00e7\u00e3o. Nenhum Tipo de Emiss\u00e3o foi encontrado!");
        }
        return tipoEmissao;
    }

    public static boolean isStatusValidoImpressao(NFCe currentNfce) {
        if (currentNfce.getStatus() == null) {
            return false;
        }
        EnumConstNFeStatus status = EnumConstNFeStatus.getByCodigo((Integer)currentNfce.getStatus());
        return status != null && EnumConstNFeStatus.isStatusAutorizadaOuContigencia((EnumConstNFeStatus)status);
    }

    public static void atualizaDadosCancNota(NFCe nfce) {
        UtilCentralAbastecimento.get().setPlacaAndKMNFCePreAbastecimento(nfce, "", "");
    }

    public static void putInformacoesRastreioLote(Pedido pedido, NFCe nfce) {
        if (ToolMethods.isNull((Object)pedido).booleanValue() || ToolMethods.isNull((Object)nfce).booleanValue() || !ToolMethods.isWithData(nfce.getItens())) {
            return;
        }
        if (ToolMethods.isWithData(pedido.getTransferenciasEstoque())) {
            for (DadosTransfCentroEstoque transf : pedido.getTransferenciasEstoque()) {
                HashMap<GradeCor, List<DadosGradeTransfCentroEstoque>> transferencias = new HashMap<GradeCor, List<DadosGradeTransfCentroEstoque>>();
                if (!ToolMethods.isWithData(transf.getItens())) continue;
                for (DadosItemTransfCentroEstoque transfItem : transf.getItens()) {
                    if (!ToolMethods.isWithData(transfItem.getGrades())) continue;
                    for (DadosGradeTransfCentroEstoque transfGrade : transfItem.getGrades()) {
                        if (transferencias.containsKey(transfGrade.getGradeCor())) {
                            ((List)transferencias.get(transfGrade.getGradeCor())).add(transfGrade);
                            continue;
                        }
                        ArrayList<DadosGradeTransfCentroEstoque> data = new ArrayList<DadosGradeTransfCentroEstoque>();
                        data.add(transfGrade);
                        transferencias.put(transfGrade.getGradeCor(), data);
                    }
                    UtilNFCe.putInternalInfRastreioLote(nfce, transferencias);
                }
            }
        }
    }

    public static void putInternalInfRastreioLote(NFCe nfce, Map<GradeCor, List<DadosGradeTransfCentroEstoque>> transferencias) {
        for (NFCeItem nfItem : nfce.getItens()) {
            List<DadosGradeTransfCentroEstoque> dadosTransf = transferencias.get(nfItem.getGradeCor());
            ArrayList<NFCeItemLote> itensRastreio = new ArrayList<NFCeItemLote>();
            if (ToolMethods.isNotNull(dadosTransf).booleanValue()) {
                Double quantidadePendente = nfItem.getQuantidadeComercial();
                for (DadosGradeTransfCentroEstoque i : dadosTransf) {
                    if (ToolMethods.isEquals((Object)i.getQuantidade(), (Object)0.0)) continue;
                    NFCeItemLote lote = new NFCeItemLote();
                    lote.setCodigoAgregacao(i.getCodigoAgregacao());
                    lote.setDataFabricacao(i.getDataFabricacao());
                    lote.setDataValidade(i.getDataValidade());
                    lote.setNumeroLote(i.getNumeroLote());
                    lote.setItem(nfItem);
                    if (ToolMethods.isEquals((Object)i.getQuantidade(), (Object)quantidadePendente)) {
                        quantidadePendente = 0.0;
                        lote.setQuantidade(i.getQuantidade());
                        i.setQuantidade(0.0);
                        itensRastreio.add(lote);
                        break;
                    }
                    if (i.getQuantidade() > quantidadePendente) {
                        lote.setQuantidade(quantidadePendente);
                        i.setQuantidade(i.getQuantidade() - quantidadePendente);
                        quantidadePendente = 0.0;
                        itensRastreio.add(lote);
                        break;
                    }
                    quantidadePendente = quantidadePendente - i.getQuantidade();
                    lote.setQuantidade(i.getQuantidade());
                    i.setQuantidade(0.0);
                    itensRastreio.add(lote);
                    if (!ToolMethods.isEquals((Object[])new Object[]{quantidadePendente <= 0.0})) continue;
                    break;
                }
            }
            nfItem.setLotes(itensRastreio);
        }
    }
}

