/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.utils;

import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoAutenticacao;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoEmissao;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.login.LoginAutorizacaoController;
import com.touchcomp.touchnfce.controller.splash.impl.SplashCancelaNFCe;
import com.touchcomp.touchnfce.exceptions.ExceptionSincronizacao;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCePagamento;
import com.touchcomp.touchnfce.model.TipoEmissaoNFe;
import com.touchcomp.touchnfce.service.impl.ServiceNFCe;
import com.touchcomp.touchnfce.sinc.receive.SincOthers;
import com.touchcomp.touchnfce.tasks.utils.UtilConsultaStatusNFCe;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import com.touchcomp.touchnfce.utils.UtilPermissaoUsuario;
import com.touchcomp.touchnfce.utils.pedido.UtilPedido;
import com.touchcomp.touchnfce.utils.sitef.UtilSitefPagamento;
import java.util.HashMap;
import java.util.Optional;
import javafx.scene.control.ButtonType;

public class UtilNFCeCancelamento {
    public static void confirmaCancelamentoNFCe(NFCe selected) throws Exception {
        if (!UtilNFCeCancelamento.checaPermissao(selected)) {
            return;
        }
        UtilNFCeCancelamento.reabrirCuponsDescontoAplicados(selected);
        boolean realizarCancSefaz = true;
        if (selected.getEnviado().equals((short)0)) {
            boolean bl = realizarCancSefaz = !UtilNFCeCancelamento.confirmaExcluiNFCe(selected);
        }
        if (realizarCancSefaz) {
            UtilNFCeCancelamento.confirmaCancNFCeSefaz(selected);
        }
        UtilNFCeCancelamento.atualizaSitPedido(selected);
    }

    private static boolean checaPermissao(NFCe selected) {
        if (UtilPermissaoUsuario.isPermitidoCancelarNFCeItem()) {
            return true;
        }
        HashMap<String, EnumConstNFCeTipoAutenticacao> h = new HashMap<String, EnumConstNFCeTipoAutenticacao>();
        h.put("tipo_autenticacao", EnumConstNFCeTipoAutenticacao.AUTENTICACAO_CANCELAMENTO);
        LoginAutorizacaoController loginController = (LoginAutorizacaoController)Main.get().showDialog(Controllers.LOGIN_AUTORIZACAO, h);
        if (loginController.getUsuario() == null) {
            Alerts.showAlertError("Voc\u00ea n\u00e3o possui autoriza\u00e7\u00e3o para realizar essa opera\u00e7\u00e3o");
            return false;
        }
        UtilPermissaoUsuario.createAndAddLogNotExists(loginController.getUsuario(), EnumConstNFCeTipoAutenticacao.AUTENTICACAO_CANCELAMENTO, selected, null);
        return true;
    }

    private static void atualizaSitPedido(NFCe vo) {
        if (vo.getPedido() != null) {
            UtilPedido.atualizaSituacaoPedido(vo.getPedido().getIdentificadorERP(), StaticObjects.getOpcoes().getSituacaoPedidosCad().getIdentificador());
        }
    }

    private static void confirmaCancNFCeSefaz(NFCe selected) throws Exception {
        Optional<ButtonType> resp = Alerts.showQuestion("Deseja realmente cancelar?");
        if (!resp.isPresent() || resp.get() != ButtonType.OK) {
            return;
        }
        String motivo = "";
        if (selected.getNfCeCancelamento() != null) {
            motivo = selected.getNfCeCancelamento().getMotivo();
        }
        if (selected.getInutilizacaoNFe() != null) {
            motivo = selected.getInutilizacaoNFe().getJustificativa();
        }
        if ((motivo = Alerts.showAlertInput("Informe o justificativa do cancelamento.", motivo)) == null || motivo.length() <= 15) {
            Alerts.showAlertInfo("A justificativa deve possuir ao menos 15 caracteres.");
            return;
        }
        SplashCancelaNFCe splashCancelaNFCe = new SplashCancelaNFCe();
        splashCancelaNFCe.setNfce(selected);
        splashCancelaNFCe.setJustificativa(motivo);
        splashCancelaNFCe.showAndWait();
        if (splashCancelaNFCe.getException() != null) {
            try {
                throw splashCancelaNFCe.getException();
            }
            catch (Throwable ex) {
                throw new Exception(ex);
            }
        }
        ServiceNFCe service = Main.getBean(ServiceNFCe.class);
        selected = (NFCe)service.get(selected.getIdentificador());
        if (selected.getInutilizacaoNFe() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Status: ");
            sb.append(selected.getInutilizacaoNFe().getStatus());
            sb.append(" -  ");
            sb.append(selected.getInutilizacaoNFe().getMotivo());
            EnumConstNFeStatus status = EnumConstNFeStatus.getByCodigo((Integer)selected.getInutilizacaoNFe().getStatus());
            if (status != null && EnumConstNFeStatus.isStatusInutilizada((EnumConstNFeStatus)status)) {
                UtilNFCeCancelamento.cancelarPagamentosCDC(selected);
            }
            Alerts.showAlertInfo(sb.toString());
        }
        service.save(selected);
    }

    private static void cancelarPagamentosCDC(NFCe nfce) {
        for (NFCePagamento n : nfce.getPagamentos()) {
            int retorno;
            if (n.getNfcePagamentoCDC() == null || !n.getNfcePagamentoCDC().getStatus().equals((short)0) || (retorno = new UtilSitefPagamento().finalizarTransacaoSiTef(0, n.getSerialForSinc(), nfce.getDataEmissao(), nfce.getDataEmissao())) != 0) continue;
            n.getNfcePagamentoCDC().setStatus((short)2);
        }
    }

    private static boolean confirmaExcluiNFCe(NFCe selected) throws Exception {
        ServiceNFCe service = Main.getBean(ServiceNFCe.class);
        if (ToolMethods.isAffirmative((Number)selected.getEnviado())) {
            return false;
        }
        if (service.getProximoNumero(selected.getNfCeCaixa(), selected.getModeloDocFiscal()) - selected.getNumero() > 1L) {
            return false;
        }
        TipoEmissaoNFe tipoEmissao = UtilNFCe.getTipoEmissaoNFe(selected);
        if (!tipoEmissao.getCodigo().equals(EnumConstNFeTipoEmissao.CONTIGENCIA_OFFLINE.getValue())) {
            try {
                selected = UtilConsultaStatusNFCe.execute(StaticObjects.getOpcoes(), selected);
                if (!ToolMethods.isEquals((Object)EnumConstNFeStatus.getByCodigo((Integer)selected.getStatus()), (Object)EnumConstNFeStatus.REJ_NFE_NAO_CONSTA_BASE_DADOS_SEFAZ)) {
                    Alerts.showAlertError("A nota fiscal j\u00e1 se encontra na base de dados da Sefaz, por\u00e9m seu status n\u00e3o estava atualizado.\n Ser\u00e1 necess\u00e1rio informar uma justificativa");
                    return false;
                }
            }
            catch (Exception e) {
                TLogger.get(UtilNFCeCancelamento.class).error((Throwable)e);
                Alerts.showAlertError("Houve um erro ao consultar a nota na Sefaz.\nSer\u00e1 necess\u00e1rio uma nova tentiva de cancelamento.\nCaso a Sefaz esteja fora do ar, aguarde o retorno da mesma.\n" + e.getMessage());
                throw e;
            }
        }
        UtilNFCe.delete(selected);
        return true;
    }

    private TipoEmissaoNFe getTipoEmissaoNFe() {
        return StaticObjects.getNfceAberta().getPeriodoEmissaoNFCe() != null ? StaticObjects.getNfceAberta().getPeriodoEmissaoNFCe().getTipoEmissaoNfe() : StaticObjects.getNfceAberta().getPeriodoEmissaoNFe().getTipoEmissaoNfe();
    }

    private static void reabrirCuponsDescontoAplicados(NFCe nfce) throws ExceptionSincronizacao {
        if (nfce != null && nfce.getPagamentos() != null) {
            for (NFCePagamento pag : nfce.getPagamentos()) {
                if (pag.getSerialForSincCupomDesconto() == null || pag.getSerialForSincCupomDesconto().isEmpty()) continue;
                SincOthers.abrirCupomDesconto(pag.getSerialForSincCupomDesconto());
            }
        }
    }
}

