/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.utils.pedido;

import com.touchcomp.basementorrules.calculorateio.CompRuleCalcRateioPercValor;
import com.touchcomp.basementorrules.calculorateio.SourcePercValor;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.model.ItemPedido;
import com.touchcomp.touchnfce.model.Pedido;
import java.util.LinkedList;
import java.util.List;

public class UtilPedidoCalculosFrete {
    void ratearFrete(Pedido pedido) throws Exception {
        List<SourcePercValor> itens = this.converterValores(pedido);
        Double percFrete = pedido.getPercFreteInf();
        Double valorFrete = pedido.getValorFreteInf();
        Short tipoFrete = pedido.getTipoFreteInf();
        CompRuleCalcRateioPercValor com = new CompRuleCalcRateioPercValor();
        if (tipoFrete == 0) {
            com.ratearPercentual(itens, percFrete);
        } else {
            com.ratearValor(itens, valorFrete);
        }
    }

    private List<SourcePercValor> converterValores(Pedido pedido) {
        LinkedList<SourcePercValor> ret = new LinkedList<SourcePercValor>();
        for (ItemPedido item : pedido.getItemPedido()) {
            ret.add(new SourcePercValorItem(this, item));
        }
        return ret;
    }

    class SourcePercValorItem
    implements SourcePercValor {
        ItemPedido item;

        public SourcePercValorItem(UtilPedidoCalculosFrete this$0, ItemPedido item) {
            this.item = item;
        }

        public Double getBaseCalc() {
            return this.item.getValorTotalBruto();
        }

        public Double getValor() {
            return this.item.getValorFrete();
        }

        public void setPercentual(Double valor) {
            this.item.setPercFrete(valor);
        }

        public void setValor(Double valor) {
            this.item.setValorFrete(valor);
        }

        public Double getValorMinimo() {
            return this.item.getValorMinimo() * this.item.getQuantidadeTotal();
        }

        public boolean isPermitirRateio() {
            return !ToolMethods.isEquals((Object)this.item.getFreteItem(), (Object)1);
        }

        public Double getPercentual() {
            return this.item.getPercFrete();
        }
    }
}

