/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.utils.pedido;

import com.touchcomp.basementorrules.calculorateio.CompRuleCalcRateioPercValor;
import com.touchcomp.basementorrules.calculorateio.SourcePercValor;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.model.ItemPedido;
import com.touchcomp.touchnfce.model.Pedido;
import java.util.LinkedList;
import java.util.List;

public class UtilPedidoCalculosSeguro {
    void ratearSeguro(Pedido pedido) throws Exception {
        List<SourcePercValor> itens = this.converterValores(pedido);
        Double percSeguro = pedido.getPercSeguroInf();
        Double valorSeguro = pedido.getValorSeguroInf();
        Short tipoSeguro = pedido.getTipoSeguroInf();
        CompRuleCalcRateioPercValor com = new CompRuleCalcRateioPercValor();
        if (tipoSeguro == 0) {
            com.ratearPercentual(itens, percSeguro);
        } else {
            com.ratearValor(itens, valorSeguro);
        }
    }

    private List<SourcePercValor> converterValores(Pedido pedido) {
        LinkedList<SourcePercValor> ret = new LinkedList<SourcePercValor>();
        for (ItemPedido item : pedido.getItemPedido()) {
            ret.add(new SourcePercValorItem(this, item));
        }
        return ret;
    }

    class SourcePercValorItem
    implements SourcePercValor {
        ItemPedido item;

        public SourcePercValorItem(UtilPedidoCalculosSeguro this$0, ItemPedido item) {
            this.item = item;
        }

        public Double getBaseCalc() {
            return this.item.getValorTotalBruto();
        }

        public Double getValor() {
            return this.item.getValorSeguro();
        }

        public void setPercentual(Double valor) {
            this.item.setPercSeguro(valor);
        }

        public void setValor(Double valor) {
            this.item.setValorSeguro(valor);
        }

        public Double getValorMinimo() {
            return this.item.getValorMinimo() * this.item.getQuantidadeTotal();
        }

        public boolean isPermitirRateio() {
            return !ToolMethods.isEquals((Object)this.item.getSeguroItem(), (Object)1);
        }

        public Double getPercentual() {
            return this.item.getPercSeguro();
        }
    }
}

