/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.examples.vo;

import com.touchcomp.basementor.model.examples.DefaultEntitiesTest;
import com.touchcomp.basementor.model.examples.vo.CentroCustoTest;
import com.touchcomp.basementor.model.examples.vo.CentroEstoqueTest;
import com.touchcomp.basementor.model.examples.vo.EmpresaTest;
import com.touchcomp.basementor.model.examples.vo.GradeCorTest;
import com.touchcomp.basementor.model.examples.vo.ModeloFichaTecnicaTest;
import com.touchcomp.basementor.model.examples.vo.NaturezaRequisicaoTest;
import com.touchcomp.basementor.model.examples.vo.NotaFiscalTerceirosTest;
import com.touchcomp.basementor.model.examples.vo.ProdutoTest;
import com.touchcomp.basementor.model.examples.vo.UsuarioTest;
import com.touchcomp.basementor.model.vo.AjusteEstoque;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Cor;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FichaTecnicaLoteFabricacao;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemRequisicao;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.ModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.ValoresFichaLoteFab;
import java.util.List;

public class RequisicaoTest
extends DefaultEntitiesTest<Requisicao> {
    @Override
    public Requisicao getDefault() {
        Requisicao vo = new Requisicao();
        vo.setIdentificador(0L);
        vo.setDataCadastro(this.dataHoraAtual());
        vo.setDataAtualizacao(this.dataHoraAtualSQL());
        vo.setDataRequisicao(this.dataHoraAtual());
        vo.setNotaFiscalTerc((NotaFiscalTerceiros)this.getDefaultTest(NotaFiscalTerceirosTest.class));
        vo.setEmpresa((Empresa)this.getDefaultTest(EmpresaTest.class));
        vo.setItensRequisicao(this.getItensRequisicao(vo));
        vo.setItensRequisicao(this.getItensRequisicao(vo));
        vo.setObservacao("teste");
        vo.setTipoRequisicao((short)0);
        return vo;
    }

    private List<ItemRequisicao> getItensRequisicao(Requisicao param) {
        ItemRequisicao vo = new ItemRequisicao();
        vo.setIdentificador(0L);
        vo.setRequisicao(param);
        vo.setProduto((Produto)this.getDefaultTest(ProdutoTest.class));
        vo.setQuantidadeTotal(0.0);
        vo.setCentroCusto((CentroCusto)this.getDefaultTest(CentroCustoTest.class));
        vo.setGradeItemRequisicao(this.getGradeItemRequisicao(vo));
        vo.setCentroEstoque((CentroEstoque)this.getDefaultTest(CentroEstoqueTest.class));
        vo.setNaturezaRequisicao((NaturezaRequisicao)this.getDefaultTest(NaturezaRequisicaoTest.class));
        vo.setProdutoSubstituto((Produto)this.getDefaultTest(ProdutoTest.class));
        vo.setObservacoes("teste");
        vo.setValorPrecoMedioCont(0.0);
        return this.toList(vo);
    }

    private List<GradeItemRequisicao> getGradeItemRequisicao(ItemRequisicao param) {
        GradeItemRequisicao vo = new GradeItemRequisicao();
        vo.setIdentificador(0L);
        vo.setQuantidade(3.0);
        vo.setGradeCor((GradeCor)this.getDefaultTest(GradeCorTest.class));
        vo.setLoteFabricacao(this.getLoteFabricacao(vo));
        vo.setItemRequisicao(param);
        vo.setDataMovimentacao(this.dataHoraAtual());
        vo.setEmpresa((Empresa)this.getDefaultTest(EmpresaTest.class));
        vo.setCentroEstoque((CentroEstoque)this.getDefaultTest(CentroEstoqueTest.class));
        return this.toList(vo);
    }

    private LoteFabricacao getLoteFabricacao(GradeItemRequisicao param) {
        LoteFabricacao vo = new LoteFabricacao();
        vo.setIdentificador(0L);
        vo.setLoteFabricacao("teste");
        vo.setDataFabricacao(this.dataHoraAtual());
        vo.setDataValidade(this.dataHoraAtual());
        vo.setProduto((Produto)this.getDefaultTest(ProdutoTest.class));
        vo.setStatusLoteFabricacao(vo.getProduto().getStatusLoteFabricacao());
        vo.setLoteBloqueado(vo.getProduto().getStatusLoteFabricacao().getLoteBloqueado());
        vo.setUnico((short)0);
        vo.setNaoGerarLoteAutomatico((short)0);
        vo.setDataAtualizacao(this.dataHoraAtualSQL());
        vo.setFichaTecnica(this.getFichaTecnica(vo));
        vo.setLoteBloqueado((short)0);
        vo.setUsuario((Usuario)this.getDefaultTest(UsuarioTest.class));
        vo.setDataLiberacao(this.dataHoraAtual());
        vo.setCodigoAgregacao("teste");
        return vo;
    }

    private List<FichaTecnicaLoteFabricacao> getFichaTecnica(LoteFabricacao param) {
        FichaTecnicaLoteFabricacao vo = new FichaTecnicaLoteFabricacao();
        vo.setIdentificador(0L);
        vo.setLoteFabricacao(param);
        vo.setModeloFichaTecnica((ModeloFichaTecnica)this.getDefaultTest(ModeloFichaTecnicaTest.class));
        vo.setUsuario((Usuario)this.getDefaultTest(UsuarioTest.class));
        vo.setDataModificacao(this.dataHoraAtualSQL());
        vo.setValoresFicha(this.getValoresFicha(vo));
        vo.setAjusteEstoque(this.getAjusteEstoque(vo));
        return this.toList(vo);
    }

    private List<ValoresFichaLoteFab> getValoresFicha(FichaTecnicaLoteFabricacao param) {
        ValoresFichaLoteFab vo = new ValoresFichaLoteFab();
        vo.setIdentificador(0L);
        vo.setFichaTecnica(param);
        vo.setChave("teste");
        vo.setValor("teste");
        vo.setValorObrigatorio((short)0);
        return this.toList(vo);
    }

    private AjusteEstoque getAjusteEstoque(FichaTecnicaLoteFabricacao param) {
        AjusteEstoque vo = new AjusteEstoque();
        vo.setIdentificador(0L);
        vo.setQtdeBruto(0.0);
        vo.setQtdeLiquida(0.0);
        vo.setQtdeUmidade(0.0);
        return vo;
    }

    public Requisicao buildRequisicaoComp() {
        Requisicao obj = new Requisicao();
        Produto produtoCaneta = this.newProduto(1L, "Caneta");
        Produto produtoMouse = this.newProduto(2L, "Mouse");
        CentroCusto cCustoA = this.newCentroCusto(1L, "C. Custo A");
        CentroCusto cCustoB = this.newCentroCusto(2L, "C. Custo B");
        GradeCor azul = this.newGradeCor(1L, "Azul");
        GradeCor vermelho = this.newGradeCor(2L, "vermelho");
        NaturezaRequisicao naturezaA = this.newNaturezaRequisicao(1L, "Natureza A");
        NaturezaRequisicao naturezaB = this.newNaturezaRequisicao(2L, "Natureza B");
        CentroEstoque cEstA = this.newCentroEstoque(1L, "C. Estoque A");
        CentroEstoque cEstB = this.newCentroEstoque(2L, "C. Estoque B");
        Empresa empresaA = this.newEmpresa(1L, "Empresa A");
        Empresa empresaB = this.newEmpresa(2L, "Empresa B");
        LoteFabricacao loteA = this.newLoteFabricacao(1L, "lote A");
        LoteFabricacao loteB = this.newLoteFabricacao(2L, "lote B");
        obj.getItensRequisicao().add(this.newItemRequisicao(produtoCaneta, cCustoA, this.newGradeItemRequisicao(azul, 1.0, cEstA, empresaA, loteA), naturezaA, cEstA));
        obj.getItensRequisicao().add(this.newItemRequisicao(produtoCaneta, cCustoA, this.newGradeItemRequisicao(azul, 2.0, cEstA, empresaA, loteA), naturezaA, cEstA));
        obj.getItensRequisicao().add(this.newItemRequisicao(produtoCaneta, cCustoA, this.newGradeItemRequisicao(azul, 3.0, cEstA, empresaA, loteB), naturezaA, cEstA));
        obj.getItensRequisicao().add(this.newItemRequisicao(produtoCaneta, cCustoA, this.newGradeItemRequisicao(azul, 4.0, cEstA, empresaA, loteB), naturezaA, cEstA));
        obj.getItensRequisicao().add(this.newItemRequisicao(produtoCaneta, cCustoA, this.newGradeItemRequisicao(azul, 5.0, cEstA, empresaA, loteB), naturezaA, cEstB));
        obj.getItensRequisicao().add(this.newItemRequisicao(produtoCaneta, cCustoA, this.newGradeItemRequisicao(vermelho, 6.0, cEstA, empresaA, loteB), naturezaA, cEstB));
        obj.getItensRequisicao().add(this.newItemRequisicao(produtoMouse, cCustoA, this.newGradeItemRequisicao(azul, 7.0, cEstA, empresaA, loteB), naturezaA, cEstB));
        obj.getItensRequisicao().add(this.newItemRequisicao(produtoMouse, cCustoB, this.newGradeItemRequisicao(azul, 8.0, cEstA, empresaA, loteB), naturezaA, cEstB));
        obj.getItensRequisicao().add(this.newItemRequisicao(produtoMouse, cCustoB, this.newGradeItemRequisicao(azul, 9.0, cEstA, empresaB, loteB), naturezaA, cEstB));
        obj.getItensRequisicao().add(this.newItemRequisicao(produtoMouse, cCustoB, this.newGradeItemRequisicao(azul, 10.0, cEstA, empresaB, loteB), naturezaB, cEstB));
        obj.getItensRequisicao().add(this.newItemRequisicao(produtoMouse, cCustoB, this.newGradeItemRequisicao(azul, 0.0, cEstA, empresaB, loteB), naturezaB, cEstB));
        return obj;
    }

    private Produto newProduto(Long id, String nome) {
        Produto obj = new Produto();
        obj.setIdentificador(id);
        obj.setNome(nome);
        return obj;
    }

    private Empresa newEmpresa(Long id, String nome) {
        Empresa obj = new Empresa();
        obj.setIdentificador(id);
        obj.setSiglaEmpresa(nome);
        return obj;
    }

    private LoteFabricacao newLoteFabricacao(Long id, String nome) {
        LoteFabricacao obj = new LoteFabricacao();
        obj.setIdentificador(id);
        obj.setLoteFabricacao(nome);
        return obj;
    }

    private CentroCusto newCentroCusto(Long id, String nome) {
        CentroCusto obj = new CentroCusto();
        obj.setIdentificador(id);
        obj.setNome(nome);
        return obj;
    }

    private GradeCor newGradeCor(Long id, String nome) {
        GradeCor gc = new GradeCor();
        gc.setIdentificador(id);
        Cor c = new Cor();
        c.setNome(nome);
        c.setIdentificador(id);
        gc.setCor(c);
        return gc;
    }

    private GradeItemRequisicao newGradeItemRequisicao(GradeCor gc, Double qtd, CentroEstoque ce, Empresa emp, LoteFabricacao lt) {
        GradeItemRequisicao gi = new GradeItemRequisicao();
        gi.setGradeCor(gc);
        gi.setQuantidade(qtd);
        gi.setCentroEstoque(ce);
        gi.setEmpresa(emp);
        gi.setLoteFabricacao(lt);
        return gi;
    }

    private NaturezaRequisicao newNaturezaRequisicao(Long id, String nome) {
        NaturezaRequisicao obj = new NaturezaRequisicao();
        obj.setIdentificador(id);
        obj.setDescricao(nome);
        return obj;
    }

    private CentroEstoque newCentroEstoque(Long id, String nome) {
        CentroEstoque obj = new CentroEstoque();
        obj.setIdentificador(id);
        obj.setDescricao(nome);
        return obj;
    }

    public ItemRequisicao newItemRequisicao(Produto p, CentroCusto centroCusto, GradeItemRequisicao grade, NaturezaRequisicao natureza, CentroEstoque centroEstoque) {
        ItemRequisicao obj = new ItemRequisicao();
        obj.setProduto(p);
        obj.setCentroCusto(centroCusto);
        obj.getGradeItemRequisicao().add(grade);
        obj.setNaturezaRequisicao(natureza);
        obj.setCentroEstoque(centroEstoque);
        return obj;
    }
}

